/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_7.handlers;

import io.fabric8.kubernetes.api.model.v4_7.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_7.KubernetesList;
import io.fabric8.kubernetes.api.model.v4_7.KubernetesListBuilder;
import io.fabric8.kubernetes.clnt.v4_7.Config;
import io.fabric8.kubernetes.clnt.v4_7.Handlers;
import io.fabric8.kubernetes.clnt.v4_7.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_7.Watch;
import io.fabric8.kubernetes.clnt.v4_7.Watcher;
import io.fabric8.kubernetes.clnt.v4_7.dsl.internal.KubernetesListOperationsImpl;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class KubernetesListHandler
implements ResourceHandler<KubernetesList, KubernetesListBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesListHandler.class);

    @Override
    public String getKind() {
        return io.fabric8.kubernetes.api.model.v4_7.Service.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public KubernetesList create(OkHttpClient client, Config config, String namespace, KubernetesList item) {
        return new KubernetesListOperationsImpl(client, config, namespace, null, true, false, false, item, null).create(new KubernetesList[0]);
    }

    @Override
    public KubernetesList replace(OkHttpClient client, Config config, String namespace, KubernetesList item) {
        ArrayList<HasMetadata> replacedItems = new ArrayList<HasMetadata>();
        for (HasMetadata metadata : item.getItems()) {
            ResourceHandler handler = Handlers.get(item.getKind(), item.getApiVersion());
            if (handler == null) {
                LOGGER.warn("No handler found for:" + item.getKind() + ". Ignoring");
                continue;
            }
            replacedItems.add(handler.replace(client, config, namespace, metadata));
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder(item).withItems(replacedItems)).build();
    }

    @Override
    public KubernetesList reload(OkHttpClient client, Config config, String namespace, KubernetesList item) {
        ArrayList<HasMetadata> replacedItems = new ArrayList<HasMetadata>();
        for (HasMetadata metadata : item.getItems()) {
            ResourceHandler handler = Handlers.get(item.getKind(), item.getApiVersion());
            if (handler == null) {
                LOGGER.warn("No handler found for:" + item.getKind() + ". Ignoring");
                continue;
            }
            replacedItems.add(handler.reload(client, config, namespace, metadata));
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder(item).withItems(replacedItems)).build();
    }

    @Override
    public KubernetesListBuilder edit(KubernetesList item) {
        return new KubernetesListBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, KubernetesList item) {
        return new KubernetesListOperationsImpl(client, config, namespace, null, cascading, false, false, item, null).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, KubernetesList item, Watcher<KubernetesList> watcher) {
        throw new UnsupportedOperationException("Watch is not supported on KubernetesList.");
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, KubernetesList item, String resourceVersion, Watcher<KubernetesList> watcher) {
        throw new UnsupportedOperationException("Watch is not supported on KubernetesList.");
    }

    @Override
    public KubernetesList waitUntilReady(OkHttpClient client, Config config, String namespace, KubernetesList item, long amount, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException("Watch is not supported on KubernetesList.");
    }

    @Override
    public KubernetesList waitUntilCondition(OkHttpClient client, Config config, String namespace, KubernetesList item, Predicate<KubernetesList> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException("Watch is not supported on KubernetesList.");
    }
}

