/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_7.dsl.internal;

import io.fabric8.kubernetes.clnt.v4_7.Config;
import io.fabric8.kubernetes.clnt.v4_7.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_7.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v4_7.utils.BlockingInputStreamPumper;
import io.fabric8.kubernetes.clnt.v4_7.utils.InputStreamPumper;
import io.fabric8.kubernetes.clnt.v4_7.utils.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogWatchCallback
implements LogWatch,
Callback,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogWatchCallback.class);
    private final Config config;
    private final OutputStream out;
    private final PipedInputStream output;
    private final Set<Closeable> toClose = new LinkedHashSet<Closeable>();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue(1);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private InputStreamPumper pumper;

    @Deprecated
    public LogWatchCallback(OutputStream out) {
        this(new Config(), out);
    }

    public LogWatchCallback(Config config, OutputStream out) {
        this.config = config;
        if (out == null) {
            this.out = new PipedOutputStream();
            this.output = new PipedInputStream();
            this.toClose.add(this.out);
            this.toClose.add(this.output);
        } else {
            this.out = out;
            this.output = null;
        }
        if (this.out instanceof PipedOutputStream && this.output != null) {
            try {
                this.output.connect((PipedOutputStream)this.out);
            }
            catch (IOException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }
    }

    @Override
    public void close() {
        this.cleanUp();
    }

    private void cleanUp() {
        try {
            if (!this.closed.compareAndSet(false, true)) {
                return;
            }
            Utils.closeQuietly(this.pumper);
            Utils.shutdownExecutorService(this.executorService);
        }
        finally {
            Utils.closeQuietly(this.toClose);
        }
    }

    public void waitUntilReady() {
        if (!Utils.waitUntilReady(this.queue, this.config.getRequestTimeout(), TimeUnit.MILLISECONDS) && LOGGER.isDebugEnabled()) {
            LOGGER.warn("Log watch request has not been opened within: " + this.config.getRequestTimeout() + " millis.");
        }
    }

    @Override
    public InputStream getOutput() {
        return this.output;
    }

    public void onFailure(Call call, IOException ioe) {
        if (this.closed.get()) {
            return;
        }
        LOGGER.error("Log Callback Failure.", (Throwable)ioe);
        if (!this.started.get()) {
            this.queue.add(ioe);
        }
    }

    public void onResponse(Call call, Response response) throws IOException {
        this.pumper = new BlockingInputStreamPumper(response.body().byteStream(), input -> {
            try {
                this.out.write((byte[])input);
            }
            catch (IOException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }, () -> response.close());
        this.executorService.submit(this.pumper);
        this.started.set(true);
        this.queue.add(true);
    }
}

