/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_7.utils;

import io.fabric8.kubernetes.clnt.v4_7.Config;
import io.fabric8.kubernetes.clnt.v4_7.RequestConfig;
import io.fabric8.kubernetes.clnt.v4_7.utils.Utils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ImpersonatorInterceptor
implements Interceptor {
    private final Config config;

    public ImpersonatorInterceptor(Config config) {
        this.config = config;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        RequestConfig requestConfig = this.config.getRequestConfig();
        if (Utils.isNotNullOrEmpty(requestConfig.getImpersonateUsername())) {
            Map<String, List<String>> impersonateExtras;
            Request.Builder requestBuilder = chain.request().newBuilder();
            requestBuilder.addHeader("Impersonate-User", requestConfig.getImpersonateUsername());
            String[] impersonateGroups = requestConfig.getImpersonateGroups();
            if (Utils.isNotNullOrEmpty(impersonateGroups)) {
                for (String string : impersonateGroups) {
                    requestBuilder.addHeader("Impersonate-Group", string);
                }
            }
            if (Utils.isNotNullOrEmpty(impersonateExtras = requestConfig.getImpersonateExtras())) {
                Set<String> keys = impersonateExtras.keySet();
                for (Object e : keys) {
                    List<String> values = impersonateExtras.get(e);
                    if (values == null) continue;
                    for (String value : values) {
                        requestBuilder.addHeader("Impersonate-Extra-" + e, value);
                    }
                }
            }
            request = requestBuilder.build();
        }
        return chain.proceed(request);
    }
}

