/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_7.server.mock;

import io.fabric8.kubernetes.clnt.v4_7.server.mock.KubernetesAttributesExtractor;
import io.fabric8.kubernetes.clnt.v4_7.server.mock.KubernetesResponseComposer;
import io.fabric8.kubernetes.clnt.v4_7.utils.Serialization;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.crud.AttributeExtractor;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.mockwebserver.crud.CrudDispatcher;
import io.fabric8.mockwebserver.crud.ResponseComposer;
import java.util.ArrayList;
import java.util.Map;
import okhttp3.mockwebserver.MockResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCrudDispatcher
extends CrudDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesCrudDispatcher.class);

    public KubernetesCrudDispatcher() {
        this(new KubernetesAttributesExtractor(), new KubernetesResponseComposer());
    }

    public KubernetesCrudDispatcher(AttributeExtractor attributeExtractor, ResponseComposer responseComposer) {
        super(new Context(Serialization.jsonMapper()), attributeExtractor, responseComposer);
    }

    public MockResponse handleGet(String path) {
        MockResponse response = new MockResponse();
        ArrayList items = new ArrayList();
        AttributeSet query = this.attributeExtractor.extract(path);
        for (Map.Entry entry : this.map.entrySet()) {
            if (!((AttributeSet)entry.getKey()).matches(query)) continue;
            LOGGER.debug("Entry found for query {} : {}", (Object)query, entry);
            items.add(entry.getValue());
        }
        if (query.containsKey("name")) {
            if (!items.isEmpty()) {
                response.setBody((String)items.get(0));
                response.setResponseCode(200);
            } else {
                response.setResponseCode(404);
            }
        } else {
            response.setBody(this.responseComposer.compose(items));
            response.setResponseCode(200);
        }
        return response;
    }
}

