/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_7.informers.cache;

import io.fabric8.kubernetes.clnt.v4_7.informers.ResourceEventHandler;
import io.fabric8.kubernetes.clnt.v4_7.informers.cache.DeltaFIFO;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorListener<T>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ProcessorListener.class);
    private long resyncPeriodInMillis;
    private ZonedDateTime nextResync;
    private BlockingQueue<Notification> queue;
    private ResourceEventHandler<T> handler;

    public ProcessorListener(ResourceEventHandler<T> handler, long resyncPeriodInMillis) {
        this.resyncPeriodInMillis = resyncPeriodInMillis;
        this.handler = handler;
        this.queue = new LinkedBlockingQueue<Notification>();
        this.determineNextResync(ZonedDateTime.now());
    }

    @Override
    public void run() {
        Boolean isValidNotification;
        do {
            isValidNotification = Boolean.FALSE;
            String operationType = "";
            try {
                Notification notification;
                Notification obj = this.queue.take();
                if (obj instanceof UpdateNotification) {
                    isValidNotification = Boolean.TRUE;
                    operationType = "UPDATE";
                    notification = (UpdateNotification)obj;
                    this.handler.onUpdate(((UpdateNotification)notification).getOldObj(), ((UpdateNotification)notification).getNewObj());
                    continue;
                }
                if (obj instanceof AddNotification) {
                    isValidNotification = Boolean.TRUE;
                    operationType = "ADD";
                    notification = (AddNotification)obj;
                    this.handler.onAdd(((AddNotification)notification).getNewObj());
                    continue;
                }
                if (!(obj instanceof DeleteNotification)) continue;
                isValidNotification = Boolean.TRUE;
                operationType = "DELETE";
                Object deletedObj = ((DeleteNotification)obj).getOldObj();
                if (deletedObj instanceof DeltaFIFO.DeletedFinalStateUnknown) {
                    this.handler.onDelete(((DeltaFIFO.DeletedFinalStateUnknown)deletedObj).getObj(), true);
                    continue;
                }
                this.handler.onDelete(deletedObj, false);
            }
            catch (InterruptedException e) {
                log.error("processor interrupted: {}", (Object)e.getMessage());
                return;
            }
            catch (Throwable t) {
                log.error("Failed invoking " + operationType + " event handler: {}", (Object)t.getMessage());
            }
        } while (!Boolean.FALSE.equals(isValidNotification));
        throw new RuntimeException("Unrecognized notification.");
    }

    public void add(Notification<T> obj) {
        if (obj == null) {
            return;
        }
        this.queue.add(obj);
    }

    public void determineNextResync(ZonedDateTime now) {
        this.nextResync = now.plus(this.resyncPeriodInMillis, ChronoUnit.MILLIS);
    }

    public boolean shouldResync(ZonedDateTime now) {
        return this.resyncPeriodInMillis != 0L && (now.isAfter(this.nextResync) || now.equals(this.nextResync));
    }

    public static final class DeleteNotification<T>
    extends Notification<T> {
        private T oldObj;

        public DeleteNotification(T oldObj) {
            this.oldObj = oldObj;
        }

        T getOldObj() {
            return this.oldObj;
        }
    }

    public static final class AddNotification<T>
    extends Notification<T> {
        private T newObj;

        public AddNotification(T newObj) {
            this.newObj = newObj;
        }

        T getNewObj() {
            return this.newObj;
        }
    }

    public static final class UpdateNotification<T>
    extends Notification<T> {
        private T oldObj;
        private T newObj;

        public UpdateNotification(T oldObj, T newObj) {
            this.oldObj = oldObj;
            this.newObj = newObj;
        }

        T getOldObj() {
            return this.oldObj;
        }

        T getNewObj() {
            return this.newObj;
        }
    }

    public static class Notification<T> {
    }
}

