/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_7.handlers;

import io.fabric8.kubernetes.api.model.v4_7.Service;
import io.fabric8.kubernetes.api.model.v4_7.ServiceBuilder;
import io.fabric8.kubernetes.clnt.v4_7.Config;
import io.fabric8.kubernetes.clnt.v4_7.ResourceHandler;
import io.fabric8.kubernetes.clnt.v4_7.Watch;
import io.fabric8.kubernetes.clnt.v4_7.Watcher;
import io.fabric8.kubernetes.clnt.v4_7.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v4_7.dsl.ServiceResource;
import io.fabric8.kubernetes.clnt.v4_7.dsl.internal.ServiceOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ServiceHandler
implements ResourceHandler<Service, ServiceBuilder> {
    @Override
    public String getKind() {
        return Service.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public Service create(OkHttpClient client, Config config, String namespace, Service item) {
        return (Service)new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Service[0]);
    }

    @Override
    public Service replace(OkHttpClient client, Config config, String namespace, Service item) {
        return (Service)((ServiceResource)new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Service reload(OkHttpClient client, Config config, String namespace, Service item) {
        return (Service)((Gettable)((ServiceResource)new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ServiceBuilder edit(Service item) {
        return new ServiceBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Service item) {
        return (Boolean)new ServiceOperationsImpl(client, config, namespace).withItem(item).cascading(cascading).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Service item, Watcher<Service> watcher) {
        return (Watch)((ServiceResource)new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Service item, String resourceVersion, Watcher<Service> watcher) {
        return (Watch)((ServiceResource)new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Service waitUntilReady(OkHttpClient client, Config config, String namespace, Service item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Service)((ServiceResource)new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Service waitUntilCondition(OkHttpClient client, Config config, String namespace, Service item, Predicate<Service> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Service)((ServiceResource)new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

