/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_7.dsl.internal.uploadable;

import io.fabric8.kubernetes.clnt.v4_7.KubernetesClientException;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class PodUploadWebSocketListener
extends WebSocketListener {
    private static final byte FLAG_STDIN = 0;
    private static final long MAX_QUEUE_SIZE = 0x1000000L;
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private final AtomicReference<String> error = new AtomicReference();
    private final CountDownLatch readyLatch = new CountDownLatch(1);
    private final CountDownLatch completeLatch = new CountDownLatch(1);

    PodUploadWebSocketListener() {
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.webSocketRef.set(webSocket);
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        if (this.readyLatch.getCount() > 0L && bytes.size() == 1) {
            this.readyLatch.countDown();
        } else if (bytes.size() > 1) {
            this.error.set(bytes.substring(1).toString());
        }
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        this.completeLatch.countDown();
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        String responseBody = Optional.ofNullable(response.body()).map(rb -> {
            try {
                return rb.string();
            }
            catch (IOException e) {
                return e.getMessage();
            }
        }).orElse("");
        this.error.set(String.format("%s - %s%n%s", response.code(), response.message(), responseBody));
        while (this.readyLatch.getCount() > 0L) {
            this.readyLatch.countDown();
        }
        while (this.completeLatch.getCount() > 0L) {
            this.completeLatch.countDown();
        }
    }

    final void checkError() {
        if (this.error.get() != null && !this.error.get().trim().isEmpty()) {
            throw new KubernetesClientException(this.error.get());
        }
    }

    final void waitUntilReady(int timeoutSeconds) throws IOException, InterruptedException {
        if (!this.readyLatch.await(timeoutSeconds, TimeUnit.SECONDS)) {
            throw new IOException("Connection to server timed out");
        }
    }

    final void waitUntilComplete(int timeoutSeconds) throws IOException, InterruptedException {
        while (this.webSocketRef.get().queueSize() > 0L && this.completeLatch.getCount() > 0L) {
            this.checkError();
            Thread.sleep(50L);
        }
        this.webSocketRef.get().close(1000, "Operation completed");
        if (!this.completeLatch.await(timeoutSeconds, TimeUnit.SECONDS)) {
            throw new IOException("Upload operation timed out before completing");
        }
        this.checkError();
    }

    final void send(byte[] data, int length) {
        this.checkError();
        this.waitForQueue(length);
        byte[] toSend = new byte[length + 1];
        toSend[0] = 0;
        System.arraycopy(data, 0, toSend, 1, length);
        this.webSocketRef.get().send(ByteString.of((byte[])toSend));
    }

    final void waitForQueue(int length) {
        try {
            while (this.webSocketRef.get().queueSize() + (long)length > 0x1000000L && !Thread.interrupted()) {
                this.checkError();
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

