/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_7.storage;

import io.fabric8.kubernetes.api.builder.v4_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_7.storage.StorageClass;
import io.fabric8.kubernetes.api.model.v4_7.storage.StorageClassFluent;
import io.fabric8.kubernetes.api.model.v4_7.storage.StorageClassFluentImpl;

public class StorageClassBuilder
extends StorageClassFluentImpl<StorageClassBuilder>
implements VisitableBuilder<StorageClass, StorageClassBuilder> {
    StorageClassFluent<?> fluent;
    Boolean validationEnabled;

    public StorageClassBuilder() {
        this(true);
    }

    public StorageClassBuilder(Boolean validationEnabled) {
        this(new StorageClass(), validationEnabled);
    }

    public StorageClassBuilder(StorageClassFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StorageClassBuilder(StorageClassFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StorageClass(), validationEnabled);
    }

    public StorageClassBuilder(StorageClassFluent<?> fluent, StorageClass instance) {
        this(fluent, instance, true);
    }

    public StorageClassBuilder(StorageClassFluent<?> fluent, StorageClass instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAllowVolumeExpansion(instance.getAllowVolumeExpansion());
        fluent.withAllowedTopologies(instance.getAllowedTopologies());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withMountOptions(instance.getMountOptions());
        fluent.withParameters(instance.getParameters());
        fluent.withProvisioner(instance.getProvisioner());
        fluent.withReclaimPolicy(instance.getReclaimPolicy());
        fluent.withVolumeBindingMode(instance.getVolumeBindingMode());
        this.validationEnabled = validationEnabled;
    }

    public StorageClassBuilder(StorageClass instance) {
        this(instance, (Boolean)true);
    }

    public StorageClassBuilder(StorageClass instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAllowVolumeExpansion(instance.getAllowVolumeExpansion());
        this.withAllowedTopologies(instance.getAllowedTopologies());
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withMountOptions(instance.getMountOptions());
        this.withParameters(instance.getParameters());
        this.withProvisioner(instance.getProvisioner());
        this.withReclaimPolicy(instance.getReclaimPolicy());
        this.withVolumeBindingMode(instance.getVolumeBindingMode());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public StorageClass build() {
        StorageClass buildable = new StorageClass(this.fluent.isAllowVolumeExpansion(), this.fluent.getAllowedTopologies(), this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getMountOptions(), this.fluent.getParameters(), this.fluent.getProvisioner(), this.fluent.getReclaimPolicy(), this.fluent.getVolumeBindingMode());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StorageClassBuilder that = (StorageClassBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

