/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_7.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.v4_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_7.Nested;
import io.fabric8.kubernetes.api.model.v4_7.Duration;
import io.fabric8.kubernetes.api.model.v4_7.DurationBuilder;
import io.fabric8.kubernetes.api.model.v4_7.DurationFluentImpl;
import io.fabric8.kubernetes.api.model.v4_7.ObjectMeta;
import io.fabric8.kubernetes.api.model.v4_7.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v4_7.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v4_7.Quantity;
import io.fabric8.kubernetes.api.model.v4_7.metrics.v1beta1.NodeMetrics;
import io.fabric8.kubernetes.api.model.v4_7.metrics.v1beta1.NodeMetricsFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class NodeMetricsFluentImpl<A extends NodeMetricsFluent<A>>
extends BaseFluent<A>
implements NodeMetricsFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String timestamp;
    private Map<String, Quantity> usage;
    private DurationBuilder window;

    public NodeMetricsFluentImpl() {
    }

    public NodeMetricsFluentImpl(NodeMetrics instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withTimestamp(instance.getTimestamp());
        this.withUsage(instance.getUsage());
        this.withWindow(instance.getWindow());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public NodeMetricsFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public NodeMetricsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public NodeMetricsFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public NodeMetricsFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public NodeMetricsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    public A withTimestamp(String timestamp) {
        this.timestamp = timestamp;
        return (A)this;
    }

    @Override
    public Boolean hasTimestamp() {
        return this.timestamp != null;
    }

    @Override
    public A withNewTimestamp(String arg1) {
        return this.withTimestamp(new String(arg1));
    }

    @Override
    public A withNewTimestamp(StringBuilder arg1) {
        return this.withTimestamp(new String(arg1));
    }

    @Override
    public A withNewTimestamp(StringBuffer arg1) {
        return this.withTimestamp(new String(arg1));
    }

    @Override
    public A addToUsage(String key, Quantity value) {
        if (this.usage == null && key != null && value != null) {
            this.usage = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.usage.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToUsage(Map<String, Quantity> map) {
        if (this.usage == null && map != null) {
            this.usage = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.usage.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsage(String key) {
        if (this.usage == null) {
            return (A)this;
        }
        if (key != null && this.usage != null) {
            this.usage.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsage(Map<String, Quantity> map) {
        if (this.usage == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.usage == null) continue;
                this.usage.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getUsage() {
        return this.usage;
    }

    @Override
    public A withUsage(Map<String, Quantity> usage) {
        this.usage = usage == null ? null : new LinkedHashMap<String, Quantity>(usage);
        return (A)this;
    }

    @Override
    public Boolean hasUsage() {
        return this.usage != null;
    }

    @Override
    @Deprecated
    public Duration getWindow() {
        return this.window != null ? this.window.build() : null;
    }

    @Override
    public Duration buildWindow() {
        return this.window != null ? this.window.build() : null;
    }

    @Override
    public A withWindow(Duration window) {
        this._visitables.get("window").remove(this.window);
        if (window != null) {
            this.window = new DurationBuilder(window);
            this._visitables.get("window").add(this.window);
        }
        return (A)this;
    }

    @Override
    public Boolean hasWindow() {
        return this.window != null;
    }

    @Override
    public A withNewWindow(Long duration) {
        return this.withWindow(new Duration(duration));
    }

    @Override
    public A withNewWindow(String duration) {
        return this.withWindow(new Duration(duration));
    }

    @Override
    public NodeMetricsFluent.WindowNested<A> withNewWindow() {
        return new WindowNestedImpl();
    }

    @Override
    public NodeMetricsFluent.WindowNested<A> withNewWindowLike(Duration item) {
        return new WindowNestedImpl(item);
    }

    @Override
    public NodeMetricsFluent.WindowNested<A> editWindow() {
        return this.withNewWindowLike(this.getWindow());
    }

    @Override
    public NodeMetricsFluent.WindowNested<A> editOrNewWindow() {
        return this.withNewWindowLike(this.getWindow() != null ? this.getWindow() : new DurationBuilder().build());
    }

    @Override
    public NodeMetricsFluent.WindowNested<A> editOrNewWindowLike(Duration item) {
        return this.withNewWindowLike(this.getWindow() != null ? this.getWindow() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeMetricsFluentImpl that = (NodeMetricsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null) {
            return false;
        }
        if (this.usage != null ? !this.usage.equals(that.usage) : that.usage != null) {
            return false;
        }
        return !(this.window != null ? !this.window.equals(that.window) : that.window != null);
    }

    public class WindowNestedImpl<N>
    extends DurationFluentImpl<NodeMetricsFluent.WindowNested<N>>
    implements NodeMetricsFluent.WindowNested<N>,
    Nested<N> {
        private final DurationBuilder builder;

        WindowNestedImpl(Duration item) {
            this.builder = new DurationBuilder(this, item);
        }

        WindowNestedImpl() {
            this.builder = new DurationBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeMetricsFluentImpl.this.withWindow(this.builder.build());
        }

        @Override
        public N endWindow() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<NodeMetricsFluent.MetadataNested<N>>
    implements NodeMetricsFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeMetricsFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

