/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_7.apps;

import io.fabric8.kubernetes.api.builder.v4_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_7.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.v4_7.apps.StatefulSetSpecFluent;
import io.fabric8.kubernetes.api.model.v4_7.apps.StatefulSetSpecFluentImpl;

public class StatefulSetSpecBuilder
extends StatefulSetSpecFluentImpl<StatefulSetSpecBuilder>
implements VisitableBuilder<StatefulSetSpec, StatefulSetSpecBuilder> {
    StatefulSetSpecFluent<?> fluent;
    Boolean validationEnabled;

    public StatefulSetSpecBuilder() {
        this(true);
    }

    public StatefulSetSpecBuilder(Boolean validationEnabled) {
        this(new StatefulSetSpec(), validationEnabled);
    }

    public StatefulSetSpecBuilder(StatefulSetSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StatefulSetSpecBuilder(StatefulSetSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatefulSetSpec(), validationEnabled);
    }

    public StatefulSetSpecBuilder(StatefulSetSpecFluent<?> fluent, StatefulSetSpec instance) {
        this(fluent, instance, true);
    }

    public StatefulSetSpecBuilder(StatefulSetSpecFluent<?> fluent, StatefulSetSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPodManagementPolicy(instance.getPodManagementPolicy());
        fluent.withReplicas(instance.getReplicas());
        fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        fluent.withSelector(instance.getSelector());
        fluent.withServiceName(instance.getServiceName());
        fluent.withTemplate(instance.getTemplate());
        fluent.withUpdateStrategy(instance.getUpdateStrategy());
        fluent.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetSpecBuilder(StatefulSetSpec instance) {
        this(instance, (Boolean)true);
    }

    public StatefulSetSpecBuilder(StatefulSetSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPodManagementPolicy(instance.getPodManagementPolicy());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withServiceName(instance.getServiceName());
        this.withTemplate(instance.getTemplate());
        this.withUpdateStrategy(instance.getUpdateStrategy());
        this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public StatefulSetSpec build() {
        StatefulSetSpec buildable = new StatefulSetSpec(this.fluent.getPodManagementPolicy(), this.fluent.getReplicas(), this.fluent.getRevisionHistoryLimit(), this.fluent.getSelector(), this.fluent.getServiceName(), this.fluent.getTemplate(), this.fluent.getUpdateStrategy(), this.fluent.getVolumeClaimTemplates());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulSetSpecBuilder that = (StatefulSetSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

