/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_7;

import io.fabric8.kubernetes.api.builder.v4_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_7.ResourceMetricStatus;
import io.fabric8.kubernetes.api.model.v4_7.ResourceMetricStatusFluent;
import io.fabric8.kubernetes.api.model.v4_7.ResourceMetricStatusFluentImpl;

public class ResourceMetricStatusBuilder
extends ResourceMetricStatusFluentImpl<ResourceMetricStatusBuilder>
implements VisitableBuilder<ResourceMetricStatus, ResourceMetricStatusBuilder> {
    ResourceMetricStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceMetricStatusBuilder() {
        this(true);
    }

    public ResourceMetricStatusBuilder(Boolean validationEnabled) {
        this(new ResourceMetricStatus(), validationEnabled);
    }

    public ResourceMetricStatusBuilder(ResourceMetricStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ResourceMetricStatusBuilder(ResourceMetricStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceMetricStatus(), validationEnabled);
    }

    public ResourceMetricStatusBuilder(ResourceMetricStatusFluent<?> fluent, ResourceMetricStatus instance) {
        this(fluent, instance, true);
    }

    public ResourceMetricStatusBuilder(ResourceMetricStatusFluent<?> fluent, ResourceMetricStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCurrentAverageUtilization(instance.getCurrentAverageUtilization());
        fluent.withCurrentAverageValue(instance.getCurrentAverageValue());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public ResourceMetricStatusBuilder(ResourceMetricStatus instance) {
        this(instance, (Boolean)true);
    }

    public ResourceMetricStatusBuilder(ResourceMetricStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCurrentAverageUtilization(instance.getCurrentAverageUtilization());
        this.withCurrentAverageValue(instance.getCurrentAverageValue());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourceMetricStatus build() {
        ResourceMetricStatus buildable = new ResourceMetricStatus(this.fluent.getCurrentAverageUtilization(), this.fluent.getCurrentAverageValue(), this.fluent.getName());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceMetricStatusBuilder that = (ResourceMetricStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

