/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_7;

import io.fabric8.kubernetes.api.builder.v4_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_7.Nested;
import io.fabric8.kubernetes.api.builder.v4_7.Predicate;
import io.fabric8.kubernetes.api.model.v4_7.ISCSIPersistentVolumeSource;
import io.fabric8.kubernetes.api.model.v4_7.ISCSIPersistentVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.v4_7.SecretReference;
import io.fabric8.kubernetes.api.model.v4_7.SecretReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_7.SecretReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ISCSIPersistentVolumeSourceFluentImpl<A extends ISCSIPersistentVolumeSourceFluent<A>>
extends BaseFluent<A>
implements ISCSIPersistentVolumeSourceFluent<A> {
    private Boolean chapAuthDiscovery;
    private Boolean chapAuthSession;
    private String fsType;
    private String initiatorName;
    private String iqn;
    private String iscsiInterface;
    private Integer lun;
    private List<String> portals = new ArrayList<String>();
    private Boolean readOnly;
    private SecretReferenceBuilder secretRef;
    private String targetPortal;

    public ISCSIPersistentVolumeSourceFluentImpl() {
    }

    public ISCSIPersistentVolumeSourceFluentImpl(ISCSIPersistentVolumeSource instance) {
        this.withChapAuthDiscovery(instance.getChapAuthDiscovery());
        this.withChapAuthSession(instance.getChapAuthSession());
        this.withFsType(instance.getFsType());
        this.withInitiatorName(instance.getInitiatorName());
        this.withIqn(instance.getIqn());
        this.withIscsiInterface(instance.getIscsiInterface());
        this.withLun(instance.getLun());
        this.withPortals(instance.getPortals());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withTargetPortal(instance.getTargetPortal());
    }

    @Override
    public Boolean isChapAuthDiscovery() {
        return this.chapAuthDiscovery;
    }

    @Override
    public A withChapAuthDiscovery(Boolean chapAuthDiscovery) {
        this.chapAuthDiscovery = chapAuthDiscovery;
        return (A)this;
    }

    @Override
    public Boolean hasChapAuthDiscovery() {
        return this.chapAuthDiscovery != null;
    }

    @Override
    public A withNewChapAuthDiscovery(String arg1) {
        return this.withChapAuthDiscovery(new Boolean(arg1));
    }

    @Override
    public A withNewChapAuthDiscovery(boolean arg1) {
        return this.withChapAuthDiscovery(new Boolean(arg1));
    }

    @Override
    public Boolean isChapAuthSession() {
        return this.chapAuthSession;
    }

    @Override
    public A withChapAuthSession(Boolean chapAuthSession) {
        this.chapAuthSession = chapAuthSession;
        return (A)this;
    }

    @Override
    public Boolean hasChapAuthSession() {
        return this.chapAuthSession != null;
    }

    @Override
    public A withNewChapAuthSession(String arg1) {
        return this.withChapAuthSession(new Boolean(arg1));
    }

    @Override
    public A withNewChapAuthSession(boolean arg1) {
        return this.withChapAuthSession(new Boolean(arg1));
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public A withNewFsType(String arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public A withNewFsType(StringBuilder arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public A withNewFsType(StringBuffer arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public String getInitiatorName() {
        return this.initiatorName;
    }

    @Override
    public A withInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
        return (A)this;
    }

    @Override
    public Boolean hasInitiatorName() {
        return this.initiatorName != null;
    }

    @Override
    public A withNewInitiatorName(String arg1) {
        return this.withInitiatorName(new String(arg1));
    }

    @Override
    public A withNewInitiatorName(StringBuilder arg1) {
        return this.withInitiatorName(new String(arg1));
    }

    @Override
    public A withNewInitiatorName(StringBuffer arg1) {
        return this.withInitiatorName(new String(arg1));
    }

    @Override
    public String getIqn() {
        return this.iqn;
    }

    @Override
    public A withIqn(String iqn) {
        this.iqn = iqn;
        return (A)this;
    }

    @Override
    public Boolean hasIqn() {
        return this.iqn != null;
    }

    @Override
    public A withNewIqn(String arg1) {
        return this.withIqn(new String(arg1));
    }

    @Override
    public A withNewIqn(StringBuilder arg1) {
        return this.withIqn(new String(arg1));
    }

    @Override
    public A withNewIqn(StringBuffer arg1) {
        return this.withIqn(new String(arg1));
    }

    @Override
    public String getIscsiInterface() {
        return this.iscsiInterface;
    }

    @Override
    public A withIscsiInterface(String iscsiInterface) {
        this.iscsiInterface = iscsiInterface;
        return (A)this;
    }

    @Override
    public Boolean hasIscsiInterface() {
        return this.iscsiInterface != null;
    }

    @Override
    public A withNewIscsiInterface(String arg1) {
        return this.withIscsiInterface(new String(arg1));
    }

    @Override
    public A withNewIscsiInterface(StringBuilder arg1) {
        return this.withIscsiInterface(new String(arg1));
    }

    @Override
    public A withNewIscsiInterface(StringBuffer arg1) {
        return this.withIscsiInterface(new String(arg1));
    }

    @Override
    public Integer getLun() {
        return this.lun;
    }

    @Override
    public A withLun(Integer lun) {
        this.lun = lun;
        return (A)this;
    }

    @Override
    public Boolean hasLun() {
        return this.lun != null;
    }

    @Override
    public A addToPortals(int index, String item) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        this.portals.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPortals(int index, String item) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        this.portals.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPortals(String ... items) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        for (String item : items) {
            this.portals.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPortals(Collection<String> items) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        for (String item : items) {
            this.portals.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPortals(String ... items) {
        for (String item : items) {
            if (this.portals == null) continue;
            this.portals.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPortals(Collection<String> items) {
        for (String item : items) {
            if (this.portals == null) continue;
            this.portals.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPortals() {
        return this.portals;
    }

    @Override
    public String getPortal(int index) {
        return this.portals.get(index);
    }

    @Override
    public String getFirstPortal() {
        return this.portals.get(0);
    }

    @Override
    public String getLastPortal() {
        return this.portals.get(this.portals.size() - 1);
    }

    @Override
    public String getMatchingPortal(Predicate<String> predicate) {
        for (String item : this.portals) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPortal(Predicate<String> predicate) {
        for (String item : this.portals) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPortals(List<String> portals) {
        if (this.portals != null) {
            this._visitables.get("portals").removeAll(this.portals);
        }
        if (portals != null) {
            this.portals = new ArrayList<String>();
            for (String item : portals) {
                this.addToPortals(item);
            }
        } else {
            this.portals = null;
        }
        return (A)this;
    }

    @Override
    public A withPortals(String ... portals) {
        if (this.portals != null) {
            this.portals.clear();
        }
        if (portals != null) {
            for (String item : portals) {
                this.addToPortals(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPortals() {
        return this.portals != null && !this.portals.isEmpty();
    }

    @Override
    public A addNewPortal(String arg1) {
        return this.addToPortals(new String(arg1));
    }

    @Override
    public A addNewPortal(StringBuilder arg1) {
        return this.addToPortals(new String(arg1));
    }

    @Override
    public A addNewPortal(StringBuffer arg1) {
        return this.addToPortals(new String(arg1));
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public A withNewReadOnly(String arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    public A withNewReadOnly(boolean arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public SecretReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public SecretReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(SecretReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new SecretReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name, String namespace) {
        return this.withSecretRef(new SecretReference(name, namespace));
    }

    @Override
    public ISCSIPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public ISCSIPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(SecretReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public ISCSIPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public ISCSIPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new SecretReferenceBuilder().build());
    }

    @Override
    public ISCSIPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getTargetPortal() {
        return this.targetPortal;
    }

    @Override
    public A withTargetPortal(String targetPortal) {
        this.targetPortal = targetPortal;
        return (A)this;
    }

    @Override
    public Boolean hasTargetPortal() {
        return this.targetPortal != null;
    }

    @Override
    public A withNewTargetPortal(String arg1) {
        return this.withTargetPortal(new String(arg1));
    }

    @Override
    public A withNewTargetPortal(StringBuilder arg1) {
        return this.withTargetPortal(new String(arg1));
    }

    @Override
    public A withNewTargetPortal(StringBuffer arg1) {
        return this.withTargetPortal(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ISCSIPersistentVolumeSourceFluentImpl that = (ISCSIPersistentVolumeSourceFluentImpl)o;
        if (this.chapAuthDiscovery != null ? !this.chapAuthDiscovery.equals(that.chapAuthDiscovery) : that.chapAuthDiscovery != null) {
            return false;
        }
        if (this.chapAuthSession != null ? !this.chapAuthSession.equals(that.chapAuthSession) : that.chapAuthSession != null) {
            return false;
        }
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.initiatorName != null ? !this.initiatorName.equals(that.initiatorName) : that.initiatorName != null) {
            return false;
        }
        if (this.iqn != null ? !this.iqn.equals(that.iqn) : that.iqn != null) {
            return false;
        }
        if (this.iscsiInterface != null ? !this.iscsiInterface.equals(that.iscsiInterface) : that.iscsiInterface != null) {
            return false;
        }
        if (this.lun != null ? !this.lun.equals(that.lun) : that.lun != null) {
            return false;
        }
        if (this.portals != null ? !this.portals.equals(that.portals) : that.portals != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        return !(this.targetPortal != null ? !this.targetPortal.equals(that.targetPortal) : that.targetPortal != null);
    }

    public class SecretRefNestedImpl<N>
    extends SecretReferenceFluentImpl<ISCSIPersistentVolumeSourceFluent.SecretRefNested<N>>
    implements ISCSIPersistentVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        private final SecretReferenceBuilder builder;

        SecretRefNestedImpl(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new SecretReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ISCSIPersistentVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

