/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_7;

import io.fabric8.kubernetes.api.builder.v4_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_7.Nested;
import io.fabric8.kubernetes.api.builder.v4_7.Predicate;
import io.fabric8.kubernetes.api.model.v4_7.CrossVersionObjectReference;
import io.fabric8.kubernetes.api.model.v4_7.CrossVersionObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_7.CrossVersionObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v4_7.HorizontalPodAutoscalerSpec;
import io.fabric8.kubernetes.api.model.v4_7.HorizontalPodAutoscalerSpecFluent;
import io.fabric8.kubernetes.api.model.v4_7.MetricSpec;
import io.fabric8.kubernetes.api.model.v4_7.MetricSpecBuilder;
import io.fabric8.kubernetes.api.model.v4_7.MetricSpecFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class HorizontalPodAutoscalerSpecFluentImpl<A extends HorizontalPodAutoscalerSpecFluent<A>>
extends BaseFluent<A>
implements HorizontalPodAutoscalerSpecFluent<A> {
    private Integer maxReplicas;
    private List<MetricSpecBuilder> metrics = new ArrayList<MetricSpecBuilder>();
    private Integer minReplicas;
    private CrossVersionObjectReferenceBuilder scaleTargetRef;

    public HorizontalPodAutoscalerSpecFluentImpl() {
    }

    public HorizontalPodAutoscalerSpecFluentImpl(HorizontalPodAutoscalerSpec instance) {
        this.withMaxReplicas(instance.getMaxReplicas());
        this.withMetrics(instance.getMetrics());
        this.withMinReplicas(instance.getMinReplicas());
        this.withScaleTargetRef(instance.getScaleTargetRef());
    }

    @Override
    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    @Override
    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasMaxReplicas() {
        return this.maxReplicas != null;
    }

    @Override
    public A addToMetrics(int index, MetricSpec item) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<MetricSpecBuilder>();
        }
        MetricSpecBuilder builder = new MetricSpecBuilder(item);
        this._visitables.get("metrics").add(index >= 0 ? index : this._visitables.get("metrics").size(), builder);
        this.metrics.add(index >= 0 ? index : this.metrics.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMetrics(int index, MetricSpec item) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<MetricSpecBuilder>();
        }
        MetricSpecBuilder builder = new MetricSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get("metrics").size()) {
            this._visitables.get("metrics").add(builder);
        } else {
            this._visitables.get("metrics").set(index, builder);
        }
        if (index < 0 || index >= this.metrics.size()) {
            this.metrics.add(builder);
        } else {
            this.metrics.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMetrics(MetricSpec ... items) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<MetricSpecBuilder>();
        }
        for (MetricSpec item : items) {
            MetricSpecBuilder builder = new MetricSpecBuilder(item);
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMetrics(Collection<MetricSpec> items) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<MetricSpecBuilder>();
        }
        for (MetricSpec item : items) {
            MetricSpecBuilder builder = new MetricSpecBuilder(item);
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(MetricSpec ... items) {
        for (MetricSpec item : items) {
            MetricSpecBuilder builder = new MetricSpecBuilder(item);
            this._visitables.get("metrics").remove(builder);
            if (this.metrics == null) continue;
            this.metrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMetrics(Collection<MetricSpec> items) {
        for (MetricSpec item : items) {
            MetricSpecBuilder builder = new MetricSpecBuilder(item);
            this._visitables.get("metrics").remove(builder);
            if (this.metrics == null) continue;
            this.metrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMetrics(Predicate<MetricSpecBuilder> predicate) {
        if (this.metrics == null) {
            return (A)this;
        }
        Iterator<MetricSpecBuilder> each = this.metrics.iterator();
        Object visitables = this._visitables.get("metrics");
        while (each.hasNext()) {
            MetricSpecBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<MetricSpec> getMetrics() {
        return HorizontalPodAutoscalerSpecFluentImpl.build(this.metrics);
    }

    @Override
    public List<MetricSpec> buildMetrics() {
        return HorizontalPodAutoscalerSpecFluentImpl.build(this.metrics);
    }

    @Override
    public MetricSpec buildMetric(int index) {
        return this.metrics.get(index).build();
    }

    @Override
    public MetricSpec buildFirstMetric() {
        return this.metrics.get(0).build();
    }

    @Override
    public MetricSpec buildLastMetric() {
        return this.metrics.get(this.metrics.size() - 1).build();
    }

    @Override
    public MetricSpec buildMatchingMetric(Predicate<MetricSpecBuilder> predicate) {
        for (MetricSpecBuilder item : this.metrics) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMetric(Predicate<MetricSpecBuilder> predicate) {
        for (MetricSpecBuilder item : this.metrics) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMetrics(List<MetricSpec> metrics) {
        if (this.metrics != null) {
            this._visitables.get("metrics").removeAll(this.metrics);
        }
        if (metrics != null) {
            this.metrics = new ArrayList<MetricSpecBuilder>();
            for (MetricSpec item : metrics) {
                this.addToMetrics(item);
            }
        } else {
            this.metrics = null;
        }
        return (A)this;
    }

    @Override
    public A withMetrics(MetricSpec ... metrics) {
        if (this.metrics != null) {
            this.metrics.clear();
        }
        if (metrics != null) {
            for (MetricSpec item : metrics) {
                this.addToMetrics(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetrics() {
        return this.metrics != null && !this.metrics.isEmpty();
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetric() {
        return new MetricsNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetricLike(MetricSpec item) {
        return new MetricsNestedImpl(-1, item);
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> setNewMetricLike(int index, MetricSpec item) {
        return new MetricsNestedImpl(index, item);
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMetric(int index) {
        if (this.metrics.size() <= index) {
            throw new RuntimeException("Can't edit metrics. Index exceeds size.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editFirstMetric() {
        if (this.metrics.size() == 0) {
            throw new RuntimeException("Can't edit first metrics. The list is empty.");
        }
        return this.setNewMetricLike(0, this.buildMetric(0));
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editLastMetric() {
        int index = this.metrics.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last metrics. The list is empty.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMatchingMetric(Predicate<MetricSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.metrics.size(); ++i) {
            if (!predicate.apply(this.metrics.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching metrics. No match found.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    @Override
    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    @Override
    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    @Override
    @Deprecated
    public CrossVersionObjectReference getScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    @Override
    public CrossVersionObjectReference buildScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    @Override
    public A withScaleTargetRef(CrossVersionObjectReference scaleTargetRef) {
        this._visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
        if (scaleTargetRef != null) {
            this.scaleTargetRef = new CrossVersionObjectReferenceBuilder(scaleTargetRef);
            this._visitables.get("scaleTargetRef").add(this.scaleTargetRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    @Override
    public A withNewScaleTargetRef(String apiVersion, String kind, String name) {
        return this.withScaleTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(CrossVersionObjectReference item) {
        return new ScaleTargetRefNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef() {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef());
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef() != null ? this.getScaleTargetRef() : new CrossVersionObjectReferenceBuilder().build());
    }

    @Override
    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(CrossVersionObjectReference item) {
        return this.withNewScaleTargetRefLike(this.getScaleTargetRef() != null ? this.getScaleTargetRef() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorizontalPodAutoscalerSpecFluentImpl that = (HorizontalPodAutoscalerSpecFluentImpl)o;
        if (this.maxReplicas != null ? !this.maxReplicas.equals(that.maxReplicas) : that.maxReplicas != null) {
            return false;
        }
        if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) {
            return false;
        }
        if (this.minReplicas != null ? !this.minReplicas.equals(that.minReplicas) : that.minReplicas != null) {
            return false;
        }
        return !(this.scaleTargetRef != null ? !this.scaleTargetRef.equals(that.scaleTargetRef) : that.scaleTargetRef != null);
    }

    public class ScaleTargetRefNestedImpl<N>
    extends CrossVersionObjectReferenceFluentImpl<HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>>
    implements HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>,
    Nested<N> {
        private final CrossVersionObjectReferenceBuilder builder;

        ScaleTargetRefNestedImpl(CrossVersionObjectReference item) {
            this.builder = new CrossVersionObjectReferenceBuilder(this, item);
        }

        ScaleTargetRefNestedImpl() {
            this.builder = new CrossVersionObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerSpecFluentImpl.this.withScaleTargetRef(this.builder.build());
        }

        @Override
        public N endScaleTargetRef() {
            return this.and();
        }
    }

    public class MetricsNestedImpl<N>
    extends MetricSpecFluentImpl<HorizontalPodAutoscalerSpecFluent.MetricsNested<N>>
    implements HorizontalPodAutoscalerSpecFluent.MetricsNested<N>,
    Nested<N> {
        private final MetricSpecBuilder builder;
        private final int index;

        MetricsNestedImpl(int index, MetricSpec item) {
            this.index = index;
            this.builder = new MetricSpecBuilder(this, item);
        }

        MetricsNestedImpl() {
            this.index = -1;
            this.builder = new MetricSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerSpecFluentImpl.this.setToMetrics(this.index, this.builder.build());
        }

        @Override
        public N endMetric() {
            return this.and();
        }
    }
}

