/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_7;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class Duration
implements Serializable {
    @JsonProperty(value="Duration")
    private Long duration;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Duration() {
    }

    public Duration(Long duration) {
        this.duration = duration;
    }

    public Duration(String duration) {
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(duration);
        long totalSeconds = 0L;
        while (m.find()) {
            String digit = m.group();
            int digitIndex = duration.indexOf(digit);
            if (digitIndex + 1 >= duration.length()) continue;
            char unit = duration.charAt(digitIndex + 1);
            if (unit == 'h') {
                totalSeconds += (long)(3600 * Integer.parseInt(digit));
                continue;
            }
            if (unit == 'm') {
                totalSeconds += (long)(60 * Integer.parseInt(digit));
                continue;
            }
            if (unit != 's') continue;
            totalSeconds += (long)Integer.parseInt(digit);
        }
        this.duration = totalSeconds;
    }

    @JsonProperty(value="Duration")
    public Long getDuration() {
        return this.duration;
    }

    @JsonProperty(value="Duration")
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "Duration(duration=" + this.getDuration() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Duration)) {
            return false;
        }
        Duration other = (Duration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$duration = this.getDuration();
        Long other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Duration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public static class Deserializer
    extends JsonDeserializer<Duration> {
        public Duration deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            Duration duration = new Duration(node.asText());
            return duration;
        }
    }

    public static class Serializer
    extends JsonSerializer<Duration> {
        public void serialize(Duration value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value != null && value.getDuration() != null) {
                jgen.writeString(value.getDuration().toString());
            } else {
                jgen.writeNull();
            }
        }
    }
}

