/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_7;

import io.fabric8.kubernetes.api.builder.v4_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_7.Nested;
import io.fabric8.kubernetes.api.model.v4_7.CinderPersistentVolumeSource;
import io.fabric8.kubernetes.api.model.v4_7.CinderPersistentVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.v4_7.SecretReference;
import io.fabric8.kubernetes.api.model.v4_7.SecretReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_7.SecretReferenceFluentImpl;

public class CinderPersistentVolumeSourceFluentImpl<A extends CinderPersistentVolumeSourceFluent<A>>
extends BaseFluent<A>
implements CinderPersistentVolumeSourceFluent<A> {
    private String fsType;
    private Boolean readOnly;
    private SecretReferenceBuilder secretRef;
    private String volumeID;

    public CinderPersistentVolumeSourceFluentImpl() {
    }

    public CinderPersistentVolumeSourceFluentImpl(CinderPersistentVolumeSource instance) {
        this.withFsType(instance.getFsType());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withVolumeID(instance.getVolumeID());
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public A withNewFsType(String arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public A withNewFsType(StringBuilder arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public A withNewFsType(StringBuffer arg1) {
        return this.withFsType(new String(arg1));
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public A withNewReadOnly(String arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    public A withNewReadOnly(boolean arg1) {
        return this.withReadOnly(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public SecretReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public SecretReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(SecretReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new SecretReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name, String namespace) {
        return this.withSecretRef(new SecretReference(name, namespace));
    }

    @Override
    public CinderPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public CinderPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(SecretReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public CinderPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public CinderPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new SecretReferenceBuilder().build());
    }

    @Override
    public CinderPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getVolumeID() {
        return this.volumeID;
    }

    @Override
    public A withVolumeID(String volumeID) {
        this.volumeID = volumeID;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeID() {
        return this.volumeID != null;
    }

    @Override
    public A withNewVolumeID(String arg1) {
        return this.withVolumeID(new String(arg1));
    }

    @Override
    public A withNewVolumeID(StringBuilder arg1) {
        return this.withVolumeID(new String(arg1));
    }

    @Override
    public A withNewVolumeID(StringBuffer arg1) {
        return this.withVolumeID(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CinderPersistentVolumeSourceFluentImpl that = (CinderPersistentVolumeSourceFluentImpl)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        return !(this.volumeID != null ? !this.volumeID.equals(that.volumeID) : that.volumeID != null);
    }

    public class SecretRefNestedImpl<N>
    extends SecretReferenceFluentImpl<CinderPersistentVolumeSourceFluent.SecretRefNested<N>>
    implements CinderPersistentVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        private final SecretReferenceBuilder builder;

        SecretRefNestedImpl(SecretReference item) {
            this.builder = new SecretReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new SecretReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CinderPersistentVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

