/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builder.v4_7;

import io.fabric8.kubernetes.api.builder.v4_7.Builder;
import io.fabric8.kubernetes.api.builder.v4_7.Editable;
import io.fabric8.kubernetes.api.builder.v4_7.Fluent;
import io.fabric8.kubernetes.api.builder.v4_7.PathAwareTypedVisitor;
import io.fabric8.kubernetes.api.builder.v4_7.TypedVisitor;
import io.fabric8.kubernetes.api.builder.v4_7.Visitable;
import io.fabric8.kubernetes.api.builder.v4_7.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.v4_7.VisitableMap;
import io.fabric8.kubernetes.api.builder.v4_7.Visitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class BaseFluent<F extends Fluent<F>>
implements Fluent<F>,
Visitable<F> {
    private static final String VISIT = "visit";
    public final VisitableMap _visitables = new VisitableMap();

    public static <T> VisitableBuilder<T, ?> builderOf(T item) {
        Object editor;
        if (item instanceof Editable && (editor = ((Editable)item).edit()) instanceof VisitableBuilder) {
            return (VisitableBuilder)editor;
        }
        try {
            return (VisitableBuilder)Class.forName(item.getClass().getName() + "Builder").getConstructor(item.getClass()).newInstance(item);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create builder for: " + item.getClass(), e);
        }
    }

    public static <T> ArrayList<T> build(List<? extends Builder<? extends T>> list) {
        if (list == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Builder<T> builder : list) {
            result.add(builder.build());
        }
        return result;
    }

    public static <T> List<T> build(Set<? extends Builder<? extends T>> set) {
        if (set == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (Builder<T> builder : set) {
            result.add(builder.build());
        }
        return result;
    }

    public static <T> ArrayList<T> aggregate(List<? extends T> ... lists) {
        ArrayList<? extends T> result = new ArrayList<T>();
        for (List<T> list : lists) {
            if (list == null) continue;
            result.addAll(list);
        }
        return result;
    }

    public static <T> LinkedHashSet<T> aggregate(Set<? extends T> ... sets) {
        LinkedHashSet<? extends T> result = new LinkedHashSet<T>();
        for (Set<T> set : sets) {
            if (set == null) continue;
            result.addAll(set);
        }
        return result;
    }

    private static <V, F> Boolean canVisit(V visitor, F fluent) {
        Class actaulParentType;
        PathAwareTypedVisitor pathAwareTypedVisitor;
        Class parentType;
        if (visitor instanceof TypedVisitor && !((TypedVisitor)visitor).getType().isAssignableFrom(fluent.getClass())) {
            return false;
        }
        if (visitor instanceof PathAwareTypedVisitor && !(parentType = (pathAwareTypedVisitor = (PathAwareTypedVisitor)visitor).getParentType()).isAssignableFrom(actaulParentType = pathAwareTypedVisitor.getActualParentType())) {
            return false;
        }
        return BaseFluent.hasCompatibleVisitMethod(visitor, fluent);
    }

    private static <V, F> Boolean hasCompatibleVisitMethod(V visitor, F fluent) {
        for (Method method : visitor.getClass().getMethods()) {
            if (!method.getName().equals(VISIT) || method.getParameterTypes().length != 1) continue;
            Class<?> visitorType = method.getParameterTypes()[0];
            if (visitorType.isAssignableFrom(fluent.getClass())) {
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public F accept(Visitor visitor) {
        if (visitor instanceof PathAwareTypedVisitor) {
            return this.acceptPathAware((PathAwareTypedVisitor)visitor);
        }
        return this.acceptInternal(visitor);
    }

    private F acceptInternal(Visitor visitor) {
        for (Visitable visitable : this._visitables) {
            visitable.accept(visitor);
        }
        if (BaseFluent.canVisit(visitor, this).booleanValue()) {
            visitor.visit(this);
        }
        return (F)this;
    }

    private F acceptPathAware(PathAwareTypedVisitor pathAwareTypedVisitor) {
        return this.acceptInternal(pathAwareTypedVisitor.next(this));
    }
}

