/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_7.informers.cache;

import io.fabric8.kubernetes.api.model.v4_7.ObjectMeta;
import io.fabric8.kubernetes.clnt.v4_7.informers.cache.DeltaFIFO;
import io.fabric8.kubernetes.clnt.v4_7.informers.cache.Indexer;
import io.fabric8.kubernetes.clnt.v4_7.utils.ReflectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class Cache<T>
implements Indexer<T> {
    private Function<T, String> keyFunc;
    public static final String NAMESPACE_INDEX = "namespace";
    private Map<String, Function<T, List<String>>> indexers = new HashMap<String, Function<T, List<String>>>();
    private Map<String, T> items = new HashMap<String, T>();
    private Map<String, Map<String, Set<String>>> indices = new HashMap<String, Map<String, Set<String>>>();

    public Cache() {
        this(NAMESPACE_INDEX, Cache::metaNamespaceIndexFunc, Cache::deletionHandlingMetaNamespaceKeyFunc);
    }

    public Cache(String indexName, Function<T, List<String>> indexFunc, Function<T, String> keyFunc) {
        this.indexers.put(indexName, indexFunc);
        this.keyFunc = keyFunc;
        this.indices.put(indexName, new HashMap());
    }

    @Override
    public synchronized void add(T obj) {
        String key = this.keyFunc.apply(obj);
        T oldObj = this.items.get(key);
        this.items.put(key, obj);
        this.updateIndices(oldObj, obj, key);
    }

    @Override
    public synchronized void update(T obj) {
        String key = this.keyFunc.apply(obj);
        T oldObj = this.items.get(key);
        this.items.put(key, obj);
        this.updateIndices(oldObj, obj, key);
    }

    @Override
    public synchronized void delete(T obj) {
        String key = this.keyFunc.apply(obj);
        boolean exists = this.items.containsKey(key);
        if (exists) {
            this.deleteFromIndices(this.items.get(key), key);
            this.items.remove(key);
        }
    }

    @Override
    public synchronized void replace(List<T> list, String resourceVersion) {
        HashMap<String, T> newItems = new HashMap<String, T>();
        for (T t : list) {
            String key = this.keyFunc.apply(t);
            newItems.put(key, t);
        }
        this.items = newItems;
        this.indices = new HashMap<String, Map<String, Set<String>>>();
        for (Map.Entry entry : this.items.entrySet()) {
            this.updateIndices(null, entry.getValue(), (String)entry.getKey());
        }
    }

    @Override
    public void resync() {
    }

    @Override
    public synchronized List<String> listKeys() {
        ArrayList<String> keys = new ArrayList<String>(this.items.size());
        for (Map.Entry<String, T> entry : this.items.entrySet()) {
            keys.add(entry.getKey());
        }
        return keys;
    }

    @Override
    public synchronized T get(T obj) {
        String key = this.keyFunc.apply(obj);
        return this.getByKey(key);
    }

    @Override
    public synchronized List<T> list() {
        ArrayList<T> itemList = new ArrayList<T>(this.items.size());
        for (Map.Entry<String, T> entry : this.items.entrySet()) {
            itemList.add(entry.getValue());
        }
        return itemList;
    }

    @Override
    public synchronized T getByKey(String key) {
        return this.items.get(key);
    }

    @Override
    public synchronized List<T> index(String indexName, Object obj) {
        if (!this.indexers.containsKey(indexName)) {
            throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
        }
        Function<Object, List<String>> indexFunc = this.indexers.get(indexName);
        List<String> indexKeys = indexFunc.apply(obj);
        Map<String, Set<String>> index = this.indices.get(indexName);
        if (index.isEmpty()) {
            return new ArrayList();
        }
        HashSet<String> returnKeySet = new HashSet<String>();
        for (String indexKey : indexKeys) {
            Set<String> set = index.get(indexKey);
            if (set.isEmpty()) continue;
            returnKeySet.addAll(set);
        }
        ArrayList<T> items = new ArrayList<T>(returnKeySet.size());
        for (String absoluteKey : returnKeySet) {
            items.add(this.items.get(absoluteKey));
        }
        return items;
    }

    @Override
    public synchronized List<String> indexKeys(String indexName, String indexKey) {
        if (!this.indexers.containsKey(indexName)) {
            throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
        }
        Map<String, Set<String>> index = this.indices.get(indexName);
        Set<String> set = index.get(indexKey);
        ArrayList<String> keys = new ArrayList<String>(set.size());
        for (String key : set) {
            keys.add(key);
        }
        return keys;
    }

    @Override
    public synchronized List<T> byIndex(String indexName, String indexKey) {
        if (!this.indexers.containsKey(indexName)) {
            throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
        }
        Map<String, Set<String>> index = this.indices.get(indexName);
        Set<String> set = index.get(indexKey);
        if (set == null) {
            return Arrays.asList(new Object[0]);
        }
        ArrayList<T> items = new ArrayList<T>(set.size());
        for (String key : set) {
            items.add(this.items.get(key));
        }
        return items;
    }

    public void updateIndices(T oldObj, T newObj, String key) {
        if (oldObj != null) {
            this.deleteFromIndices(oldObj, key);
        }
        for (Map.Entry<String, Function<T, List<String>>> indexEntry : this.indexers.entrySet()) {
            String indexName = indexEntry.getKey();
            Function<T, List<String>> indexFunc = indexEntry.getValue();
            List<String> indexValues = indexFunc.apply(newObj);
            if (indexValues == null || indexValues.isEmpty()) continue;
            Map index = this.indices.computeIfAbsent(indexName, k -> new HashMap());
            for (String indexValue : indexValues) {
                Set indexSet = index.computeIfAbsent(indexValue, k -> new HashSet());
                indexSet.add(key);
            }
        }
    }

    private void deleteFromIndices(T oldObj, String key) {
        for (Map.Entry<String, Function<T, List<String>>> indexEntry : this.indexers.entrySet()) {
            Map<String, Set<String>> index;
            Function<T, List<String>> indexFunc = indexEntry.getValue();
            List<String> indexValues = indexFunc.apply(oldObj);
            if (indexValues == null || indexValues.isEmpty() || (index = this.indices.get(indexEntry.getKey())) == null) continue;
            for (String indexValue : indexValues) {
                Set<String> indexSet = index.get(indexValue);
                if (indexSet == null) continue;
                indexSet.remove(key);
            }
        }
    }

    public static <T> String deletionHandlingMetaNamespaceKeyFunc(T object) {
        if (object instanceof DeltaFIFO.DeletedFinalStateUnknown) {
            DeltaFIFO.DeletedFinalStateUnknown deleteObj = (DeltaFIFO.DeletedFinalStateUnknown)object;
            return deleteObj.getKey();
        }
        return Cache.metaNamespaceKeyFunc(object);
    }

    public static String metaNamespaceKeyFunc(Object obj) {
        try {
            ObjectMeta metadata;
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof ObjectMeta) {
                metadata = (ObjectMeta)obj;
            } else {
                metadata = ReflectUtils.objectMetadata(obj);
                if (metadata == null) {
                    throw new RuntimeException("Object is bad :" + obj);
                }
            }
            if (metadata.getNamespace() != null && !metadata.getNamespace().isEmpty()) {
                return metadata.getNamespace() + "/" + metadata.getName();
            }
            return metadata.getName();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> metaNamespaceIndexFunc(Object obj) {
        try {
            ObjectMeta metadata = ReflectUtils.objectMetadata(obj);
            return metadata == null ? Collections.emptyList() : Collections.singletonList(metadata.getNamespace());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

