/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_7.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_7.metrics.v1beta1.NodeMetrics;
import io.fabric8.kubernetes.api.model.v4_7.metrics.v1beta1.NodeMetricsList;
import io.fabric8.kubernetes.clnt.v4_7.Config;
import io.fabric8.kubernetes.clnt.v4_7.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_7.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_7.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v4_7.utils.URLUtils;
import okhttp3.OkHttpClient;

public class NodeMetricOperationsImpl
extends OperationSupport {
    private static String METRIC_ENDPOINT_URL = "apis/metrics.k8s.io/v1beta1/nodes";

    public NodeMetricOperationsImpl(OkHttpClient client, Config config) {
        super(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public NodeMetricsList metrics() {
        try {
            String resourceUrl = URLUtils.join(this.config.getMasterUrl(), METRIC_ENDPOINT_URL);
            return this.handleMetric(resourceUrl, NodeMetricsList.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public NodeMetrics metrics(String nodeName) {
        try {
            String resourceUrl = URLUtils.join(this.config.getMasterUrl(), METRIC_ENDPOINT_URL, nodeName);
            return this.handleMetric(resourceUrl, NodeMetrics.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }
}

