/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_7.events;

import io.fabric8.kubernetes.api.builder.v4_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_7.Nested;
import io.fabric8.kubernetes.api.model.v4_7.EventSource;
import io.fabric8.kubernetes.api.model.v4_7.EventSourceBuilder;
import io.fabric8.kubernetes.api.model.v4_7.EventSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v4_7.MicroTime;
import io.fabric8.kubernetes.api.model.v4_7.MicroTimeBuilder;
import io.fabric8.kubernetes.api.model.v4_7.MicroTimeFluentImpl;
import io.fabric8.kubernetes.api.model.v4_7.ObjectMeta;
import io.fabric8.kubernetes.api.model.v4_7.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v4_7.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v4_7.ObjectReference;
import io.fabric8.kubernetes.api.model.v4_7.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_7.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v4_7.events.Event;
import io.fabric8.kubernetes.api.model.v4_7.events.EventFluent;
import io.fabric8.kubernetes.api.model.v4_7.events.EventSeries;
import io.fabric8.kubernetes.api.model.v4_7.events.EventSeriesBuilder;
import io.fabric8.kubernetes.api.model.v4_7.events.EventSeriesFluentImpl;

public class EventFluentImpl<A extends EventFluent<A>>
extends BaseFluent<A>
implements EventFluent<A> {
    private String action;
    private String apiVersion;
    private Integer deprecatedCount;
    private String deprecatedFirstTimestamp;
    private String deprecatedLastTimestamp;
    private EventSourceBuilder deprecatedSource;
    private MicroTimeBuilder eventTime;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String note;
    private String reason;
    private ObjectReferenceBuilder regarding;
    private ObjectReferenceBuilder related;
    private String reportingController;
    private String reportingInstance;
    private EventSeriesBuilder series;
    private String type;

    public EventFluentImpl() {
    }

    public EventFluentImpl(Event instance) {
        this.withAction(instance.getAction());
        this.withApiVersion(instance.getApiVersion());
        this.withDeprecatedCount(instance.getDeprecatedCount());
        this.withDeprecatedFirstTimestamp(instance.getDeprecatedFirstTimestamp());
        this.withDeprecatedLastTimestamp(instance.getDeprecatedLastTimestamp());
        this.withDeprecatedSource(instance.getDeprecatedSource());
        this.withEventTime(instance.getEventTime());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withNote(instance.getNote());
        this.withReason(instance.getReason());
        this.withRegarding(instance.getRegarding());
        this.withRelated(instance.getRelated());
        this.withReportingController(instance.getReportingController());
        this.withReportingInstance(instance.getReportingInstance());
        this.withSeries(instance.getSeries());
        this.withType(instance.getType());
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public A withAction(String action) {
        this.action = action;
        return (A)this;
    }

    @Override
    public Boolean hasAction() {
        return this.action != null;
    }

    @Override
    public A withNewAction(String arg1) {
        return this.withAction(new String(arg1));
    }

    @Override
    public A withNewAction(StringBuilder arg1) {
        return this.withAction(new String(arg1));
    }

    @Override
    public A withNewAction(StringBuffer arg1) {
        return this.withAction(new String(arg1));
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public Integer getDeprecatedCount() {
        return this.deprecatedCount;
    }

    @Override
    public A withDeprecatedCount(Integer deprecatedCount) {
        this.deprecatedCount = deprecatedCount;
        return (A)this;
    }

    @Override
    public Boolean hasDeprecatedCount() {
        return this.deprecatedCount != null;
    }

    @Override
    public String getDeprecatedFirstTimestamp() {
        return this.deprecatedFirstTimestamp;
    }

    @Override
    public A withDeprecatedFirstTimestamp(String deprecatedFirstTimestamp) {
        this.deprecatedFirstTimestamp = deprecatedFirstTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasDeprecatedFirstTimestamp() {
        return this.deprecatedFirstTimestamp != null;
    }

    @Override
    public A withNewDeprecatedFirstTimestamp(String arg1) {
        return this.withDeprecatedFirstTimestamp(new String(arg1));
    }

    @Override
    public A withNewDeprecatedFirstTimestamp(StringBuilder arg1) {
        return this.withDeprecatedFirstTimestamp(new String(arg1));
    }

    @Override
    public A withNewDeprecatedFirstTimestamp(StringBuffer arg1) {
        return this.withDeprecatedFirstTimestamp(new String(arg1));
    }

    @Override
    public String getDeprecatedLastTimestamp() {
        return this.deprecatedLastTimestamp;
    }

    @Override
    public A withDeprecatedLastTimestamp(String deprecatedLastTimestamp) {
        this.deprecatedLastTimestamp = deprecatedLastTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasDeprecatedLastTimestamp() {
        return this.deprecatedLastTimestamp != null;
    }

    @Override
    public A withNewDeprecatedLastTimestamp(String arg1) {
        return this.withDeprecatedLastTimestamp(new String(arg1));
    }

    @Override
    public A withNewDeprecatedLastTimestamp(StringBuilder arg1) {
        return this.withDeprecatedLastTimestamp(new String(arg1));
    }

    @Override
    public A withNewDeprecatedLastTimestamp(StringBuffer arg1) {
        return this.withDeprecatedLastTimestamp(new String(arg1));
    }

    @Override
    @Deprecated
    public EventSource getDeprecatedSource() {
        return this.deprecatedSource != null ? this.deprecatedSource.build() : null;
    }

    @Override
    public EventSource buildDeprecatedSource() {
        return this.deprecatedSource != null ? this.deprecatedSource.build() : null;
    }

    @Override
    public A withDeprecatedSource(EventSource deprecatedSource) {
        this._visitables.get("deprecatedSource").remove(this.deprecatedSource);
        if (deprecatedSource != null) {
            this.deprecatedSource = new EventSourceBuilder(deprecatedSource);
            this._visitables.get("deprecatedSource").add(this.deprecatedSource);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDeprecatedSource() {
        return this.deprecatedSource != null;
    }

    @Override
    public A withNewDeprecatedSource(String component, String host) {
        return this.withDeprecatedSource(new EventSource(component, host));
    }

    @Override
    public EventFluent.DeprecatedSourceNested<A> withNewDeprecatedSource() {
        return new DeprecatedSourceNestedImpl();
    }

    @Override
    public EventFluent.DeprecatedSourceNested<A> withNewDeprecatedSourceLike(EventSource item) {
        return new DeprecatedSourceNestedImpl(item);
    }

    @Override
    public EventFluent.DeprecatedSourceNested<A> editDeprecatedSource() {
        return this.withNewDeprecatedSourceLike(this.getDeprecatedSource());
    }

    @Override
    public EventFluent.DeprecatedSourceNested<A> editOrNewDeprecatedSource() {
        return this.withNewDeprecatedSourceLike(this.getDeprecatedSource() != null ? this.getDeprecatedSource() : new EventSourceBuilder().build());
    }

    @Override
    public EventFluent.DeprecatedSourceNested<A> editOrNewDeprecatedSourceLike(EventSource item) {
        return this.withNewDeprecatedSourceLike(this.getDeprecatedSource() != null ? this.getDeprecatedSource() : item);
    }

    @Override
    @Deprecated
    public MicroTime getEventTime() {
        return this.eventTime != null ? this.eventTime.build() : null;
    }

    @Override
    public MicroTime buildEventTime() {
        return this.eventTime != null ? this.eventTime.build() : null;
    }

    @Override
    public A withEventTime(MicroTime eventTime) {
        this._visitables.get("eventTime").remove(this.eventTime);
        if (eventTime != null) {
            this.eventTime = new MicroTimeBuilder(eventTime);
            this._visitables.get("eventTime").add(this.eventTime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasEventTime() {
        return this.eventTime != null;
    }

    @Override
    public A withNewEventTime(String time) {
        return this.withEventTime(new MicroTime(time));
    }

    @Override
    public EventFluent.EventTimeNested<A> withNewEventTime() {
        return new EventTimeNestedImpl();
    }

    @Override
    public EventFluent.EventTimeNested<A> withNewEventTimeLike(MicroTime item) {
        return new EventTimeNestedImpl(item);
    }

    @Override
    public EventFluent.EventTimeNested<A> editEventTime() {
        return this.withNewEventTimeLike(this.getEventTime());
    }

    @Override
    public EventFluent.EventTimeNested<A> editOrNewEventTime() {
        return this.withNewEventTimeLike(this.getEventTime() != null ? this.getEventTime() : new MicroTimeBuilder().build());
    }

    @Override
    public EventFluent.EventTimeNested<A> editOrNewEventTimeLike(MicroTime item) {
        return this.withNewEventTimeLike(this.getEventTime() != null ? this.getEventTime() : item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public EventFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public EventFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public EventFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public EventFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public EventFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public A withNote(String note) {
        this.note = note;
        return (A)this;
    }

    @Override
    public Boolean hasNote() {
        return this.note != null;
    }

    @Override
    public A withNewNote(String arg1) {
        return this.withNote(new String(arg1));
    }

    @Override
    public A withNewNote(StringBuilder arg1) {
        return this.withNote(new String(arg1));
    }

    @Override
    public A withNewNote(StringBuffer arg1) {
        return this.withNote(new String(arg1));
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    public A withNewReason(String arg1) {
        return this.withReason(new String(arg1));
    }

    @Override
    public A withNewReason(StringBuilder arg1) {
        return this.withReason(new String(arg1));
    }

    @Override
    public A withNewReason(StringBuffer arg1) {
        return this.withReason(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectReference getRegarding() {
        return this.regarding != null ? this.regarding.build() : null;
    }

    @Override
    public ObjectReference buildRegarding() {
        return this.regarding != null ? this.regarding.build() : null;
    }

    @Override
    public A withRegarding(ObjectReference regarding) {
        this._visitables.get("regarding").remove(this.regarding);
        if (regarding != null) {
            this.regarding = new ObjectReferenceBuilder(regarding);
            this._visitables.get("regarding").add(this.regarding);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRegarding() {
        return this.regarding != null;
    }

    @Override
    public EventFluent.RegardingNested<A> withNewRegarding() {
        return new RegardingNestedImpl();
    }

    @Override
    public EventFluent.RegardingNested<A> withNewRegardingLike(ObjectReference item) {
        return new RegardingNestedImpl(item);
    }

    @Override
    public EventFluent.RegardingNested<A> editRegarding() {
        return this.withNewRegardingLike(this.getRegarding());
    }

    @Override
    public EventFluent.RegardingNested<A> editOrNewRegarding() {
        return this.withNewRegardingLike(this.getRegarding() != null ? this.getRegarding() : new ObjectReferenceBuilder().build());
    }

    @Override
    public EventFluent.RegardingNested<A> editOrNewRegardingLike(ObjectReference item) {
        return this.withNewRegardingLike(this.getRegarding() != null ? this.getRegarding() : item);
    }

    @Override
    @Deprecated
    public ObjectReference getRelated() {
        return this.related != null ? this.related.build() : null;
    }

    @Override
    public ObjectReference buildRelated() {
        return this.related != null ? this.related.build() : null;
    }

    @Override
    public A withRelated(ObjectReference related) {
        this._visitables.get("related").remove(this.related);
        if (related != null) {
            this.related = new ObjectReferenceBuilder(related);
            this._visitables.get("related").add(this.related);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRelated() {
        return this.related != null;
    }

    @Override
    public EventFluent.RelatedNested<A> withNewRelated() {
        return new RelatedNestedImpl();
    }

    @Override
    public EventFluent.RelatedNested<A> withNewRelatedLike(ObjectReference item) {
        return new RelatedNestedImpl(item);
    }

    @Override
    public EventFluent.RelatedNested<A> editRelated() {
        return this.withNewRelatedLike(this.getRelated());
    }

    @Override
    public EventFluent.RelatedNested<A> editOrNewRelated() {
        return this.withNewRelatedLike(this.getRelated() != null ? this.getRelated() : new ObjectReferenceBuilder().build());
    }

    @Override
    public EventFluent.RelatedNested<A> editOrNewRelatedLike(ObjectReference item) {
        return this.withNewRelatedLike(this.getRelated() != null ? this.getRelated() : item);
    }

    @Override
    public String getReportingController() {
        return this.reportingController;
    }

    @Override
    public A withReportingController(String reportingController) {
        this.reportingController = reportingController;
        return (A)this;
    }

    @Override
    public Boolean hasReportingController() {
        return this.reportingController != null;
    }

    @Override
    public A withNewReportingController(String arg1) {
        return this.withReportingController(new String(arg1));
    }

    @Override
    public A withNewReportingController(StringBuilder arg1) {
        return this.withReportingController(new String(arg1));
    }

    @Override
    public A withNewReportingController(StringBuffer arg1) {
        return this.withReportingController(new String(arg1));
    }

    @Override
    public String getReportingInstance() {
        return this.reportingInstance;
    }

    @Override
    public A withReportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
        return (A)this;
    }

    @Override
    public Boolean hasReportingInstance() {
        return this.reportingInstance != null;
    }

    @Override
    public A withNewReportingInstance(String arg1) {
        return this.withReportingInstance(new String(arg1));
    }

    @Override
    public A withNewReportingInstance(StringBuilder arg1) {
        return this.withReportingInstance(new String(arg1));
    }

    @Override
    public A withNewReportingInstance(StringBuffer arg1) {
        return this.withReportingInstance(new String(arg1));
    }

    @Override
    @Deprecated
    public EventSeries getSeries() {
        return this.series != null ? this.series.build() : null;
    }

    @Override
    public EventSeries buildSeries() {
        return this.series != null ? this.series.build() : null;
    }

    @Override
    public A withSeries(EventSeries series) {
        this._visitables.get("series").remove(this.series);
        if (series != null) {
            this.series = new EventSeriesBuilder(series);
            this._visitables.get("series").add(this.series);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeries() {
        return this.series != null;
    }

    @Override
    public EventFluent.SeriesNested<A> withNewSeries() {
        return new SeriesNestedImpl();
    }

    @Override
    public EventFluent.SeriesNested<A> withNewSeriesLike(EventSeries item) {
        return new SeriesNestedImpl(item);
    }

    @Override
    public EventFluent.SeriesNested<A> editSeries() {
        return this.withNewSeriesLike(this.getSeries());
    }

    @Override
    public EventFluent.SeriesNested<A> editOrNewSeries() {
        return this.withNewSeriesLike(this.getSeries() != null ? this.getSeries() : new EventSeriesBuilder().build());
    }

    @Override
    public EventFluent.SeriesNested<A> editOrNewSeriesLike(EventSeries item) {
        return this.withNewSeriesLike(this.getSeries() != null ? this.getSeries() : item);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    public A withNewType(String arg1) {
        return this.withType(new String(arg1));
    }

    @Override
    public A withNewType(StringBuilder arg1) {
        return this.withType(new String(arg1));
    }

    @Override
    public A withNewType(StringBuffer arg1) {
        return this.withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventFluentImpl that = (EventFluentImpl)o;
        if (this.action != null ? !this.action.equals(that.action) : that.action != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.deprecatedCount != null ? !this.deprecatedCount.equals(that.deprecatedCount) : that.deprecatedCount != null) {
            return false;
        }
        if (this.deprecatedFirstTimestamp != null ? !this.deprecatedFirstTimestamp.equals(that.deprecatedFirstTimestamp) : that.deprecatedFirstTimestamp != null) {
            return false;
        }
        if (this.deprecatedLastTimestamp != null ? !this.deprecatedLastTimestamp.equals(that.deprecatedLastTimestamp) : that.deprecatedLastTimestamp != null) {
            return false;
        }
        if (this.deprecatedSource != null ? !this.deprecatedSource.equals(that.deprecatedSource) : that.deprecatedSource != null) {
            return false;
        }
        if (this.eventTime != null ? !this.eventTime.equals(that.eventTime) : that.eventTime != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.note != null ? !this.note.equals(that.note) : that.note != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.regarding != null ? !this.regarding.equals(that.regarding) : that.regarding != null) {
            return false;
        }
        if (this.related != null ? !this.related.equals(that.related) : that.related != null) {
            return false;
        }
        if (this.reportingController != null ? !this.reportingController.equals(that.reportingController) : that.reportingController != null) {
            return false;
        }
        if (this.reportingInstance != null ? !this.reportingInstance.equals(that.reportingInstance) : that.reportingInstance != null) {
            return false;
        }
        if (this.series != null ? !this.series.equals(that.series) : that.series != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public class SeriesNestedImpl<N>
    extends EventSeriesFluentImpl<EventFluent.SeriesNested<N>>
    implements EventFluent.SeriesNested<N>,
    Nested<N> {
        private final EventSeriesBuilder builder;

        SeriesNestedImpl(EventSeries item) {
            this.builder = new EventSeriesBuilder(this, item);
        }

        SeriesNestedImpl() {
            this.builder = new EventSeriesBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withSeries(this.builder.build());
        }

        @Override
        public N endSeries() {
            return this.and();
        }
    }

    public class RelatedNestedImpl<N>
    extends ObjectReferenceFluentImpl<EventFluent.RelatedNested<N>>
    implements EventFluent.RelatedNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        RelatedNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        RelatedNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withRelated(this.builder.build());
        }

        @Override
        public N endRelated() {
            return this.and();
        }
    }

    public class RegardingNestedImpl<N>
    extends ObjectReferenceFluentImpl<EventFluent.RegardingNested<N>>
    implements EventFluent.RegardingNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        RegardingNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        RegardingNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withRegarding(this.builder.build());
        }

        @Override
        public N endRegarding() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<EventFluent.MetadataNested<N>>
    implements EventFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class EventTimeNestedImpl<N>
    extends MicroTimeFluentImpl<EventFluent.EventTimeNested<N>>
    implements EventFluent.EventTimeNested<N>,
    Nested<N> {
        private final MicroTimeBuilder builder;

        EventTimeNestedImpl(MicroTime item) {
            this.builder = new MicroTimeBuilder(this, item);
        }

        EventTimeNestedImpl() {
            this.builder = new MicroTimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withEventTime(this.builder.build());
        }

        @Override
        public N endEventTime() {
            return this.and();
        }
    }

    public class DeprecatedSourceNestedImpl<N>
    extends EventSourceFluentImpl<EventFluent.DeprecatedSourceNested<N>>
    implements EventFluent.DeprecatedSourceNested<N>,
    Nested<N> {
        private final EventSourceBuilder builder;

        DeprecatedSourceNestedImpl(EventSource item) {
            this.builder = new EventSourceBuilder(this, item);
        }

        DeprecatedSourceNestedImpl() {
            this.builder = new EventSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withDeprecatedSource(this.builder.build());
        }

        @Override
        public N endDeprecatedSource() {
            return this.and();
        }
    }
}

