/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_7;

import io.fabric8.kubernetes.api.builder.v4_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_7.Nested;
import io.fabric8.kubernetes.api.builder.v4_7.Predicate;
import io.fabric8.kubernetes.api.model.v4_7.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v4_7.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_7.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v4_7.ObjectMeta;
import io.fabric8.kubernetes.api.model.v4_7.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v4_7.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v4_7.ObjectReference;
import io.fabric8.kubernetes.api.model.v4_7.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_7.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v4_7.ServiceAccount;
import io.fabric8.kubernetes.api.model.v4_7.ServiceAccountFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ServiceAccountFluentImpl<A extends ServiceAccountFluent<A>>
extends BaseFluent<A>
implements ServiceAccountFluent<A> {
    private String apiVersion;
    private Boolean automountServiceAccountToken;
    private List<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<ObjectReferenceBuilder> secrets = new ArrayList<ObjectReferenceBuilder>();

    public ServiceAccountFluentImpl() {
    }

    public ServiceAccountFluentImpl(ServiceAccount instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSecrets(instance.getSecrets());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public Boolean isAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    @Override
    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return (A)this;
    }

    @Override
    public Boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    @Override
    public A withNewAutomountServiceAccountToken(String arg1) {
        return this.withAutomountServiceAccountToken(new Boolean(arg1));
    }

    @Override
    public A withNewAutomountServiceAccountToken(boolean arg1) {
        return this.withAutomountServiceAccountToken(new Boolean(arg1));
    }

    @Override
    public A addToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        this._visitables.get("imagePullSecrets").add(index >= 0 ? index : this._visitables.get("imagePullSecrets").size(), builder);
        this.imagePullSecrets.add(index >= 0 ? index : this.imagePullSecrets.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get("imagePullSecrets").size()) {
            this._visitables.get("imagePullSecrets").add(builder);
        } else {
            this._visitables.get("imagePullSecrets").set(index, builder);
        }
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this.imagePullSecrets.add(builder);
        } else {
            this.imagePullSecrets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        Iterator<LocalObjectReferenceBuilder> each = this.imagePullSecrets.iterator();
        Object visitables = this._visitables.get("imagePullSecrets");
        while (each.hasNext()) {
            LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<LocalObjectReference> getImagePullSecrets() {
        return ServiceAccountFluentImpl.build(this.imagePullSecrets);
    }

    @Override
    public List<LocalObjectReference> buildImagePullSecrets() {
        return ServiceAccountFluentImpl.build(this.imagePullSecrets);
    }

    @Override
    public LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    @Override
    public LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    @Override
    public LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1).build();
    }

    @Override
    public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get("imagePullSecrets").removeAll(this.imagePullSecrets);
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)this;
    }

    @Override
    public A withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
        }
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    @Override
    public A addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    @Override
    public ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNestedImpl();
    }

    @Override
    public ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(-1, item);
    }

    @Override
    public ServiceAccountFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index, LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(index, item);
    }

    @Override
    public ServiceAccountFluent.ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (this.imagePullSecrets.size() <= index) {
            throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public ServiceAccountFluent.ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (this.imagePullSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(0, this.buildImagePullSecret(0));
    }

    @Override
    public ServiceAccountFluent.ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = this.imagePullSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public ServiceAccountFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imagePullSecrets.size(); ++i) {
            if (!predicate.apply(this.imagePullSecrets.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ServiceAccountFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ServiceAccountFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ServiceAccountFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ServiceAccountFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ServiceAccountFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToSecrets(int index, ObjectReference item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<ObjectReferenceBuilder>();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        this._visitables.get("secrets").add(index >= 0 ? index : this._visitables.get("secrets").size(), builder);
        this.secrets.add(index >= 0 ? index : this.secrets.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSecrets(int index, ObjectReference item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<ObjectReferenceBuilder>();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get("secrets").size()) {
            this._visitables.get("secrets").add(builder);
        } else {
            this._visitables.get("secrets").set(index, builder);
        }
        if (index < 0 || index >= this.secrets.size()) {
            this.secrets.add(builder);
        } else {
            this.secrets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSecrets(ObjectReference ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<ObjectReferenceBuilder>();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecrets(Collection<ObjectReference> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<ObjectReferenceBuilder>();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecrets(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("secrets").remove(builder);
            if (this.secrets == null) continue;
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecrets(Collection<ObjectReference> items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("secrets").remove(builder);
            if (this.secrets == null) continue;
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSecrets(Predicate<ObjectReferenceBuilder> predicate) {
        if (this.secrets == null) {
            return (A)this;
        }
        Iterator<ObjectReferenceBuilder> each = this.secrets.iterator();
        Object visitables = this._visitables.get("secrets");
        while (each.hasNext()) {
            ObjectReferenceBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ObjectReference> getSecrets() {
        return ServiceAccountFluentImpl.build(this.secrets);
    }

    @Override
    public List<ObjectReference> buildSecrets() {
        return ServiceAccountFluentImpl.build(this.secrets);
    }

    @Override
    public ObjectReference buildSecret(int index) {
        return this.secrets.get(index).build();
    }

    @Override
    public ObjectReference buildFirstSecret() {
        return this.secrets.get(0).build();
    }

    @Override
    public ObjectReference buildLastSecret() {
        return this.secrets.get(this.secrets.size() - 1).build();
    }

    @Override
    public ObjectReference buildMatchingSecret(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.secrets) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSecret(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.secrets) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSecrets(List<ObjectReference> secrets) {
        if (this.secrets != null) {
            this._visitables.get("secrets").removeAll(this.secrets);
        }
        if (secrets != null) {
            this.secrets = new ArrayList<ObjectReferenceBuilder>();
            for (ObjectReference item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)this;
    }

    @Override
    public A withSecrets(ObjectReference ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
        }
        if (secrets != null) {
            for (ObjectReference item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    @Override
    public ServiceAccountFluent.SecretsNested<A> addNewSecret() {
        return new SecretsNestedImpl();
    }

    @Override
    public ServiceAccountFluent.SecretsNested<A> addNewSecretLike(ObjectReference item) {
        return new SecretsNestedImpl(-1, item);
    }

    @Override
    public ServiceAccountFluent.SecretsNested<A> setNewSecretLike(int index, ObjectReference item) {
        return new SecretsNestedImpl(index, item);
    }

    @Override
    public ServiceAccountFluent.SecretsNested<A> editSecret(int index) {
        if (this.secrets.size() <= index) {
            throw new RuntimeException("Can't edit secrets. Index exceeds size.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public ServiceAccountFluent.SecretsNested<A> editFirstSecret() {
        if (this.secrets.size() == 0) {
            throw new RuntimeException("Can't edit first secrets. The list is empty.");
        }
        return this.setNewSecretLike(0, this.buildSecret(0));
    }

    @Override
    public ServiceAccountFluent.SecretsNested<A> editLastSecret() {
        int index = this.secrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secrets. The list is empty.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public ServiceAccountFluent.SecretsNested<A> editMatchingSecret(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secrets.size(); ++i) {
            if (!predicate.apply(this.secrets.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secrets. No match found.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceAccountFluentImpl that = (ServiceAccountFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.automountServiceAccountToken != null ? !this.automountServiceAccountToken.equals(that.automountServiceAccountToken) : that.automountServiceAccountToken != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null);
    }

    public class SecretsNestedImpl<N>
    extends ObjectReferenceFluentImpl<ServiceAccountFluent.SecretsNested<N>>
    implements ServiceAccountFluent.SecretsNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;
        private final int index;

        SecretsNestedImpl(int index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        SecretsNestedImpl() {
            this.index = -1;
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceAccountFluentImpl.this.setToSecrets(this.index, this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ServiceAccountFluent.MetadataNested<N>>
    implements ServiceAccountFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceAccountFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ImagePullSecretsNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ServiceAccountFluent.ImagePullSecretsNested<N>>
    implements ServiceAccountFluent.ImagePullSecretsNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;
        private final int index;

        ImagePullSecretsNestedImpl(int index, LocalObjectReference item) {
            this.index = index;
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        ImagePullSecretsNestedImpl() {
            this.index = -1;
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceAccountFluentImpl.this.setToImagePullSecrets(this.index, this.builder.build());
        }

        @Override
        public N endImagePullSecret() {
            return this.and();
        }
    }
}

