/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_6.batch;

import io.fabric8.kubernetes.api.builder.v4_6.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_6.batch.JobSpec;
import io.fabric8.kubernetes.api.model.v4_6.batch.JobSpecFluent;
import io.fabric8.kubernetes.api.model.v4_6.batch.JobSpecFluentImpl;

public class JobSpecBuilder
extends JobSpecFluentImpl<JobSpecBuilder>
implements VisitableBuilder<JobSpec, JobSpecBuilder> {
    JobSpecFluent<?> fluent;
    Boolean validationEnabled;

    public JobSpecBuilder() {
        this(true);
    }

    public JobSpecBuilder(Boolean validationEnabled) {
        this(new JobSpec(), validationEnabled);
    }

    public JobSpecBuilder(JobSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public JobSpecBuilder(JobSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new JobSpec(), validationEnabled);
    }

    public JobSpecBuilder(JobSpecFluent<?> fluent, JobSpec instance) {
        this(fluent, instance, true);
    }

    public JobSpecBuilder(JobSpecFluent<?> fluent, JobSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        fluent.withBackoffLimit(instance.getBackoffLimit());
        fluent.withCompletions(instance.getCompletions());
        fluent.withManualSelector(instance.getManualSelector());
        fluent.withParallelism(instance.getParallelism());
        fluent.withSelector(instance.getSelector());
        fluent.withTemplate(instance.getTemplate());
        fluent.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
        this.validationEnabled = validationEnabled;
    }

    public JobSpecBuilder(JobSpec instance) {
        this(instance, (Boolean)true);
    }

    public JobSpecBuilder(JobSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withBackoffLimit(instance.getBackoffLimit());
        this.withCompletions(instance.getCompletions());
        this.withManualSelector(instance.getManualSelector());
        this.withParallelism(instance.getParallelism());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
        this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public JobSpec build() {
        JobSpec buildable = new JobSpec(this.fluent.getActiveDeadlineSeconds(), this.fluent.getBackoffLimit(), this.fluent.getCompletions(), this.fluent.isManualSelector(), this.fluent.getParallelism(), this.fluent.getSelector(), this.fluent.getTemplate(), this.fluent.getTtlSecondsAfterFinished());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobSpecBuilder that = (JobSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

