/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_6;

import io.fabric8.kubernetes.api.builder.v4_6.BaseFluent;
import io.fabric8.kubernetes.clnt.v4_6.OAuthTokenProvider;
import io.fabric8.kubernetes.clnt.v4_6.RequestConfig;
import io.fabric8.kubernetes.clnt.v4_6.RequestConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RequestConfigFluentImpl<A extends RequestConfigFluent<A>>
extends BaseFluent<A>
implements RequestConfigFluent<A> {
    private String username;
    private String password;
    private String oauthToken;
    private OAuthTokenProvider oauthTokenProvider;
    private String impersonateUsername;
    private List<String> impersonateGroups;
    private Map<String, List<String>> impersonateExtras;
    private int watchReconnectInterval;
    private int watchReconnectLimit;
    private int connectionTimeout;
    private int requestTimeout;
    private long rollingTimeout;
    private long scaleTimeout;
    private int loggingInterval;
    private long websocketTimeout;
    private long websocketPingInterval;
    private int maxConcurrentRequests;
    private int maxConcurrentRequestsPerHost;

    public RequestConfigFluentImpl() {
    }

    public RequestConfigFluentImpl(RequestConfig instance) {
        this.withUsername(instance.getUsername());
        this.withPassword(instance.getPassword());
        this.withOauthToken(instance.getOauthToken());
        this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
        this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
        this.withConnectionTimeout(instance.getConnectionTimeout());
        this.withRollingTimeout(instance.getRollingTimeout());
        this.withRequestTimeout(instance.getRequestTimeout());
        this.withScaleTimeout(instance.getScaleTimeout());
        this.withLoggingInterval(instance.getLoggingInterval());
        this.withWebsocketTimeout(instance.getWebsocketTimeout());
        this.withWebsocketPingInterval(instance.getWebsocketPingInterval());
        this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());
        this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());
        this.withOauthTokenProvider(instance.getOauthTokenProvider());
        this.withImpersonateUsername(instance.getImpersonateUsername());
        this.withImpersonateGroups(instance.getImpersonateGroups());
        this.withImpersonateExtras(instance.getImpersonateExtras());
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    @Override
    public Boolean hasUsername() {
        return this.username != null;
    }

    @Override
    public A withNewUsername(String arg1) {
        return this.withUsername(new String(arg1));
    }

    @Override
    public A withNewUsername(StringBuilder arg1) {
        return this.withUsername(new String(arg1));
    }

    @Override
    public A withNewUsername(StringBuffer arg1) {
        return this.withUsername(new String(arg1));
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public A withPassword(String password) {
        this.password = password;
        return (A)this;
    }

    @Override
    public Boolean hasPassword() {
        return this.password != null;
    }

    @Override
    public A withNewPassword(String arg1) {
        return this.withPassword(new String(arg1));
    }

    @Override
    public A withNewPassword(StringBuilder arg1) {
        return this.withPassword(new String(arg1));
    }

    @Override
    public A withNewPassword(StringBuffer arg1) {
        return this.withPassword(new String(arg1));
    }

    @Override
    public String getOauthToken() {
        return this.oauthToken;
    }

    @Override
    public A withOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
        return (A)this;
    }

    @Override
    public Boolean hasOauthToken() {
        return this.oauthToken != null;
    }

    @Override
    public A withNewOauthToken(String arg1) {
        return this.withOauthToken(new String(arg1));
    }

    @Override
    public A withNewOauthToken(StringBuilder arg1) {
        return this.withOauthToken(new String(arg1));
    }

    @Override
    public A withNewOauthToken(StringBuffer arg1) {
        return this.withOauthToken(new String(arg1));
    }

    @Override
    public OAuthTokenProvider getOauthTokenProvider() {
        return this.oauthTokenProvider;
    }

    @Override
    public A withOauthTokenProvider(OAuthTokenProvider oauthTokenProvider) {
        this.oauthTokenProvider = oauthTokenProvider;
        return (A)this;
    }

    @Override
    public Boolean hasOauthTokenProvider() {
        return this.oauthTokenProvider != null;
    }

    @Override
    public String getImpersonateUsername() {
        return this.impersonateUsername;
    }

    @Override
    public A withImpersonateUsername(String impersonateUsername) {
        this.impersonateUsername = impersonateUsername;
        return (A)this;
    }

    @Override
    public Boolean hasImpersonateUsername() {
        return this.impersonateUsername != null;
    }

    @Override
    public A withNewImpersonateUsername(String arg1) {
        return this.withImpersonateUsername(new String(arg1));
    }

    @Override
    public A withNewImpersonateUsername(StringBuilder arg1) {
        return this.withImpersonateUsername(new String(arg1));
    }

    @Override
    public A withNewImpersonateUsername(StringBuffer arg1) {
        return this.withImpersonateUsername(new String(arg1));
    }

    @Override
    public A withImpersonateGroups(String ... impersonateGroups) {
        if (this.impersonateGroups != null) {
            this.impersonateGroups.clear();
        }
        if (impersonateGroups != null) {
            for (String item : impersonateGroups) {
                this.addToImpersonateGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getImpersonateGroups() {
        int size = this.impersonateGroups != null ? this.impersonateGroups.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.impersonateGroups) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToImpersonateGroups(int index, String item) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        this.impersonateGroups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToImpersonateGroups(int index, String item) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        this.impersonateGroups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToImpersonateGroups(String ... items) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.impersonateGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToImpersonateGroups(Collection<String> items) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.impersonateGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromImpersonateGroups(String ... items) {
        for (String item : items) {
            if (this.impersonateGroups == null) continue;
            this.impersonateGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImpersonateGroups(Collection<String> items) {
        for (String item : items) {
            if (this.impersonateGroups == null) continue;
            this.impersonateGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImpersonateGroups() {
        return this.impersonateGroups != null && !this.impersonateGroups.isEmpty();
    }

    @Override
    public A addNewImpersonateGroup(String arg1) {
        return this.addToImpersonateGroups(new String(arg1));
    }

    @Override
    public A addNewImpersonateGroup(StringBuilder arg1) {
        return this.addToImpersonateGroups(new String(arg1));
    }

    @Override
    public A addNewImpersonateGroup(StringBuffer arg1) {
        return this.addToImpersonateGroups(new String(arg1));
    }

    @Override
    public A addToImpersonateExtras(String key, List<String> value) {
        if (this.impersonateExtras == null && key != null && value != null) {
            this.impersonateExtras = new LinkedHashMap<String, List<String>>();
        }
        if (key != null && value != null) {
            this.impersonateExtras.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToImpersonateExtras(Map<String, List<String>> map) {
        if (this.impersonateExtras == null && map != null) {
            this.impersonateExtras = new LinkedHashMap<String, List<String>>();
        }
        if (map != null) {
            this.impersonateExtras.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromImpersonateExtras(String key) {
        if (this.impersonateExtras == null) {
            return (A)this;
        }
        if (key != null && this.impersonateExtras != null) {
            this.impersonateExtras.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromImpersonateExtras(Map<String, List<String>> map) {
        if (this.impersonateExtras == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.impersonateExtras == null) continue;
                this.impersonateExtras.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, List<String>> getImpersonateExtras() {
        return this.impersonateExtras;
    }

    @Override
    public A withImpersonateExtras(Map<String, List<String>> impersonateExtras) {
        this.impersonateExtras = impersonateExtras == null ? new LinkedHashMap<String, List<String>>() : new LinkedHashMap<String, List<String>>(impersonateExtras);
        return (A)this;
    }

    @Override
    public Boolean hasImpersonateExtras() {
        return this.impersonateExtras != null;
    }

    @Override
    public int getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    @Override
    public A withWatchReconnectInterval(int watchReconnectInterval) {
        this.watchReconnectInterval = watchReconnectInterval;
        return (A)this;
    }

    @Override
    public Boolean hasWatchReconnectInterval() {
        return true;
    }

    @Override
    public int getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    @Override
    public A withWatchReconnectLimit(int watchReconnectLimit) {
        this.watchReconnectLimit = watchReconnectLimit;
        return (A)this;
    }

    @Override
    public Boolean hasWatchReconnectLimit() {
        return true;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public A withConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasConnectionTimeout() {
        return true;
    }

    @Override
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public A withRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasRequestTimeout() {
        return true;
    }

    @Override
    public long getRollingTimeout() {
        return this.rollingTimeout;
    }

    @Override
    public A withRollingTimeout(long rollingTimeout) {
        this.rollingTimeout = rollingTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasRollingTimeout() {
        return true;
    }

    @Override
    public long getScaleTimeout() {
        return this.scaleTimeout;
    }

    @Override
    public A withScaleTimeout(long scaleTimeout) {
        this.scaleTimeout = scaleTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasScaleTimeout() {
        return true;
    }

    @Override
    public int getLoggingInterval() {
        return this.loggingInterval;
    }

    @Override
    public A withLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
        return (A)this;
    }

    @Override
    public Boolean hasLoggingInterval() {
        return true;
    }

    @Override
    public long getWebsocketTimeout() {
        return this.websocketTimeout;
    }

    @Override
    public A withWebsocketTimeout(long websocketTimeout) {
        this.websocketTimeout = websocketTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasWebsocketTimeout() {
        return true;
    }

    @Override
    public long getWebsocketPingInterval() {
        return this.websocketPingInterval;
    }

    @Override
    public A withWebsocketPingInterval(long websocketPingInterval) {
        this.websocketPingInterval = websocketPingInterval;
        return (A)this;
    }

    @Override
    public Boolean hasWebsocketPingInterval() {
        return true;
    }

    @Override
    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    @Override
    public A withMaxConcurrentRequests(int maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
        return (A)this;
    }

    @Override
    public Boolean hasMaxConcurrentRequests() {
        return true;
    }

    @Override
    public int getMaxConcurrentRequestsPerHost() {
        return this.maxConcurrentRequestsPerHost;
    }

    @Override
    public A withMaxConcurrentRequestsPerHost(int maxConcurrentRequestsPerHost) {
        this.maxConcurrentRequestsPerHost = maxConcurrentRequestsPerHost;
        return (A)this;
    }

    @Override
    public Boolean hasMaxConcurrentRequestsPerHost() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequestConfigFluentImpl that = (RequestConfigFluentImpl)o;
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.oauthToken != null ? !this.oauthToken.equals(that.oauthToken) : that.oauthToken != null) {
            return false;
        }
        if (this.oauthTokenProvider != null ? !this.oauthTokenProvider.equals(that.oauthTokenProvider) : that.oauthTokenProvider != null) {
            return false;
        }
        if (this.impersonateUsername != null ? !this.impersonateUsername.equals(that.impersonateUsername) : that.impersonateUsername != null) {
            return false;
        }
        if (this.impersonateGroups != null ? !this.impersonateGroups.equals(that.impersonateGroups) : that.impersonateGroups != null) {
            return false;
        }
        if (this.impersonateExtras != null ? !this.impersonateExtras.equals(that.impersonateExtras) : that.impersonateExtras != null) {
            return false;
        }
        if (this.watchReconnectInterval != that.watchReconnectInterval) {
            return false;
        }
        if (this.watchReconnectLimit != that.watchReconnectLimit) {
            return false;
        }
        if (this.connectionTimeout != that.connectionTimeout) {
            return false;
        }
        if (this.requestTimeout != that.requestTimeout) {
            return false;
        }
        if (this.rollingTimeout != that.rollingTimeout) {
            return false;
        }
        if (this.scaleTimeout != that.scaleTimeout) {
            return false;
        }
        if (this.loggingInterval != that.loggingInterval) {
            return false;
        }
        if (this.websocketTimeout != that.websocketTimeout) {
            return false;
        }
        if (this.websocketPingInterval != that.websocketPingInterval) {
            return false;
        }
        if (this.maxConcurrentRequests != that.maxConcurrentRequests) {
            return false;
        }
        return this.maxConcurrentRequestsPerHost == that.maxConcurrentRequestsPerHost;
    }
}

