/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_5;

import io.fabric8.kubernetes.api.builder.v4_5.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_5.Nested;
import io.fabric8.kubernetes.api.builder.v4_5.Predicate;
import io.fabric8.kubernetes.api.model.v4_5.Container;
import io.fabric8.kubernetes.api.model.v4_5.ContainerFluent;
import io.fabric8.kubernetes.api.model.v4_5.ContainerPort;
import io.fabric8.kubernetes.api.model.v4_5.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.v4_5.ContainerPortFluentImpl;
import io.fabric8.kubernetes.api.model.v4_5.EnvFromSource;
import io.fabric8.kubernetes.api.model.v4_5.EnvFromSourceBuilder;
import io.fabric8.kubernetes.api.model.v4_5.EnvFromSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v4_5.EnvVar;
import io.fabric8.kubernetes.api.model.v4_5.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.v4_5.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.v4_5.Lifecycle;
import io.fabric8.kubernetes.api.model.v4_5.LifecycleBuilder;
import io.fabric8.kubernetes.api.model.v4_5.LifecycleFluentImpl;
import io.fabric8.kubernetes.api.model.v4_5.Probe;
import io.fabric8.kubernetes.api.model.v4_5.ProbeBuilder;
import io.fabric8.kubernetes.api.model.v4_5.ProbeFluentImpl;
import io.fabric8.kubernetes.api.model.v4_5.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v4_5.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.v4_5.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.v4_5.SecurityContext;
import io.fabric8.kubernetes.api.model.v4_5.SecurityContextBuilder;
import io.fabric8.kubernetes.api.model.v4_5.SecurityContextFluentImpl;
import io.fabric8.kubernetes.api.model.v4_5.VolumeDevice;
import io.fabric8.kubernetes.api.model.v4_5.VolumeDeviceBuilder;
import io.fabric8.kubernetes.api.model.v4_5.VolumeDeviceFluentImpl;
import io.fabric8.kubernetes.api.model.v4_5.VolumeMount;
import io.fabric8.kubernetes.api.model.v4_5.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.v4_5.VolumeMountFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContainerFluentImpl<A extends ContainerFluent<A>>
extends BaseFluent<A>
implements ContainerFluent<A> {
    private List<String> args;
    private List<String> command;
    private List<EnvVarBuilder> env;
    private List<EnvFromSourceBuilder> envFrom;
    private String image;
    private String imagePullPolicy;
    private LifecycleBuilder lifecycle;
    private ProbeBuilder livenessProbe;
    private String name;
    private List<ContainerPortBuilder> ports;
    private ProbeBuilder readinessProbe;
    private ResourceRequirementsBuilder resources;
    private SecurityContextBuilder securityContext;
    private Boolean stdin;
    private Boolean stdinOnce;
    private String terminationMessagePath;
    private String terminationMessagePolicy;
    private Boolean tty;
    private List<VolumeDeviceBuilder> volumeDevices;
    private List<VolumeMountBuilder> volumeMounts;
    private String workingDir;

    public ContainerFluentImpl() {
    }

    public ContainerFluentImpl(Container instance) {
        this.withArgs(instance.getArgs());
        this.withCommand(instance.getCommand());
        this.withEnv(instance.getEnv());
        this.withEnvFrom(instance.getEnvFrom());
        this.withImage(instance.getImage());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withLifecycle(instance.getLifecycle());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withName(instance.getName());
        this.withPorts(instance.getPorts());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withResources(instance.getResources());
        this.withSecurityContext(instance.getSecurityContext());
        this.withStdin(instance.getStdin());
        this.withStdinOnce(instance.getStdinOnce());
        this.withTerminationMessagePath(instance.getTerminationMessagePath());
        this.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());
        this.withTty(instance.getTty());
        this.withVolumeDevices(instance.getVolumeDevices());
        this.withVolumeMounts(instance.getVolumeMounts());
        this.withWorkingDir(instance.getWorkingDir());
    }

    @Override
    public A addToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(index, item);
        return (A)this;
    }

    @Override
    public A setToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.set(index, item);
        return (A)this;
    }

    @Override
    public A addToArgs(String ... items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToArgs(Collection<String> items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromArgs(String ... items) {
        for (String item : items) {
            if (this.args == null) continue;
            this.args.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromArgs(Collection<String> items) {
        for (String item : items) {
            if (this.args == null) continue;
            this.args.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getArgs() {
        return this.args;
    }

    @Override
    public String getArg(int index) {
        return this.args.get(index);
    }

    @Override
    public String getFirstArg() {
        return this.args.get(0);
    }

    @Override
    public String getLastArg() {
        return this.args.get(this.args.size() - 1);
    }

    @Override
    public String getMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withArgs(List<String> args) {
        if (this.args != null) {
            this._visitables.get("args").removeAll(this.args);
        }
        if (args != null) {
            this.args = new ArrayList<String>();
            for (String item : args) {
                this.addToArgs(item);
            }
        } else {
            this.args = new ArrayList<String>();
        }
        return (A)this;
    }

    @Override
    public A withArgs(String ... args) {
        if (this.args != null) {
            this.args.clear();
        }
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasArgs() {
        return this.args != null && !this.args.isEmpty();
    }

    @Override
    public A addNewArg(String arg1) {
        return this.addToArgs(new String(arg1));
    }

    @Override
    public A addNewArg(StringBuilder arg1) {
        return this.addToArgs(new String(arg1));
    }

    @Override
    public A addNewArg(StringBuffer arg1) {
        return this.addToArgs(new String(arg1));
    }

    @Override
    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCommand(String ... items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCommand(Collection<String> items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    @Override
    public String getCommand(int index) {
        return this.command.get(index);
    }

    @Override
    public String getFirstCommand() {
        return this.command.get(0);
    }

    @Override
    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    @Override
    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCommand(List<String> command) {
        if (this.command != null) {
            this._visitables.get("command").removeAll(this.command);
        }
        if (command != null) {
            this.command = new ArrayList<String>();
            for (String item : command) {
                this.addToCommand(item);
            }
        } else {
            this.command = new ArrayList<String>();
        }
        return (A)this;
    }

    @Override
    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    @Override
    public A addNewCommand(String arg1) {
        return this.addToCommand(new String(arg1));
    }

    @Override
    public A addNewCommand(StringBuilder arg1) {
        return this.addToCommand(new String(arg1));
    }

    @Override
    public A addNewCommand(StringBuffer arg1) {
        return this.addToCommand(new String(arg1));
    }

    @Override
    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        this._visitables.get("env").add(index >= 0 ? index : this._visitables.get("env").size(), builder);
        this.env.add(index >= 0 ? index : this.env.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this._visitables.get("env").size()) {
            this._visitables.get("env").add(builder);
        } else {
            this._visitables.get("env").set(index, builder);
        }
        if (index < 0 || index >= this.env.size()) {
            this.env.add(builder);
        } else {
            this.env.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("env").remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get("env").remove(builder);
            if (this.env == null) continue;
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EnvVar> getEnv() {
        return ContainerFluentImpl.build(this.env);
    }

    @Override
    public List<EnvVar> buildEnv() {
        return ContainerFluentImpl.build(this.env);
    }

    @Override
    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    @Override
    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    @Override
    public EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    @Override
    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        if (this.env != null) {
            this._visitables.get("env").removeAll(this.env);
        }
        if (env != null) {
            this.env = new ArrayList<EnvVarBuilder>();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = new ArrayList<EnvVarBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    public ContainerFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public ContainerFluent.EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNestedImpl(-1, item);
    }

    @Override
    public ContainerFluent.EnvNested<A> setNewEnvLike(int index, EnvVar item) {
        return new EnvNestedImpl(index, item);
    }

    @Override
    public ContainerFluent.EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public ContainerFluent.EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    @Override
    public ContainerFluent.EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public ContainerFluent.EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.apply(this.env.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public A addToEnvFrom(int index, EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSourceBuilder>();
        }
        EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
        this._visitables.get("envFrom").add(index >= 0 ? index : this._visitables.get("envFrom").size(), builder);
        this.envFrom.add(index >= 0 ? index : this.envFrom.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnvFrom(int index, EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSourceBuilder>();
        }
        EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
        if (index < 0 || index >= this._visitables.get("envFrom").size()) {
            this._visitables.get("envFrom").add(builder);
        } else {
            this._visitables.get("envFrom").set(index, builder);
        }
        if (index < 0 || index >= this.envFrom.size()) {
            this.envFrom.add(builder);
        } else {
            this.envFrom.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnvFrom(EnvFromSource ... items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSourceBuilder>();
        }
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").add(builder);
            this.envFrom.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnvFrom(Collection<EnvFromSource> items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<EnvFromSourceBuilder>();
        }
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").add(builder);
            this.envFrom.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvFrom(EnvFromSource ... items) {
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").remove(builder);
            if (this.envFrom == null) continue;
            this.envFrom.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnvFrom(Collection<EnvFromSource> items) {
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").remove(builder);
            if (this.envFrom == null) continue;
            this.envFrom.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EnvFromSource> getEnvFrom() {
        return ContainerFluentImpl.build(this.envFrom);
    }

    @Override
    public List<EnvFromSource> buildEnvFrom() {
        return ContainerFluentImpl.build(this.envFrom);
    }

    @Override
    public EnvFromSource buildEnvFrom(int index) {
        return this.envFrom.get(index).build();
    }

    @Override
    public EnvFromSource buildFirstEnvFrom() {
        return this.envFrom.get(0).build();
    }

    @Override
    public EnvFromSource buildLastEnvFrom() {
        return this.envFrom.get(this.envFrom.size() - 1).build();
    }

    @Override
    public EnvFromSource buildMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
        for (EnvFromSourceBuilder item : this.envFrom) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
        for (EnvFromSourceBuilder item : this.envFrom) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnvFrom(List<EnvFromSource> envFrom) {
        if (this.envFrom != null) {
            this._visitables.get("envFrom").removeAll(this.envFrom);
        }
        if (envFrom != null) {
            this.envFrom = new ArrayList<EnvFromSourceBuilder>();
            for (EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        } else {
            this.envFrom = new ArrayList<EnvFromSourceBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withEnvFrom(EnvFromSource ... envFrom) {
        if (this.envFrom != null) {
            this.envFrom.clear();
        }
        if (envFrom != null) {
            for (EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnvFrom() {
        return this.envFrom != null && !this.envFrom.isEmpty();
    }

    @Override
    public ContainerFluent.EnvFromNested<A> addNewEnvFrom() {
        return new EnvFromNestedImpl();
    }

    @Override
    public ContainerFluent.EnvFromNested<A> addNewEnvFromLike(EnvFromSource item) {
        return new EnvFromNestedImpl(-1, item);
    }

    @Override
    public ContainerFluent.EnvFromNested<A> setNewEnvFromLike(int index, EnvFromSource item) {
        return new EnvFromNestedImpl(index, item);
    }

    @Override
    public ContainerFluent.EnvFromNested<A> editEnvFrom(int index) {
        if (this.envFrom.size() <= index) {
            throw new RuntimeException("Can't edit envFrom. Index exceeds size.");
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    @Override
    public ContainerFluent.EnvFromNested<A> editFirstEnvFrom() {
        if (this.envFrom.size() == 0) {
            throw new RuntimeException("Can't edit first envFrom. The list is empty.");
        }
        return this.setNewEnvFromLike(0, this.buildEnvFrom(0));
    }

    @Override
    public ContainerFluent.EnvFromNested<A> editLastEnvFrom() {
        int index = this.envFrom.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envFrom. The list is empty.");
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    @Override
    public ContainerFluent.EnvFromNested<A> editMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envFrom.size(); ++i) {
            if (!predicate.apply(this.envFrom.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envFrom. No match found.");
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public A withNewImage(String arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuilder arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuffer arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    @Override
    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    @Override
    public A withNewImagePullPolicy(String arg1) {
        return this.withImagePullPolicy(new String(arg1));
    }

    @Override
    public A withNewImagePullPolicy(StringBuilder arg1) {
        return this.withImagePullPolicy(new String(arg1));
    }

    @Override
    public A withNewImagePullPolicy(StringBuffer arg1) {
        return this.withImagePullPolicy(new String(arg1));
    }

    @Override
    @Deprecated
    public Lifecycle getLifecycle() {
        return this.lifecycle != null ? this.lifecycle.build() : null;
    }

    @Override
    public Lifecycle buildLifecycle() {
        return this.lifecycle != null ? this.lifecycle.build() : null;
    }

    @Override
    public A withLifecycle(Lifecycle lifecycle) {
        this._visitables.get("lifecycle").remove(this.lifecycle);
        if (lifecycle != null) {
            this.lifecycle = new LifecycleBuilder(lifecycle);
            this._visitables.get("lifecycle").add(this.lifecycle);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLifecycle() {
        return this.lifecycle != null;
    }

    @Override
    public ContainerFluent.LifecycleNested<A> withNewLifecycle() {
        return new LifecycleNestedImpl();
    }

    @Override
    public ContainerFluent.LifecycleNested<A> withNewLifecycleLike(Lifecycle item) {
        return new LifecycleNestedImpl(item);
    }

    @Override
    public ContainerFluent.LifecycleNested<A> editLifecycle() {
        return this.withNewLifecycleLike(this.getLifecycle());
    }

    @Override
    public ContainerFluent.LifecycleNested<A> editOrNewLifecycle() {
        return this.withNewLifecycleLike(this.getLifecycle() != null ? this.getLifecycle() : new LifecycleBuilder().build());
    }

    @Override
    public ContainerFluent.LifecycleNested<A> editOrNewLifecycleLike(Lifecycle item) {
        return this.withNewLifecycleLike(this.getLifecycle() != null ? this.getLifecycle() : item);
    }

    @Override
    @Deprecated
    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.get("livenessProbe").remove(this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get("livenessProbe").add(this.livenessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    @Override
    public ContainerFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public ContainerFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public ContainerFluent.LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public ContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : new ProbeBuilder().build());
    }

    @Override
    public ContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A addToPorts(int index, ContainerPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<ContainerPortBuilder>();
        }
        ContainerPortBuilder builder = new ContainerPortBuilder(item);
        this._visitables.get("ports").add(index >= 0 ? index : this._visitables.get("ports").size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, ContainerPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<ContainerPortBuilder>();
        }
        ContainerPortBuilder builder = new ContainerPortBuilder(item);
        if (index < 0 || index >= this._visitables.get("ports").size()) {
            this._visitables.get("ports").add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(ContainerPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<ContainerPortBuilder>();
        }
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<ContainerPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<ContainerPortBuilder>();
        }
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(ContainerPort ... items) {
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<ContainerPort> items) {
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerPort> getPorts() {
        return ContainerFluentImpl.build(this.ports);
    }

    @Override
    public List<ContainerPort> buildPorts() {
        return ContainerFluentImpl.build(this.ports);
    }

    @Override
    public ContainerPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public ContainerPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public ContainerPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public ContainerPort buildMatchingPort(Predicate<ContainerPortBuilder> predicate) {
        for (ContainerPortBuilder item : this.ports) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<ContainerPortBuilder> predicate) {
        for (ContainerPortBuilder item : this.ports) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<ContainerPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList<ContainerPortBuilder>();
            for (ContainerPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = new ArrayList<ContainerPortBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withPorts(ContainerPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (ContainerPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public A addNewPort(Integer containerPort, String hostIP, Integer hostPort, String name, String protocol) {
        return this.addToPorts(new ContainerPort(containerPort, hostIP, hostPort, name, protocol));
    }

    @Override
    public ContainerFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public ContainerFluent.PortsNested<A> addNewPortLike(ContainerPort item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public ContainerFluent.PortsNested<A> setNewPortLike(int index, ContainerPort item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public ContainerFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ContainerFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public ContainerFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ContainerFluent.PortsNested<A> editMatchingPort(Predicate<ContainerPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.apply(this.ports.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    @Deprecated
    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.get("readinessProbe").remove(this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get("readinessProbe").add(this.readinessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : new ProbeBuilder().build());
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : item);
    }

    @Override
    @Deprecated
    public ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this._visitables.get("resources").remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public ContainerFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public ContainerFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public ContainerFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public ContainerFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public ContainerFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    @Deprecated
    public SecurityContext getSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    @Override
    public SecurityContext buildSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    @Override
    public A withSecurityContext(SecurityContext securityContext) {
        this._visitables.get("securityContext").remove(this.securityContext);
        if (securityContext != null) {
            this.securityContext = new SecurityContextBuilder(securityContext);
            this._visitables.get("securityContext").add(this.securityContext);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    @Override
    public ContainerFluent.SecurityContextNested<A> withNewSecurityContext() {
        return new SecurityContextNestedImpl();
    }

    @Override
    public ContainerFluent.SecurityContextNested<A> withNewSecurityContextLike(SecurityContext item) {
        return new SecurityContextNestedImpl(item);
    }

    @Override
    public ContainerFluent.SecurityContextNested<A> editSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext());
    }

    @Override
    public ContainerFluent.SecurityContextNested<A> editOrNewSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext() != null ? this.getSecurityContext() : new SecurityContextBuilder().build());
    }

    @Override
    public ContainerFluent.SecurityContextNested<A> editOrNewSecurityContextLike(SecurityContext item) {
        return this.withNewSecurityContextLike(this.getSecurityContext() != null ? this.getSecurityContext() : item);
    }

    @Override
    public Boolean isStdin() {
        return this.stdin;
    }

    @Override
    public A withStdin(Boolean stdin) {
        this.stdin = stdin;
        return (A)this;
    }

    @Override
    public Boolean hasStdin() {
        return this.stdin != null;
    }

    @Override
    public A withNewStdin(String arg1) {
        return this.withStdin(new Boolean(arg1));
    }

    @Override
    public A withNewStdin(boolean arg1) {
        return this.withStdin(new Boolean(arg1));
    }

    @Override
    public Boolean isStdinOnce() {
        return this.stdinOnce;
    }

    @Override
    public A withStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
        return (A)this;
    }

    @Override
    public Boolean hasStdinOnce() {
        return this.stdinOnce != null;
    }

    @Override
    public A withNewStdinOnce(String arg1) {
        return this.withStdinOnce(new Boolean(arg1));
    }

    @Override
    public A withNewStdinOnce(boolean arg1) {
        return this.withStdinOnce(new Boolean(arg1));
    }

    @Override
    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    @Override
    public A withTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
        return (A)this;
    }

    @Override
    public Boolean hasTerminationMessagePath() {
        return this.terminationMessagePath != null;
    }

    @Override
    public A withNewTerminationMessagePath(String arg1) {
        return this.withTerminationMessagePath(new String(arg1));
    }

    @Override
    public A withNewTerminationMessagePath(StringBuilder arg1) {
        return this.withTerminationMessagePath(new String(arg1));
    }

    @Override
    public A withNewTerminationMessagePath(StringBuffer arg1) {
        return this.withTerminationMessagePath(new String(arg1));
    }

    @Override
    public String getTerminationMessagePolicy() {
        return this.terminationMessagePolicy;
    }

    @Override
    public A withTerminationMessagePolicy(String terminationMessagePolicy) {
        this.terminationMessagePolicy = terminationMessagePolicy;
        return (A)this;
    }

    @Override
    public Boolean hasTerminationMessagePolicy() {
        return this.terminationMessagePolicy != null;
    }

    @Override
    public A withNewTerminationMessagePolicy(String arg1) {
        return this.withTerminationMessagePolicy(new String(arg1));
    }

    @Override
    public A withNewTerminationMessagePolicy(StringBuilder arg1) {
        return this.withTerminationMessagePolicy(new String(arg1));
    }

    @Override
    public A withNewTerminationMessagePolicy(StringBuffer arg1) {
        return this.withTerminationMessagePolicy(new String(arg1));
    }

    @Override
    public Boolean isTty() {
        return this.tty;
    }

    @Override
    public A withTty(Boolean tty) {
        this.tty = tty;
        return (A)this;
    }

    @Override
    public Boolean hasTty() {
        return this.tty != null;
    }

    @Override
    public A withNewTty(String arg1) {
        return this.withTty(new Boolean(arg1));
    }

    @Override
    public A withNewTty(boolean arg1) {
        return this.withTty(new Boolean(arg1));
    }

    @Override
    public A addToVolumeDevices(int index, VolumeDevice item) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList<VolumeDeviceBuilder>();
        }
        VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
        this._visitables.get("volumeDevices").add(index >= 0 ? index : this._visitables.get("volumeDevices").size(), builder);
        this.volumeDevices.add(index >= 0 ? index : this.volumeDevices.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumeDevices(int index, VolumeDevice item) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList<VolumeDeviceBuilder>();
        }
        VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
        if (index < 0 || index >= this._visitables.get("volumeDevices").size()) {
            this._visitables.get("volumeDevices").add(builder);
        } else {
            this._visitables.get("volumeDevices").set(index, builder);
        }
        if (index < 0 || index >= this.volumeDevices.size()) {
            this.volumeDevices.add(builder);
        } else {
            this.volumeDevices.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeDevices(VolumeDevice ... items) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList<VolumeDeviceBuilder>();
        }
        for (VolumeDevice item : items) {
            VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
            this._visitables.get("volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeDevices(Collection<VolumeDevice> items) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList<VolumeDeviceBuilder>();
        }
        for (VolumeDevice item : items) {
            VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
            this._visitables.get("volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeDevices(VolumeDevice ... items) {
        for (VolumeDevice item : items) {
            VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
            this._visitables.get("volumeDevices").remove(builder);
            if (this.volumeDevices == null) continue;
            this.volumeDevices.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeDevices(Collection<VolumeDevice> items) {
        for (VolumeDevice item : items) {
            VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
            this._visitables.get("volumeDevices").remove(builder);
            if (this.volumeDevices == null) continue;
            this.volumeDevices.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<VolumeDevice> getVolumeDevices() {
        return ContainerFluentImpl.build(this.volumeDevices);
    }

    @Override
    public List<VolumeDevice> buildVolumeDevices() {
        return ContainerFluentImpl.build(this.volumeDevices);
    }

    @Override
    public VolumeDevice buildVolumeDevice(int index) {
        return this.volumeDevices.get(index).build();
    }

    @Override
    public VolumeDevice buildFirstVolumeDevice() {
        return this.volumeDevices.get(0).build();
    }

    @Override
    public VolumeDevice buildLastVolumeDevice() {
        return this.volumeDevices.get(this.volumeDevices.size() - 1).build();
    }

    @Override
    public VolumeDevice buildMatchingVolumeDevice(Predicate<VolumeDeviceBuilder> predicate) {
        for (VolumeDeviceBuilder item : this.volumeDevices) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeDevice(Predicate<VolumeDeviceBuilder> predicate) {
        for (VolumeDeviceBuilder item : this.volumeDevices) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeDevices(List<VolumeDevice> volumeDevices) {
        if (this.volumeDevices != null) {
            this._visitables.get("volumeDevices").removeAll(this.volumeDevices);
        }
        if (volumeDevices != null) {
            this.volumeDevices = new ArrayList<VolumeDeviceBuilder>();
            for (VolumeDevice item : volumeDevices) {
                this.addToVolumeDevices(item);
            }
        } else {
            this.volumeDevices = new ArrayList<VolumeDeviceBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withVolumeDevices(VolumeDevice ... volumeDevices) {
        if (this.volumeDevices != null) {
            this.volumeDevices.clear();
        }
        if (volumeDevices != null) {
            for (VolumeDevice item : volumeDevices) {
                this.addToVolumeDevices(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeDevices() {
        return this.volumeDevices != null && !this.volumeDevices.isEmpty();
    }

    @Override
    public A addNewVolumeDevice(String devicePath, String name) {
        return this.addToVolumeDevices(new VolumeDevice(devicePath, name));
    }

    @Override
    public ContainerFluent.VolumeDevicesNested<A> addNewVolumeDevice() {
        return new VolumeDevicesNestedImpl();
    }

    @Override
    public ContainerFluent.VolumeDevicesNested<A> addNewVolumeDeviceLike(VolumeDevice item) {
        return new VolumeDevicesNestedImpl(-1, item);
    }

    @Override
    public ContainerFluent.VolumeDevicesNested<A> setNewVolumeDeviceLike(int index, VolumeDevice item) {
        return new VolumeDevicesNestedImpl(index, item);
    }

    @Override
    public ContainerFluent.VolumeDevicesNested<A> editVolumeDevice(int index) {
        if (this.volumeDevices.size() <= index) {
            throw new RuntimeException("Can't edit volumeDevices. Index exceeds size.");
        }
        return this.setNewVolumeDeviceLike(index, this.buildVolumeDevice(index));
    }

    @Override
    public ContainerFluent.VolumeDevicesNested<A> editFirstVolumeDevice() {
        if (this.volumeDevices.size() == 0) {
            throw new RuntimeException("Can't edit first volumeDevices. The list is empty.");
        }
        return this.setNewVolumeDeviceLike(0, this.buildVolumeDevice(0));
    }

    @Override
    public ContainerFluent.VolumeDevicesNested<A> editLastVolumeDevice() {
        int index = this.volumeDevices.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeDevices. The list is empty.");
        }
        return this.setNewVolumeDeviceLike(index, this.buildVolumeDevice(index));
    }

    @Override
    public ContainerFluent.VolumeDevicesNested<A> editMatchingVolumeDevice(Predicate<VolumeDeviceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeDevices.size(); ++i) {
            if (!predicate.apply(this.volumeDevices.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeDevices. No match found.");
        }
        return this.setNewVolumeDeviceLike(index, this.buildVolumeDevice(index));
    }

    @Override
    public A addToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        this._visitables.get("volumeMounts").add(index >= 0 ? index : this._visitables.get("volumeMounts").size(), builder);
        this.volumeMounts.add(index >= 0 ? index : this.volumeMounts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        if (index < 0 || index >= this._visitables.get("volumeMounts").size()) {
            this._visitables.get("volumeMounts").add(builder);
        } else {
            this._visitables.get("volumeMounts").set(index, builder);
        }
        if (index < 0 || index >= this.volumeMounts.size()) {
            this.volumeMounts.add(builder);
        } else {
            this.volumeMounts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeMounts(VolumeMount ... items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").remove(builder);
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").remove(builder);
            if (this.volumeMounts == null) continue;
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<VolumeMount> getVolumeMounts() {
        return ContainerFluentImpl.build(this.volumeMounts);
    }

    @Override
    public List<VolumeMount> buildVolumeMounts() {
        return ContainerFluentImpl.build(this.volumeMounts);
    }

    @Override
    public VolumeMount buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    @Override
    public VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    @Override
    public VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1).build();
    }

    @Override
    public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) {
            this._visitables.get("volumeMounts").removeAll(this.volumeMounts);
        }
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = new ArrayList<VolumeMountBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withVolumeMounts(VolumeMount ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
        }
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    @Override
    public ContainerFluent.VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNestedImpl();
    }

    @Override
    public ContainerFluent.VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item) {
        return new VolumeMountsNestedImpl(-1, item);
    }

    @Override
    public ContainerFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index, VolumeMount item) {
        return new VolumeMountsNestedImpl(index, item);
    }

    @Override
    public ContainerFluent.VolumeMountsNested<A> editVolumeMount(int index) {
        if (this.volumeMounts.size() <= index) {
            throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public ContainerFluent.VolumeMountsNested<A> editFirstVolumeMount() {
        if (this.volumeMounts.size() == 0) {
            throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(0, this.buildVolumeMount(0));
    }

    @Override
    public ContainerFluent.VolumeMountsNested<A> editLastVolumeMount() {
        int index = this.volumeMounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public ContainerFluent.VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeMounts.size(); ++i) {
            if (!predicate.apply(this.volumeMounts.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public A withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (A)this;
    }

    @Override
    public Boolean hasWorkingDir() {
        return this.workingDir != null;
    }

    @Override
    public A withNewWorkingDir(String arg1) {
        return this.withWorkingDir(new String(arg1));
    }

    @Override
    public A withNewWorkingDir(StringBuilder arg1) {
        return this.withWorkingDir(new String(arg1));
    }

    @Override
    public A withNewWorkingDir(StringBuffer arg1) {
        return this.withWorkingDir(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerFluentImpl that = (ContainerFluentImpl)o;
        if (this.args != null ? !this.args.equals(that.args) : that.args != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.envFrom != null ? !this.envFrom.equals(that.envFrom) : that.envFrom != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.imagePullPolicy != null ? !this.imagePullPolicy.equals(that.imagePullPolicy) : that.imagePullPolicy != null) {
            return false;
        }
        if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) {
            return false;
        }
        if (this.stdin != null ? !this.stdin.equals(that.stdin) : that.stdin != null) {
            return false;
        }
        if (this.stdinOnce != null ? !this.stdinOnce.equals(that.stdinOnce) : that.stdinOnce != null) {
            return false;
        }
        if (this.terminationMessagePath != null ? !this.terminationMessagePath.equals(that.terminationMessagePath) : that.terminationMessagePath != null) {
            return false;
        }
        if (this.terminationMessagePolicy != null ? !this.terminationMessagePolicy.equals(that.terminationMessagePolicy) : that.terminationMessagePolicy != null) {
            return false;
        }
        if (this.tty != null ? !this.tty.equals(that.tty) : that.tty != null) {
            return false;
        }
        if (this.volumeDevices != null ? !this.volumeDevices.equals(that.volumeDevices) : that.volumeDevices != null) {
            return false;
        }
        if (this.volumeMounts != null ? !this.volumeMounts.equals(that.volumeMounts) : that.volumeMounts != null) {
            return false;
        }
        return !(this.workingDir != null ? !this.workingDir.equals(that.workingDir) : that.workingDir != null);
    }

    public class VolumeMountsNestedImpl<N>
    extends VolumeMountFluentImpl<ContainerFluent.VolumeMountsNested<N>>
    implements ContainerFluent.VolumeMountsNested<N>,
    Nested<N> {
        private final VolumeMountBuilder builder;
        private final int index;

        VolumeMountsNestedImpl(int index, VolumeMount item) {
            this.index = index;
            this.builder = new VolumeMountBuilder(this, item);
        }

        VolumeMountsNestedImpl() {
            this.index = -1;
            this.builder = new VolumeMountBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.setToVolumeMounts(this.index, this.builder.build());
        }

        @Override
        public N endVolumeMount() {
            return this.and();
        }
    }

    public class VolumeDevicesNestedImpl<N>
    extends VolumeDeviceFluentImpl<ContainerFluent.VolumeDevicesNested<N>>
    implements ContainerFluent.VolumeDevicesNested<N>,
    Nested<N> {
        private final VolumeDeviceBuilder builder;
        private final int index;

        VolumeDevicesNestedImpl(int index, VolumeDevice item) {
            this.index = index;
            this.builder = new VolumeDeviceBuilder(this, item);
        }

        VolumeDevicesNestedImpl() {
            this.index = -1;
            this.builder = new VolumeDeviceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.setToVolumeDevices(this.index, this.builder.build());
        }

        @Override
        public N endVolumeDevice() {
            return this.and();
        }
    }

    public class SecurityContextNestedImpl<N>
    extends SecurityContextFluentImpl<ContainerFluent.SecurityContextNested<N>>
    implements ContainerFluent.SecurityContextNested<N>,
    Nested<N> {
        private final SecurityContextBuilder builder;

        SecurityContextNestedImpl(SecurityContext item) {
            this.builder = new SecurityContextBuilder(this, item);
        }

        SecurityContextNestedImpl() {
            this.builder = new SecurityContextBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withSecurityContext(this.builder.build());
        }

        @Override
        public N endSecurityContext() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<ContainerFluent.ResourcesNested<N>>
    implements ContainerFluent.ResourcesNested<N>,
    Nested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class ReadinessProbeNestedImpl<N>
    extends ProbeFluentImpl<ContainerFluent.ReadinessProbeNested<N>>
    implements ContainerFluent.ReadinessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        ReadinessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        ReadinessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withReadinessProbe(this.builder.build());
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class PortsNestedImpl<N>
    extends ContainerPortFluentImpl<ContainerFluent.PortsNested<N>>
    implements ContainerFluent.PortsNested<N>,
    Nested<N> {
        private final ContainerPortBuilder builder;
        private final int index;

        PortsNestedImpl(int index, ContainerPort item) {
            this.index = index;
            this.builder = new ContainerPortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new ContainerPortBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class LivenessProbeNestedImpl<N>
    extends ProbeFluentImpl<ContainerFluent.LivenessProbeNested<N>>
    implements ContainerFluent.LivenessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        LivenessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        LivenessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withLivenessProbe(this.builder.build());
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class LifecycleNestedImpl<N>
    extends LifecycleFluentImpl<ContainerFluent.LifecycleNested<N>>
    implements ContainerFluent.LifecycleNested<N>,
    Nested<N> {
        private final LifecycleBuilder builder;

        LifecycleNestedImpl(Lifecycle item) {
            this.builder = new LifecycleBuilder(this, item);
        }

        LifecycleNestedImpl() {
            this.builder = new LifecycleBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withLifecycle(this.builder.build());
        }

        @Override
        public N endLifecycle() {
            return this.and();
        }
    }

    public class EnvFromNestedImpl<N>
    extends EnvFromSourceFluentImpl<ContainerFluent.EnvFromNested<N>>
    implements ContainerFluent.EnvFromNested<N>,
    Nested<N> {
        private final EnvFromSourceBuilder builder;
        private final int index;

        EnvFromNestedImpl(int index, EnvFromSource item) {
            this.index = index;
            this.builder = new EnvFromSourceBuilder(this, item);
        }

        EnvFromNestedImpl() {
            this.index = -1;
            this.builder = new EnvFromSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.setToEnvFrom(this.index, this.builder.build());
        }

        @Override
        public N endEnvFrom() {
            return this.and();
        }
    }

    public class EnvNestedImpl<N>
    extends EnvVarFluentImpl<ContainerFluent.EnvNested<N>>
    implements ContainerFluent.EnvNested<N>,
    Nested<N> {
        private final EnvVarBuilder builder;
        private final int index;

        EnvNestedImpl(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder(this, item);
        }

        EnvNestedImpl() {
            this.index = -1;
            this.builder = new EnvVarBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.setToEnv(this.index, this.builder.build());
        }

        @Override
        public N endEnv() {
            return this.and();
        }
    }
}

