/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_5;

import io.fabric8.kubernetes.api.builder.v4_5.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_5.VolumeDevice;
import io.fabric8.kubernetes.api.model.v4_5.VolumeDeviceFluent;
import io.fabric8.kubernetes.api.model.v4_5.VolumeDeviceFluentImpl;

public class VolumeDeviceBuilder
extends VolumeDeviceFluentImpl<VolumeDeviceBuilder>
implements VisitableBuilder<VolumeDevice, VolumeDeviceBuilder> {
    VolumeDeviceFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeDeviceBuilder() {
        this(true);
    }

    public VolumeDeviceBuilder(Boolean validationEnabled) {
        this(new VolumeDevice(), validationEnabled);
    }

    public VolumeDeviceBuilder(VolumeDeviceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public VolumeDeviceBuilder(VolumeDeviceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new VolumeDevice(), validationEnabled);
    }

    public VolumeDeviceBuilder(VolumeDeviceFluent<?> fluent, VolumeDevice instance) {
        this(fluent, instance, true);
    }

    public VolumeDeviceBuilder(VolumeDeviceFluent<?> fluent, VolumeDevice instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDevicePath(instance.getDevicePath());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public VolumeDeviceBuilder(VolumeDevice instance) {
        this(instance, (Boolean)true);
    }

    public VolumeDeviceBuilder(VolumeDevice instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDevicePath(instance.getDevicePath());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public VolumeDevice build() {
        VolumeDevice buildable = new VolumeDevice(this.fluent.getDevicePath(), this.fluent.getName());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeDeviceBuilder that = (VolumeDeviceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

