/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_5;

import io.fabric8.kubernetes.api.builder.v4_5.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_5.Nested;
import io.fabric8.kubernetes.api.builder.v4_5.Predicate;
import io.fabric8.kubernetes.api.model.v4_5.AttachedVolume;
import io.fabric8.kubernetes.api.model.v4_5.AttachedVolumeBuilder;
import io.fabric8.kubernetes.api.model.v4_5.AttachedVolumeFluentImpl;
import io.fabric8.kubernetes.api.model.v4_5.ContainerImage;
import io.fabric8.kubernetes.api.model.v4_5.ContainerImageBuilder;
import io.fabric8.kubernetes.api.model.v4_5.ContainerImageFluentImpl;
import io.fabric8.kubernetes.api.model.v4_5.NodeAddress;
import io.fabric8.kubernetes.api.model.v4_5.NodeAddressBuilder;
import io.fabric8.kubernetes.api.model.v4_5.NodeAddressFluentImpl;
import io.fabric8.kubernetes.api.model.v4_5.NodeCondition;
import io.fabric8.kubernetes.api.model.v4_5.NodeConditionBuilder;
import io.fabric8.kubernetes.api.model.v4_5.NodeConditionFluentImpl;
import io.fabric8.kubernetes.api.model.v4_5.NodeConfigStatus;
import io.fabric8.kubernetes.api.model.v4_5.NodeConfigStatusBuilder;
import io.fabric8.kubernetes.api.model.v4_5.NodeConfigStatusFluentImpl;
import io.fabric8.kubernetes.api.model.v4_5.NodeDaemonEndpoints;
import io.fabric8.kubernetes.api.model.v4_5.NodeDaemonEndpointsBuilder;
import io.fabric8.kubernetes.api.model.v4_5.NodeDaemonEndpointsFluentImpl;
import io.fabric8.kubernetes.api.model.v4_5.NodeStatus;
import io.fabric8.kubernetes.api.model.v4_5.NodeStatusFluent;
import io.fabric8.kubernetes.api.model.v4_5.NodeSystemInfo;
import io.fabric8.kubernetes.api.model.v4_5.NodeSystemInfoBuilder;
import io.fabric8.kubernetes.api.model.v4_5.NodeSystemInfoFluentImpl;
import io.fabric8.kubernetes.api.model.v4_5.Quantity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NodeStatusFluentImpl<A extends NodeStatusFluent<A>>
extends BaseFluent<A>
implements NodeStatusFluent<A> {
    private List<NodeAddressBuilder> addresses;
    private Map<String, Quantity> allocatable;
    private Map<String, Quantity> capacity;
    private List<NodeConditionBuilder> conditions;
    private NodeConfigStatusBuilder config;
    private NodeDaemonEndpointsBuilder daemonEndpoints;
    private List<ContainerImageBuilder> images;
    private NodeSystemInfoBuilder nodeInfo;
    private String phase;
    private List<AttachedVolumeBuilder> volumesAttached;
    private List<String> volumesInUse;

    public NodeStatusFluentImpl() {
    }

    public NodeStatusFluentImpl(NodeStatus instance) {
        this.withAddresses(instance.getAddresses());
        this.withAllocatable(instance.getAllocatable());
        this.withCapacity(instance.getCapacity());
        this.withConditions(instance.getConditions());
        this.withConfig(instance.getConfig());
        this.withDaemonEndpoints(instance.getDaemonEndpoints());
        this.withImages(instance.getImages());
        this.withNodeInfo(instance.getNodeInfo());
        this.withPhase(instance.getPhase());
        this.withVolumesAttached(instance.getVolumesAttached());
        this.withVolumesInUse(instance.getVolumesInUse());
    }

    @Override
    public A addToAddresses(int index, NodeAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddressBuilder>();
        }
        NodeAddressBuilder builder = new NodeAddressBuilder(item);
        this._visitables.get("addresses").add(index >= 0 ? index : this._visitables.get("addresses").size(), builder);
        this.addresses.add(index >= 0 ? index : this.addresses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAddresses(int index, NodeAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddressBuilder>();
        }
        NodeAddressBuilder builder = new NodeAddressBuilder(item);
        if (index < 0 || index >= this._visitables.get("addresses").size()) {
            this._visitables.get("addresses").add(builder);
        } else {
            this._visitables.get("addresses").set(index, builder);
        }
        if (index < 0 || index >= this.addresses.size()) {
            this.addresses.add(builder);
        } else {
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAddresses(NodeAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddressBuilder>();
        }
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<NodeAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<NodeAddressBuilder>();
        }
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(NodeAddress ... items) {
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<NodeAddress> items) {
        for (NodeAddress item : items) {
            NodeAddressBuilder builder = new NodeAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NodeAddress> getAddresses() {
        return NodeStatusFluentImpl.build(this.addresses);
    }

    @Override
    public List<NodeAddress> buildAddresses() {
        return NodeStatusFluentImpl.build(this.addresses);
    }

    @Override
    public NodeAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    @Override
    public NodeAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    @Override
    public NodeAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    @Override
    public NodeAddress buildMatchingAddress(Predicate<NodeAddressBuilder> predicate) {
        for (NodeAddressBuilder item : this.addresses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<NodeAddressBuilder> predicate) {
        for (NodeAddressBuilder item : this.addresses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddresses(List<NodeAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get("addresses").removeAll(this.addresses);
        }
        if (addresses != null) {
            this.addresses = new ArrayList<NodeAddressBuilder>();
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = new ArrayList<NodeAddressBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withAddresses(NodeAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
        }
        if (addresses != null) {
            for (NodeAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public A addNewAddress(String address, String type) {
        return this.addToAddresses(new NodeAddress(address, type));
    }

    @Override
    public NodeStatusFluent.AddressesNested<A> addNewAddress() {
        return new AddressesNestedImpl();
    }

    @Override
    public NodeStatusFluent.AddressesNested<A> addNewAddressLike(NodeAddress item) {
        return new AddressesNestedImpl(-1, item);
    }

    @Override
    public NodeStatusFluent.AddressesNested<A> setNewAddressLike(int index, NodeAddress item) {
        return new AddressesNestedImpl(index, item);
    }

    @Override
    public NodeStatusFluent.AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public NodeStatusFluent.AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    @Override
    public NodeStatusFluent.AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public NodeStatusFluent.AddressesNested<A> editMatchingAddress(Predicate<NodeAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.apply(this.addresses.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public A addToAllocatable(String key, Quantity value) {
        if (this.allocatable == null && key != null && value != null) {
            this.allocatable = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.allocatable.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAllocatable(Map<String, Quantity> map) {
        if (this.allocatable == null && map != null) {
            this.allocatable = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.allocatable.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllocatable(String key) {
        if (this.allocatable == null) {
            return (A)this;
        }
        if (key != null && this.allocatable != null) {
            this.allocatable.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllocatable(Map<String, Quantity> map) {
        if (this.allocatable == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.allocatable == null) continue;
                this.allocatable.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getAllocatable() {
        return this.allocatable;
    }

    @Override
    public A withAllocatable(Map<String, Quantity> allocatable) {
        this.allocatable = allocatable == null ? new LinkedHashMap<String, Quantity>() : new LinkedHashMap<String, Quantity>(allocatable);
        return (A)this;
    }

    @Override
    public Boolean hasAllocatable() {
        return this.allocatable != null;
    }

    @Override
    public A addToCapacity(String key, Quantity value) {
        if (this.capacity == null && key != null && value != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToCapacity(Map<String, Quantity> map) {
        if (this.capacity == null && map != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(String key) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (key != null && this.capacity != null) {
            this.capacity.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(Map<String, Quantity> map) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capacity == null) continue;
                this.capacity.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    @Override
    public A withCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity == null ? new LinkedHashMap<String, Quantity>() : new LinkedHashMap<String, Quantity>(capacity);
        return (A)this;
    }

    @Override
    public Boolean hasCapacity() {
        return this.capacity != null;
    }

    @Override
    public A addToConditions(int index, NodeCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<NodeConditionBuilder>();
        }
        NodeConditionBuilder builder = new NodeConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, NodeCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<NodeConditionBuilder>();
        }
        NodeConditionBuilder builder = new NodeConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(NodeCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<NodeConditionBuilder>();
        }
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<NodeCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<NodeConditionBuilder>();
        }
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(NodeCondition ... items) {
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<NodeCondition> items) {
        for (NodeCondition item : items) {
            NodeConditionBuilder builder = new NodeConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NodeCondition> getConditions() {
        return NodeStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<NodeCondition> buildConditions() {
        return NodeStatusFluentImpl.build(this.conditions);
    }

    @Override
    public NodeCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public NodeCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public NodeCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public NodeCondition buildMatchingCondition(Predicate<NodeConditionBuilder> predicate) {
        for (NodeConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<NodeConditionBuilder> predicate) {
        for (NodeConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<NodeCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<NodeConditionBuilder>();
            for (NodeCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = new ArrayList<NodeConditionBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withConditions(NodeCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (NodeCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public NodeStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public NodeStatusFluent.ConditionsNested<A> addNewConditionLike(NodeCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public NodeStatusFluent.ConditionsNested<A> setNewConditionLike(int index, NodeCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public NodeStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public NodeStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public NodeStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public NodeStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<NodeConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    @Deprecated
    public NodeConfigStatus getConfig() {
        return this.config != null ? this.config.build() : null;
    }

    @Override
    public NodeConfigStatus buildConfig() {
        return this.config != null ? this.config.build() : null;
    }

    @Override
    public A withConfig(NodeConfigStatus config) {
        this._visitables.get("config").remove(this.config);
        if (config != null) {
            this.config = new NodeConfigStatusBuilder(config);
            this._visitables.get("config").add(this.config);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    @Override
    public NodeStatusFluent.ConfigNested<A> withNewConfig() {
        return new ConfigNestedImpl();
    }

    @Override
    public NodeStatusFluent.ConfigNested<A> withNewConfigLike(NodeConfigStatus item) {
        return new ConfigNestedImpl(item);
    }

    @Override
    public NodeStatusFluent.ConfigNested<A> editConfig() {
        return this.withNewConfigLike(this.getConfig());
    }

    @Override
    public NodeStatusFluent.ConfigNested<A> editOrNewConfig() {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : new NodeConfigStatusBuilder().build());
    }

    @Override
    public NodeStatusFluent.ConfigNested<A> editOrNewConfigLike(NodeConfigStatus item) {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : item);
    }

    @Override
    @Deprecated
    public NodeDaemonEndpoints getDaemonEndpoints() {
        return this.daemonEndpoints != null ? this.daemonEndpoints.build() : null;
    }

    @Override
    public NodeDaemonEndpoints buildDaemonEndpoints() {
        return this.daemonEndpoints != null ? this.daemonEndpoints.build() : null;
    }

    @Override
    public A withDaemonEndpoints(NodeDaemonEndpoints daemonEndpoints) {
        this._visitables.get("daemonEndpoints").remove(this.daemonEndpoints);
        if (daemonEndpoints != null) {
            this.daemonEndpoints = new NodeDaemonEndpointsBuilder(daemonEndpoints);
            this._visitables.get("daemonEndpoints").add(this.daemonEndpoints);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDaemonEndpoints() {
        return this.daemonEndpoints != null;
    }

    @Override
    public NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpoints() {
        return new DaemonEndpointsNestedImpl();
    }

    @Override
    public NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpointsLike(NodeDaemonEndpoints item) {
        return new DaemonEndpointsNestedImpl(item);
    }

    @Override
    public NodeStatusFluent.DaemonEndpointsNested<A> editDaemonEndpoints() {
        return this.withNewDaemonEndpointsLike(this.getDaemonEndpoints());
    }

    @Override
    public NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpoints() {
        return this.withNewDaemonEndpointsLike(this.getDaemonEndpoints() != null ? this.getDaemonEndpoints() : new NodeDaemonEndpointsBuilder().build());
    }

    @Override
    public NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpointsLike(NodeDaemonEndpoints item) {
        return this.withNewDaemonEndpointsLike(this.getDaemonEndpoints() != null ? this.getDaemonEndpoints() : item);
    }

    @Override
    public A addToImages(int index, ContainerImage item) {
        if (this.images == null) {
            this.images = new ArrayList<ContainerImageBuilder>();
        }
        ContainerImageBuilder builder = new ContainerImageBuilder(item);
        this._visitables.get("images").add(index >= 0 ? index : this._visitables.get("images").size(), builder);
        this.images.add(index >= 0 ? index : this.images.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImages(int index, ContainerImage item) {
        if (this.images == null) {
            this.images = new ArrayList<ContainerImageBuilder>();
        }
        ContainerImageBuilder builder = new ContainerImageBuilder(item);
        if (index < 0 || index >= this._visitables.get("images").size()) {
            this._visitables.get("images").add(builder);
        } else {
            this._visitables.get("images").set(index, builder);
        }
        if (index < 0 || index >= this.images.size()) {
            this.images.add(builder);
        } else {
            this.images.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImages(ContainerImage ... items) {
        if (this.images == null) {
            this.images = new ArrayList<ContainerImageBuilder>();
        }
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImages(Collection<ContainerImage> items) {
        if (this.images == null) {
            this.images = new ArrayList<ContainerImageBuilder>();
        }
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImages(ContainerImage ... items) {
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.get("images").remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImages(Collection<ContainerImage> items) {
        for (ContainerImage item : items) {
            ContainerImageBuilder builder = new ContainerImageBuilder(item);
            this._visitables.get("images").remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerImage> getImages() {
        return NodeStatusFluentImpl.build(this.images);
    }

    @Override
    public List<ContainerImage> buildImages() {
        return NodeStatusFluentImpl.build(this.images);
    }

    @Override
    public ContainerImage buildImage(int index) {
        return this.images.get(index).build();
    }

    @Override
    public ContainerImage buildFirstImage() {
        return this.images.get(0).build();
    }

    @Override
    public ContainerImage buildLastImage() {
        return this.images.get(this.images.size() - 1).build();
    }

    @Override
    public ContainerImage buildMatchingImage(Predicate<ContainerImageBuilder> predicate) {
        for (ContainerImageBuilder item : this.images) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImage(Predicate<ContainerImageBuilder> predicate) {
        for (ContainerImageBuilder item : this.images) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImages(List<ContainerImage> images) {
        if (this.images != null) {
            this._visitables.get("images").removeAll(this.images);
        }
        if (images != null) {
            this.images = new ArrayList<ContainerImageBuilder>();
            for (ContainerImage item : images) {
                this.addToImages(item);
            }
        } else {
            this.images = new ArrayList<ContainerImageBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withImages(ContainerImage ... images) {
        if (this.images != null) {
            this.images.clear();
        }
        if (images != null) {
            for (ContainerImage item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    @Override
    public NodeStatusFluent.ImagesNested<A> addNewImage() {
        return new ImagesNestedImpl();
    }

    @Override
    public NodeStatusFluent.ImagesNested<A> addNewImageLike(ContainerImage item) {
        return new ImagesNestedImpl(-1, item);
    }

    @Override
    public NodeStatusFluent.ImagesNested<A> setNewImageLike(int index, ContainerImage item) {
        return new ImagesNestedImpl(index, item);
    }

    @Override
    public NodeStatusFluent.ImagesNested<A> editImage(int index) {
        if (this.images.size() <= index) {
            throw new RuntimeException("Can't edit images. Index exceeds size.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public NodeStatusFluent.ImagesNested<A> editFirstImage() {
        if (this.images.size() == 0) {
            throw new RuntimeException("Can't edit first images. The list is empty.");
        }
        return this.setNewImageLike(0, this.buildImage(0));
    }

    @Override
    public NodeStatusFluent.ImagesNested<A> editLastImage() {
        int index = this.images.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last images. The list is empty.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public NodeStatusFluent.ImagesNested<A> editMatchingImage(Predicate<ContainerImageBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.images.size(); ++i) {
            if (!predicate.apply(this.images.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching images. No match found.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    @Deprecated
    public NodeSystemInfo getNodeInfo() {
        return this.nodeInfo != null ? this.nodeInfo.build() : null;
    }

    @Override
    public NodeSystemInfo buildNodeInfo() {
        return this.nodeInfo != null ? this.nodeInfo.build() : null;
    }

    @Override
    public A withNodeInfo(NodeSystemInfo nodeInfo) {
        this._visitables.get("nodeInfo").remove(this.nodeInfo);
        if (nodeInfo != null) {
            this.nodeInfo = new NodeSystemInfoBuilder(nodeInfo);
            this._visitables.get("nodeInfo").add(this.nodeInfo);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNodeInfo() {
        return this.nodeInfo != null;
    }

    @Override
    public NodeStatusFluent.NodeInfoNested<A> withNewNodeInfo() {
        return new NodeInfoNestedImpl();
    }

    @Override
    public NodeStatusFluent.NodeInfoNested<A> withNewNodeInfoLike(NodeSystemInfo item) {
        return new NodeInfoNestedImpl(item);
    }

    @Override
    public NodeStatusFluent.NodeInfoNested<A> editNodeInfo() {
        return this.withNewNodeInfoLike(this.getNodeInfo());
    }

    @Override
    public NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfo() {
        return this.withNewNodeInfoLike(this.getNodeInfo() != null ? this.getNodeInfo() : new NodeSystemInfoBuilder().build());
    }

    @Override
    public NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfoLike(NodeSystemInfo item) {
        return this.withNewNodeInfoLike(this.getNodeInfo() != null ? this.getNodeInfo() : item);
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    @Override
    public A withNewPhase(String arg1) {
        return this.withPhase(new String(arg1));
    }

    @Override
    public A withNewPhase(StringBuilder arg1) {
        return this.withPhase(new String(arg1));
    }

    @Override
    public A withNewPhase(StringBuffer arg1) {
        return this.withPhase(new String(arg1));
    }

    @Override
    public A addToVolumesAttached(int index, AttachedVolume item) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList<AttachedVolumeBuilder>();
        }
        AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
        this._visitables.get("volumesAttached").add(index >= 0 ? index : this._visitables.get("volumesAttached").size(), builder);
        this.volumesAttached.add(index >= 0 ? index : this.volumesAttached.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumesAttached(int index, AttachedVolume item) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList<AttachedVolumeBuilder>();
        }
        AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get("volumesAttached").size()) {
            this._visitables.get("volumesAttached").add(builder);
        } else {
            this._visitables.get("volumesAttached").set(index, builder);
        }
        if (index < 0 || index >= this.volumesAttached.size()) {
            this.volumesAttached.add(builder);
        } else {
            this.volumesAttached.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumesAttached(AttachedVolume ... items) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList<AttachedVolumeBuilder>();
        }
        for (AttachedVolume item : items) {
            AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
            this._visitables.get("volumesAttached").add(builder);
            this.volumesAttached.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumesAttached(Collection<AttachedVolume> items) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList<AttachedVolumeBuilder>();
        }
        for (AttachedVolume item : items) {
            AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
            this._visitables.get("volumesAttached").add(builder);
            this.volumesAttached.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumesAttached(AttachedVolume ... items) {
        for (AttachedVolume item : items) {
            AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
            this._visitables.get("volumesAttached").remove(builder);
            if (this.volumesAttached == null) continue;
            this.volumesAttached.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumesAttached(Collection<AttachedVolume> items) {
        for (AttachedVolume item : items) {
            AttachedVolumeBuilder builder = new AttachedVolumeBuilder(item);
            this._visitables.get("volumesAttached").remove(builder);
            if (this.volumesAttached == null) continue;
            this.volumesAttached.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AttachedVolume> getVolumesAttached() {
        return NodeStatusFluentImpl.build(this.volumesAttached);
    }

    @Override
    public List<AttachedVolume> buildVolumesAttached() {
        return NodeStatusFluentImpl.build(this.volumesAttached);
    }

    @Override
    public AttachedVolume buildVolumesAttached(int index) {
        return this.volumesAttached.get(index).build();
    }

    @Override
    public AttachedVolume buildFirstVolumesAttached() {
        return this.volumesAttached.get(0).build();
    }

    @Override
    public AttachedVolume buildLastVolumesAttached() {
        return this.volumesAttached.get(this.volumesAttached.size() - 1).build();
    }

    @Override
    public AttachedVolume buildMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate) {
        for (AttachedVolumeBuilder item : this.volumesAttached) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate) {
        for (AttachedVolumeBuilder item : this.volumesAttached) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumesAttached(List<AttachedVolume> volumesAttached) {
        if (this.volumesAttached != null) {
            this._visitables.get("volumesAttached").removeAll(this.volumesAttached);
        }
        if (volumesAttached != null) {
            this.volumesAttached = new ArrayList<AttachedVolumeBuilder>();
            for (AttachedVolume item : volumesAttached) {
                this.addToVolumesAttached(item);
            }
        } else {
            this.volumesAttached = new ArrayList<AttachedVolumeBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withVolumesAttached(AttachedVolume ... volumesAttached) {
        if (this.volumesAttached != null) {
            this.volumesAttached.clear();
        }
        if (volumesAttached != null) {
            for (AttachedVolume item : volumesAttached) {
                this.addToVolumesAttached(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumesAttached() {
        return this.volumesAttached != null && !this.volumesAttached.isEmpty();
    }

    @Override
    public A addNewVolumesAttached(String devicePath, String name) {
        return this.addToVolumesAttached(new AttachedVolume(devicePath, name));
    }

    @Override
    public NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttached() {
        return new VolumesAttachedNestedImpl();
    }

    @Override
    public NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttachedLike(AttachedVolume item) {
        return new VolumesAttachedNestedImpl(-1, item);
    }

    @Override
    public NodeStatusFluent.VolumesAttachedNested<A> setNewVolumesAttachedLike(int index, AttachedVolume item) {
        return new VolumesAttachedNestedImpl(index, item);
    }

    @Override
    public NodeStatusFluent.VolumesAttachedNested<A> editVolumesAttached(int index) {
        if (this.volumesAttached.size() <= index) {
            throw new RuntimeException("Can't edit volumesAttached. Index exceeds size.");
        }
        return this.setNewVolumesAttachedLike(index, this.buildVolumesAttached(index));
    }

    @Override
    public NodeStatusFluent.VolumesAttachedNested<A> editFirstVolumesAttached() {
        if (this.volumesAttached.size() == 0) {
            throw new RuntimeException("Can't edit first volumesAttached. The list is empty.");
        }
        return this.setNewVolumesAttachedLike(0, this.buildVolumesAttached(0));
    }

    @Override
    public NodeStatusFluent.VolumesAttachedNested<A> editLastVolumesAttached() {
        int index = this.volumesAttached.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumesAttached. The list is empty.");
        }
        return this.setNewVolumesAttachedLike(index, this.buildVolumesAttached(index));
    }

    @Override
    public NodeStatusFluent.VolumesAttachedNested<A> editMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumesAttached.size(); ++i) {
            if (!predicate.apply(this.volumesAttached.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumesAttached. No match found.");
        }
        return this.setNewVolumesAttachedLike(index, this.buildVolumesAttached(index));
    }

    @Override
    public A addToVolumesInUse(int index, String item) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        this.volumesInUse.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumesInUse(int index, String item) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        this.volumesInUse.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumesInUse(String ... items) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumesInUse.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumesInUse(Collection<String> items) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumesInUse.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumesInUse(String ... items) {
        for (String item : items) {
            if (this.volumesInUse == null) continue;
            this.volumesInUse.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumesInUse(Collection<String> items) {
        for (String item : items) {
            if (this.volumesInUse == null) continue;
            this.volumesInUse.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVolumesInUse() {
        return this.volumesInUse;
    }

    @Override
    public String getVolumesInUse(int index) {
        return this.volumesInUse.get(index);
    }

    @Override
    public String getFirstVolumesInUse() {
        return this.volumesInUse.get(0);
    }

    @Override
    public String getLastVolumesInUse() {
        return this.volumesInUse.get(this.volumesInUse.size() - 1);
    }

    @Override
    public String getMatchingVolumesInUse(Predicate<String> predicate) {
        for (String item : this.volumesInUse) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumesInUse(Predicate<String> predicate) {
        for (String item : this.volumesInUse) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumesInUse(List<String> volumesInUse) {
        if (this.volumesInUse != null) {
            this._visitables.get("volumesInUse").removeAll(this.volumesInUse);
        }
        if (volumesInUse != null) {
            this.volumesInUse = new ArrayList<String>();
            for (String item : volumesInUse) {
                this.addToVolumesInUse(item);
            }
        } else {
            this.volumesInUse = new ArrayList<String>();
        }
        return (A)this;
    }

    @Override
    public A withVolumesInUse(String ... volumesInUse) {
        if (this.volumesInUse != null) {
            this.volumesInUse.clear();
        }
        if (volumesInUse != null) {
            for (String item : volumesInUse) {
                this.addToVolumesInUse(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumesInUse() {
        return this.volumesInUse != null && !this.volumesInUse.isEmpty();
    }

    @Override
    public A addNewVolumesInUse(String arg1) {
        return this.addToVolumesInUse(new String(arg1));
    }

    @Override
    public A addNewVolumesInUse(StringBuilder arg1) {
        return this.addToVolumesInUse(new String(arg1));
    }

    @Override
    public A addNewVolumesInUse(StringBuffer arg1) {
        return this.addToVolumesInUse(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeStatusFluentImpl that = (NodeStatusFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.allocatable != null ? !this.allocatable.equals(that.allocatable) : that.allocatable != null) {
            return false;
        }
        if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.daemonEndpoints != null ? !this.daemonEndpoints.equals(that.daemonEndpoints) : that.daemonEndpoints != null) {
            return false;
        }
        if (this.images != null ? !this.images.equals(that.images) : that.images != null) {
            return false;
        }
        if (this.nodeInfo != null ? !this.nodeInfo.equals(that.nodeInfo) : that.nodeInfo != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.volumesAttached != null ? !this.volumesAttached.equals(that.volumesAttached) : that.volumesAttached != null) {
            return false;
        }
        return !(this.volumesInUse != null ? !this.volumesInUse.equals(that.volumesInUse) : that.volumesInUse != null);
    }

    public class VolumesAttachedNestedImpl<N>
    extends AttachedVolumeFluentImpl<NodeStatusFluent.VolumesAttachedNested<N>>
    implements NodeStatusFluent.VolumesAttachedNested<N>,
    Nested<N> {
        private final AttachedVolumeBuilder builder;
        private final int index;

        VolumesAttachedNestedImpl(int index, AttachedVolume item) {
            this.index = index;
            this.builder = new AttachedVolumeBuilder(this, item);
        }

        VolumesAttachedNestedImpl() {
            this.index = -1;
            this.builder = new AttachedVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.setToVolumesAttached(this.index, this.builder.build());
        }

        @Override
        public N endVolumesAttached() {
            return this.and();
        }
    }

    public class NodeInfoNestedImpl<N>
    extends NodeSystemInfoFluentImpl<NodeStatusFluent.NodeInfoNested<N>>
    implements NodeStatusFluent.NodeInfoNested<N>,
    Nested<N> {
        private final NodeSystemInfoBuilder builder;

        NodeInfoNestedImpl(NodeSystemInfo item) {
            this.builder = new NodeSystemInfoBuilder(this, item);
        }

        NodeInfoNestedImpl() {
            this.builder = new NodeSystemInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.withNodeInfo(this.builder.build());
        }

        @Override
        public N endNodeInfo() {
            return this.and();
        }
    }

    public class ImagesNestedImpl<N>
    extends ContainerImageFluentImpl<NodeStatusFluent.ImagesNested<N>>
    implements NodeStatusFluent.ImagesNested<N>,
    Nested<N> {
        private final ContainerImageBuilder builder;
        private final int index;

        ImagesNestedImpl(int index, ContainerImage item) {
            this.index = index;
            this.builder = new ContainerImageBuilder(this, item);
        }

        ImagesNestedImpl() {
            this.index = -1;
            this.builder = new ContainerImageBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.setToImages(this.index, this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }

    public class DaemonEndpointsNestedImpl<N>
    extends NodeDaemonEndpointsFluentImpl<NodeStatusFluent.DaemonEndpointsNested<N>>
    implements NodeStatusFluent.DaemonEndpointsNested<N>,
    Nested<N> {
        private final NodeDaemonEndpointsBuilder builder;

        DaemonEndpointsNestedImpl(NodeDaemonEndpoints item) {
            this.builder = new NodeDaemonEndpointsBuilder(this, item);
        }

        DaemonEndpointsNestedImpl() {
            this.builder = new NodeDaemonEndpointsBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.withDaemonEndpoints(this.builder.build());
        }

        @Override
        public N endDaemonEndpoints() {
            return this.and();
        }
    }

    public class ConfigNestedImpl<N>
    extends NodeConfigStatusFluentImpl<NodeStatusFluent.ConfigNested<N>>
    implements NodeStatusFluent.ConfigNested<N>,
    Nested<N> {
        private final NodeConfigStatusBuilder builder;

        ConfigNestedImpl(NodeConfigStatus item) {
            this.builder = new NodeConfigStatusBuilder(this, item);
        }

        ConfigNestedImpl() {
            this.builder = new NodeConfigStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.withConfig(this.builder.build());
        }

        @Override
        public N endConfig() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends NodeConditionFluentImpl<NodeStatusFluent.ConditionsNested<N>>
    implements NodeStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final NodeConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, NodeCondition item) {
            this.index = index;
            this.builder = new NodeConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new NodeConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    public class AddressesNestedImpl<N>
    extends NodeAddressFluentImpl<NodeStatusFluent.AddressesNested<N>>
    implements NodeStatusFluent.AddressesNested<N>,
    Nested<N> {
        private final NodeAddressBuilder builder;
        private final int index;

        AddressesNestedImpl(int index, NodeAddress item) {
            this.index = index;
            this.builder = new NodeAddressBuilder(this, item);
        }

        AddressesNestedImpl() {
            this.index = -1;
            this.builder = new NodeAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeStatusFluentImpl.this.setToAddresses(this.index, this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

