/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_5;

import io.fabric8.kubernetes.api.builder.v4_5.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_5.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_5.SecretBuildSource;
import io.fabric8.openshift.api.model.v4_5.SecretBuildSourceFluent;
import io.fabric8.openshift.api.model.v4_5.SecretBuildSourceFluentImpl;
import javax.validation.Validator;

public class SecretBuildSourceBuilder
extends SecretBuildSourceFluentImpl<SecretBuildSourceBuilder>
implements VisitableBuilder<SecretBuildSource, SecretBuildSourceBuilder> {
    SecretBuildSourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SecretBuildSourceBuilder() {
        this(true);
    }

    public SecretBuildSourceBuilder(Boolean validationEnabled) {
        this(new SecretBuildSource(), validationEnabled);
    }

    public SecretBuildSourceBuilder(SecretBuildSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SecretBuildSourceBuilder(SecretBuildSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SecretBuildSource(), validationEnabled);
    }

    public SecretBuildSourceBuilder(SecretBuildSourceFluent<?> fluent, SecretBuildSource instance) {
        this(fluent, instance, true);
    }

    public SecretBuildSourceBuilder(SecretBuildSourceFluent<?> fluent, SecretBuildSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDestinationDir(instance.getDestinationDir());
        fluent.withSecret(instance.getSecret());
        this.validationEnabled = validationEnabled;
    }

    public SecretBuildSourceBuilder(SecretBuildSource instance) {
        this(instance, (Boolean)true);
    }

    public SecretBuildSourceBuilder(SecretBuildSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDestinationDir(instance.getDestinationDir());
        this.withSecret(instance.getSecret());
        this.validationEnabled = validationEnabled;
    }

    public SecretBuildSourceBuilder(Validator validator) {
        this(new SecretBuildSource(), (Boolean)true);
    }

    public SecretBuildSourceBuilder(SecretBuildSourceFluent<?> fluent, SecretBuildSource instance, Validator validator) {
        this.fluent = fluent;
        fluent.withDestinationDir(instance.getDestinationDir());
        fluent.withSecret(instance.getSecret());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public SecretBuildSourceBuilder(SecretBuildSource instance, Validator validator) {
        this.fluent = this;
        this.withDestinationDir(instance.getDestinationDir());
        this.withSecret(instance.getSecret());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public SecretBuildSource build() {
        SecretBuildSource buildable = new SecretBuildSource(this.fluent.getDestinationDir(), this.fluent.getSecret());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretBuildSourceBuilder that = (SecretBuildSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

