/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_5;

import io.fabric8.kubernetes.api.builder.v4_5.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_5.Nested;
import io.fabric8.kubernetes.api.builder.v4_5.Predicate;
import io.fabric8.kubernetes.api.model.v4_5.ObjectMeta;
import io.fabric8.kubernetes.api.model.v4_5.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v4_5.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v4_5.OAuthAccessToken;
import io.fabric8.openshift.api.model.v4_5.OAuthAccessTokenFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OAuthAccessTokenFluentImpl<A extends OAuthAccessTokenFluent<A>>
extends BaseFluent<A>
implements OAuthAccessTokenFluent<A> {
    private String apiVersion;
    private String authorizeToken;
    private String clientName;
    private Long expiresIn;
    private Integer inactivityTimeoutSeconds;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String redirectURI;
    private String refreshToken;
    private List<String> scopes;
    private String userName;
    private String userUID;

    public OAuthAccessTokenFluentImpl() {
    }

    public OAuthAccessTokenFluentImpl(OAuthAccessToken instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withAuthorizeToken(instance.getAuthorizeToken());
        this.withClientName(instance.getClientName());
        this.withExpiresIn(instance.getExpiresIn());
        this.withInactivityTimeoutSeconds(instance.getInactivityTimeoutSeconds());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRedirectURI(instance.getRedirectURI());
        this.withRefreshToken(instance.getRefreshToken());
        this.withScopes(instance.getScopes());
        this.withUserName(instance.getUserName());
        this.withUserUID(instance.getUserUID());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getAuthorizeToken() {
        return this.authorizeToken;
    }

    @Override
    public A withAuthorizeToken(String authorizeToken) {
        this.authorizeToken = authorizeToken;
        return (A)this;
    }

    @Override
    public Boolean hasAuthorizeToken() {
        return this.authorizeToken != null;
    }

    @Override
    public A withNewAuthorizeToken(String arg1) {
        return this.withAuthorizeToken(new String(arg1));
    }

    @Override
    public A withNewAuthorizeToken(StringBuilder arg1) {
        return this.withAuthorizeToken(new String(arg1));
    }

    @Override
    public A withNewAuthorizeToken(StringBuffer arg1) {
        return this.withAuthorizeToken(new String(arg1));
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public A withClientName(String clientName) {
        this.clientName = clientName;
        return (A)this;
    }

    @Override
    public Boolean hasClientName() {
        return this.clientName != null;
    }

    @Override
    public A withNewClientName(String arg1) {
        return this.withClientName(new String(arg1));
    }

    @Override
    public A withNewClientName(StringBuilder arg1) {
        return this.withClientName(new String(arg1));
    }

    @Override
    public A withNewClientName(StringBuffer arg1) {
        return this.withClientName(new String(arg1));
    }

    @Override
    public Long getExpiresIn() {
        return this.expiresIn;
    }

    @Override
    public A withExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
        return (A)this;
    }

    @Override
    public Boolean hasExpiresIn() {
        return this.expiresIn != null;
    }

    @Override
    public Integer getInactivityTimeoutSeconds() {
        return this.inactivityTimeoutSeconds;
    }

    @Override
    public A withInactivityTimeoutSeconds(Integer inactivityTimeoutSeconds) {
        this.inactivityTimeoutSeconds = inactivityTimeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasInactivityTimeoutSeconds() {
        return this.inactivityTimeoutSeconds != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public OAuthAccessTokenFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public OAuthAccessTokenFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public OAuthAccessTokenFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public OAuthAccessTokenFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public OAuthAccessTokenFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public String getRedirectURI() {
        return this.redirectURI;
    }

    @Override
    public A withRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
        return (A)this;
    }

    @Override
    public Boolean hasRedirectURI() {
        return this.redirectURI != null;
    }

    @Override
    public A withNewRedirectURI(String arg1) {
        return this.withRedirectURI(new String(arg1));
    }

    @Override
    public A withNewRedirectURI(StringBuilder arg1) {
        return this.withRedirectURI(new String(arg1));
    }

    @Override
    public A withNewRedirectURI(StringBuffer arg1) {
        return this.withRedirectURI(new String(arg1));
    }

    @Override
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public A withRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return (A)this;
    }

    @Override
    public Boolean hasRefreshToken() {
        return this.refreshToken != null;
    }

    @Override
    public A withNewRefreshToken(String arg1) {
        return this.withRefreshToken(new String(arg1));
    }

    @Override
    public A withNewRefreshToken(StringBuilder arg1) {
        return this.withRefreshToken(new String(arg1));
    }

    @Override
    public A withNewRefreshToken(StringBuffer arg1) {
        return this.withRefreshToken(new String(arg1));
    }

    @Override
    public A addToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToScopes(String ... items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToScopes(Collection<String> items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromScopes(String ... items) {
        for (String item : items) {
            if (this.scopes == null) continue;
            this.scopes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromScopes(Collection<String> items) {
        for (String item : items) {
            if (this.scopes == null) continue;
            this.scopes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    public String getScope(int index) {
        return this.scopes.get(index);
    }

    @Override
    public String getFirstScope() {
        return this.scopes.get(0);
    }

    @Override
    public String getLastScope() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    @Override
    public String getMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withScopes(List<String> scopes) {
        if (this.scopes != null) {
            this._visitables.get("scopes").removeAll(this.scopes);
        }
        if (scopes != null) {
            this.scopes = new ArrayList<String>();
            for (String item : scopes) {
                this.addToScopes(item);
            }
        } else {
            this.scopes = new ArrayList<String>();
        }
        return (A)this;
    }

    @Override
    public A withScopes(String ... scopes) {
        if (this.scopes != null) {
            this.scopes.clear();
        }
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasScopes() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    @Override
    public A addNewScope(String arg1) {
        return this.addToScopes(new String(arg1));
    }

    @Override
    public A addNewScope(StringBuilder arg1) {
        return this.addToScopes(new String(arg1));
    }

    @Override
    public A addNewScope(StringBuffer arg1) {
        return this.addToScopes(new String(arg1));
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public A withUserName(String userName) {
        this.userName = userName;
        return (A)this;
    }

    @Override
    public Boolean hasUserName() {
        return this.userName != null;
    }

    @Override
    public A withNewUserName(String arg1) {
        return this.withUserName(new String(arg1));
    }

    @Override
    public A withNewUserName(StringBuilder arg1) {
        return this.withUserName(new String(arg1));
    }

    @Override
    public A withNewUserName(StringBuffer arg1) {
        return this.withUserName(new String(arg1));
    }

    @Override
    public String getUserUID() {
        return this.userUID;
    }

    @Override
    public A withUserUID(String userUID) {
        this.userUID = userUID;
        return (A)this;
    }

    @Override
    public Boolean hasUserUID() {
        return this.userUID != null;
    }

    @Override
    public A withNewUserUID(String arg1) {
        return this.withUserUID(new String(arg1));
    }

    @Override
    public A withNewUserUID(StringBuilder arg1) {
        return this.withUserUID(new String(arg1));
    }

    @Override
    public A withNewUserUID(StringBuffer arg1) {
        return this.withUserUID(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthAccessTokenFluentImpl that = (OAuthAccessTokenFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.authorizeToken != null ? !this.authorizeToken.equals(that.authorizeToken) : that.authorizeToken != null) {
            return false;
        }
        if (this.clientName != null ? !this.clientName.equals(that.clientName) : that.clientName != null) {
            return false;
        }
        if (this.expiresIn != null ? !this.expiresIn.equals(that.expiresIn) : that.expiresIn != null) {
            return false;
        }
        if (this.inactivityTimeoutSeconds != null ? !this.inactivityTimeoutSeconds.equals(that.inactivityTimeoutSeconds) : that.inactivityTimeoutSeconds != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.redirectURI != null ? !this.redirectURI.equals(that.redirectURI) : that.redirectURI != null) {
            return false;
        }
        if (this.refreshToken != null ? !this.refreshToken.equals(that.refreshToken) : that.refreshToken != null) {
            return false;
        }
        if (this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null) {
            return false;
        }
        if (this.userName != null ? !this.userName.equals(that.userName) : that.userName != null) {
            return false;
        }
        return !(this.userUID != null ? !this.userUID.equals(that.userUID) : that.userUID != null);
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<OAuthAccessTokenFluent.MetadataNested<N>>
    implements OAuthAccessTokenFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)OAuthAccessTokenFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

