/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_5;

import io.fabric8.kubernetes.api.builder.v4_5.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_5.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_5.Build;
import io.fabric8.openshift.api.model.v4_5.BuildFluent;
import io.fabric8.openshift.api.model.v4_5.BuildFluentImpl;
import javax.validation.Validator;

public class BuildBuilder
extends BuildFluentImpl<BuildBuilder>
implements VisitableBuilder<Build, BuildBuilder> {
    BuildFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BuildBuilder() {
        this(true);
    }

    public BuildBuilder(Boolean validationEnabled) {
        this(new Build(), validationEnabled);
    }

    public BuildBuilder(BuildFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BuildBuilder(BuildFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Build(), validationEnabled);
    }

    public BuildBuilder(BuildFluent<?> fluent, Build instance) {
        this(fluent, instance, true);
    }

    public BuildBuilder(BuildFluent<?> fluent, Build instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public BuildBuilder(Build instance) {
        this(instance, (Boolean)true);
    }

    public BuildBuilder(Build instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public BuildBuilder(Validator validator) {
        this(new Build(), (Boolean)true);
    }

    public BuildBuilder(BuildFluent<?> fluent, Build instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public BuildBuilder(Build instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Build build() {
        Build buildable = new Build(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildBuilder that = (BuildBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

