/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_5.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_5.Container;
import io.fabric8.kubernetes.api.model.v4_5.ContainerBuilder;
import io.fabric8.kubernetes.api.model.v4_5.LabelSelector;
import io.fabric8.kubernetes.api.model.v4_5.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v4_5.apps.Deployment;
import io.fabric8.kubernetes.api.model.v4_5.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.v4_5.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.v4_5.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.v4_5.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.v4_5.apps.DoneableDeployment;
import io.fabric8.kubernetes.clnt.v4_5.Config;
import io.fabric8.kubernetes.clnt.v4_5.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_5.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v4_5.dsl.ImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v4_5.dsl.Reaper;
import io.fabric8.kubernetes.clnt.v4_5.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_5.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v4_5.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_5.dsl.internal.DeploymentRollingUpdater;
import io.fabric8.kubernetes.clnt.v4_5.dsl.internal.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_5.dsl.internal.RollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v4_5.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.clnt.v4_5.dsl.internal.RollingUpdater;
import io.fabric8.kubernetes.clnt.v4_5.utils.Utils;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentOperationsImpl
extends RollableScalableResourceOperation<Deployment, DeploymentList, DoneableDeployment, RollableScalableResource<Deployment, DoneableDeployment>>
implements TimeoutImageEditReplacePatchable<Deployment, Deployment, DoneableDeployment> {
    static final transient Logger LOG = LoggerFactory.getLogger(DeploymentOperationsImpl.class);

    public DeploymentOperationsImpl(OkHttpClient client, Config config) {
        this(client, config, null);
    }

    public DeploymentOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(new RollingOperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withCascading(true));
        if (config.getNamespace() != null) {
            this.namespace = config.getNamespace();
        }
    }

    public DeploymentOperationsImpl(RollingOperationContext context) {
        super(context.withApiGroupName("apps").withApiGroupVersion("v1").withPlural("deployments"));
        this.type = Deployment.class;
        this.listType = DeploymentList.class;
        this.doneableType = DoneableDeployment.class;
        this.reaper = new DeploymentReaper(this);
    }

    public DeploymentOperationsImpl newInstance(OperationContext context) {
        return new DeploymentOperationsImpl((RollingOperationContext)context);
    }

    @Override
    public Deployment scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public Deployment scale(int count, boolean wait) {
        Deployment res = ((DoneableDeployment)((DeploymentFluent.SpecNested)((DoneableDeployment)this.cascading(false).edit()).editSpec().withReplicas(count)).endSpec()).done();
        if (wait) {
            this.waitUntilDeploymentIsScaled(count);
            res = (Deployment)this.getMandatory();
        }
        return res;
    }

    @Override
    public DoneableDeployment edit() {
        if (this.isCascading().booleanValue()) {
            return (DoneableDeployment)this.cascading(false).edit();
        }
        return (DoneableDeployment)super.edit();
    }

    @Override
    public Deployment replace(Deployment item) {
        if (this.isCascading().booleanValue()) {
            return (Deployment)this.cascading(false).replace(item);
        }
        return super.replace(item);
    }

    @Override
    public Deployment patch(Deployment item) {
        if (this.isCascading().booleanValue()) {
            return (Deployment)this.cascading(false).patch(item);
        }
        return super.patch(item);
    }

    @Override
    public DeploymentOperationsImpl rolling() {
        return new DeploymentOperationsImpl(((RollingOperationContext)this.context).withRolling(true));
    }

    @Override
    RollingUpdater<Deployment, DeploymentList, DoneableDeployment> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new DeploymentRollingUpdater(this.client, this.config, this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    Deployment withReplicas(int count) {
        return ((DoneableDeployment)((DeploymentFluent.SpecNested)((DoneableDeployment)this.cascading(false).edit()).editSpec().withReplicas(count)).endSpec()).done();
    }

    @Override
    int getCurrentReplicas(Deployment current) {
        return current.getStatus().getReplicas();
    }

    @Override
    int getDesiredReplicas(Deployment item) {
        return item.getSpec().getReplicas();
    }

    @Override
    long getObservedGeneration(Deployment current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public Deployment updateImage(String image) {
        Deployment oldRC = (Deployment)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replica set doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() == 0) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container updatedContainer = ((ContainerBuilder)new ContainerBuilder(oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next()).withImage(image)).build();
        DeploymentBuilder newRCBuilder = new DeploymentBuilder(oldRC);
        ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)newRCBuilder.editMetadata().withResourceVersion(null)).endMetadata()).editSpec().editTemplate().editSpec().withContainers(Collections.singletonList(updatedContainer))).endSpec()).endTemplate()).endSpec();
        return new DeploymentRollingUpdater(this.client, this.config, this.namespace).rollUpdate(oldRC, newRCBuilder.build());
    }

    @Override
    public ImageEditReplacePatchable<Deployment, Deployment, DoneableDeployment> withTimeoutInMillis(long timeoutInMillis) {
        return new DeploymentOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(timeoutInMillis));
    }

    @Override
    public ImageEditReplacePatchable<Deployment, Deployment, DoneableDeployment> withTimeout(long timeout, TimeUnit unit) {
        return new DeploymentOperationsImpl(((RollingOperationContext)this.context).withRollingTimeUnit(unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDeploymentIsScaled(int count) {
        ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        Runnable deploymentPoller = () -> {
            try {
                long observedGeneration;
                Deployment deployment = (Deployment)this.get();
                if (deployment == null) {
                    if (count == 0) {
                        queue.put(true);
                        return;
                    }
                    queue.put(new IllegalStateException("Can't wait for Deployment: " + this.checkName(this.getItem()) + " in namespace: " + this.checkName(this.getItem()) + " to scale. Resource is no longer available."));
                    return;
                }
                replicasRef.set(deployment.getStatus().getReplicas());
                int currentReplicas = deployment.getStatus().getReplicas() != null ? deployment.getStatus().getReplicas() : 0;
                long generation = deployment.getMetadata().getGeneration() != null ? deployment.getMetadata().getGeneration() : 0L;
                long l = observedGeneration = deployment.getStatus() != null && deployment.getStatus().getObservedGeneration() != null ? deployment.getStatus().getObservedGeneration() : -1L;
                if (observedGeneration >= generation && Objects.equals(deployment.getSpec().getReplicas(), currentReplicas)) {
                    queue.put(true);
                } else {
                    LOG.debug("Only {}/{} pods scheduled for Deployment: {} in namespace: {} seconds so waiting...", new Object[]{deployment.getStatus().getReplicas(), deployment.getSpec().getReplicas(), deployment.getMetadata().getName(), namespace});
                }
            }
            catch (Throwable t) {
                LOG.error("Error while waiting for Deployment to be scaled.", t);
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            if (Utils.waitUntilReady(queue, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS)) {
                LOG.debug("{}/{} pod(s) ready for Deployment: {} in namespace: {}.", new Object[]{replicasRef.get(), count, name, namespace});
            } else {
                LOG.error("{}/{} pod(s) ready for Deployment: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout())});
            }
        }
        finally {
            poller.cancel(true);
            executor.shutdown();
        }
    }

    private static class DeploymentReaper
    implements Reaper {
        private DeploymentOperationsImpl oper;

        public DeploymentReaper(DeploymentOperationsImpl oper) {
            this.oper = oper;
        }

        @Override
        public boolean reap() {
            Deployment deployment = ((DoneableDeployment)((DeploymentFluent.SpecNested)((DoneableDeployment)this.oper.cascading(false).edit()).editSpec().withReplicas(0)).endSpec()).done();
            if (deployment.getStatus() != null) {
                this.waitForObservedGeneration(deployment.getStatus().getObservedGeneration());
            }
            if (deployment.getSpec().getSelector() != null) {
                this.reapMatchingReplicaSets(deployment.getSpec().getSelector());
            }
            return false;
        }

        private void waitForObservedGeneration(long observedGeneration) {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            Runnable deploymentPoller = () -> {
                Deployment deployment = (Deployment)this.oper.getMandatory();
                if (observedGeneration <= deployment.getStatus().getObservedGeneration()) {
                    countDownLatch.countDown();
                }
            };
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 10L, TimeUnit.MILLISECONDS);
            try {
                countDownLatch.await(30L, TimeUnit.SECONDS);
                executor.shutdown();
            }
            catch (InterruptedException e) {
                poller.cancel(true);
                executor.shutdown();
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        private void reapMatchingReplicaSets(LabelSelector selector) {
            if (selector == null || selector.getMatchLabels() == null && selector.getMatchExpressions() == null) {
                return;
            }
            ReplicaSetOperationsImpl rsOper = new ReplicaSetOperationsImpl(new RollingOperationContext().withOkhttpClient(this.oper.client).withConfig(this.oper.config).withNamespace(this.oper.getNamespace()));
            ((FilterWatchListDeletable)rsOper.inNamespace(this.oper.getNamespace()).withLabelSelector(selector)).delete();
        }
    }
}

