/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_5.extensions;

import io.fabric8.kubernetes.api.builder.v4_5.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_5.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_5.extensions.PodSecurityPolicySpec;
import io.fabric8.kubernetes.api.model.v4_5.extensions.PodSecurityPolicySpecFluent;
import io.fabric8.kubernetes.api.model.v4_5.extensions.PodSecurityPolicySpecFluentImpl;
import javax.validation.Validator;

public class PodSecurityPolicySpecBuilder
extends PodSecurityPolicySpecFluentImpl<PodSecurityPolicySpecBuilder>
implements VisitableBuilder<PodSecurityPolicySpec, PodSecurityPolicySpecBuilder> {
    PodSecurityPolicySpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PodSecurityPolicySpecBuilder() {
        this(true);
    }

    public PodSecurityPolicySpecBuilder(Boolean validationEnabled) {
        this(new PodSecurityPolicySpec(), validationEnabled);
    }

    public PodSecurityPolicySpecBuilder(PodSecurityPolicySpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodSecurityPolicySpecBuilder(PodSecurityPolicySpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodSecurityPolicySpec(), validationEnabled);
    }

    public PodSecurityPolicySpecBuilder(PodSecurityPolicySpecFluent<?> fluent, PodSecurityPolicySpec instance) {
        this(fluent, instance, true);
    }

    public PodSecurityPolicySpecBuilder(PodSecurityPolicySpecFluent<?> fluent, PodSecurityPolicySpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
        fluent.withAllowedCSIDrivers(instance.getAllowedCSIDrivers());
        fluent.withAllowedCapabilities(instance.getAllowedCapabilities());
        fluent.withAllowedFlexVolumes(instance.getAllowedFlexVolumes());
        fluent.withAllowedHostPaths(instance.getAllowedHostPaths());
        fluent.withAllowedProcMountTypes(instance.getAllowedProcMountTypes());
        fluent.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls());
        fluent.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
        fluent.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation());
        fluent.withForbiddenSysctls(instance.getForbiddenSysctls());
        fluent.withFsGroup(instance.getFsGroup());
        fluent.withHostIPC(instance.getHostIPC());
        fluent.withHostNetwork(instance.getHostNetwork());
        fluent.withHostPID(instance.getHostPID());
        fluent.withHostPorts(instance.getHostPorts());
        fluent.withPrivileged(instance.getPrivileged());
        fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        fluent.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
        fluent.withRunAsGroup(instance.getRunAsGroup());
        fluent.withRunAsUser(instance.getRunAsUser());
        fluent.withSeLinux(instance.getSeLinux());
        fluent.withSupplementalGroups(instance.getSupplementalGroups());
        fluent.withVolumes(instance.getVolumes());
        this.validationEnabled = validationEnabled;
    }

    public PodSecurityPolicySpecBuilder(PodSecurityPolicySpec instance) {
        this(instance, (Boolean)true);
    }

    public PodSecurityPolicySpecBuilder(PodSecurityPolicySpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
        this.withAllowedCSIDrivers(instance.getAllowedCSIDrivers());
        this.withAllowedCapabilities(instance.getAllowedCapabilities());
        this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes());
        this.withAllowedHostPaths(instance.getAllowedHostPaths());
        this.withAllowedProcMountTypes(instance.getAllowedProcMountTypes());
        this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls());
        this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
        this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation());
        this.withForbiddenSysctls(instance.getForbiddenSysctls());
        this.withFsGroup(instance.getFsGroup());
        this.withHostIPC(instance.getHostIPC());
        this.withHostNetwork(instance.getHostNetwork());
        this.withHostPID(instance.getHostPID());
        this.withHostPorts(instance.getHostPorts());
        this.withPrivileged(instance.getPrivileged());
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
        this.withRunAsGroup(instance.getRunAsGroup());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinux(instance.getSeLinux());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withVolumes(instance.getVolumes());
        this.validationEnabled = validationEnabled;
    }

    public PodSecurityPolicySpecBuilder(Validator validator) {
        this(new PodSecurityPolicySpec(), (Boolean)true);
    }

    public PodSecurityPolicySpecBuilder(PodSecurityPolicySpecFluent<?> fluent, PodSecurityPolicySpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
        fluent.withAllowedCSIDrivers(instance.getAllowedCSIDrivers());
        fluent.withAllowedCapabilities(instance.getAllowedCapabilities());
        fluent.withAllowedFlexVolumes(instance.getAllowedFlexVolumes());
        fluent.withAllowedHostPaths(instance.getAllowedHostPaths());
        fluent.withAllowedProcMountTypes(instance.getAllowedProcMountTypes());
        fluent.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls());
        fluent.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
        fluent.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation());
        fluent.withForbiddenSysctls(instance.getForbiddenSysctls());
        fluent.withFsGroup(instance.getFsGroup());
        fluent.withHostIPC(instance.getHostIPC());
        fluent.withHostNetwork(instance.getHostNetwork());
        fluent.withHostPID(instance.getHostPID());
        fluent.withHostPorts(instance.getHostPorts());
        fluent.withPrivileged(instance.getPrivileged());
        fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        fluent.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
        fluent.withRunAsGroup(instance.getRunAsGroup());
        fluent.withRunAsUser(instance.getRunAsUser());
        fluent.withSeLinux(instance.getSeLinux());
        fluent.withSupplementalGroups(instance.getSupplementalGroups());
        fluent.withVolumes(instance.getVolumes());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PodSecurityPolicySpecBuilder(PodSecurityPolicySpec instance, Validator validator) {
        this.fluent = this;
        this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
        this.withAllowedCSIDrivers(instance.getAllowedCSIDrivers());
        this.withAllowedCapabilities(instance.getAllowedCapabilities());
        this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes());
        this.withAllowedHostPaths(instance.getAllowedHostPaths());
        this.withAllowedProcMountTypes(instance.getAllowedProcMountTypes());
        this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls());
        this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
        this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation());
        this.withForbiddenSysctls(instance.getForbiddenSysctls());
        this.withFsGroup(instance.getFsGroup());
        this.withHostIPC(instance.getHostIPC());
        this.withHostNetwork(instance.getHostNetwork());
        this.withHostPID(instance.getHostPID());
        this.withHostPorts(instance.getHostPorts());
        this.withPrivileged(instance.getPrivileged());
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
        this.withRunAsGroup(instance.getRunAsGroup());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinux(instance.getSeLinux());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withVolumes(instance.getVolumes());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public PodSecurityPolicySpec build() {
        PodSecurityPolicySpec buildable = new PodSecurityPolicySpec(this.fluent.isAllowPrivilegeEscalation(), this.fluent.getAllowedCSIDrivers(), this.fluent.getAllowedCapabilities(), this.fluent.getAllowedFlexVolumes(), this.fluent.getAllowedHostPaths(), this.fluent.getAllowedProcMountTypes(), this.fluent.getAllowedUnsafeSysctls(), this.fluent.getDefaultAddCapabilities(), this.fluent.isDefaultAllowPrivilegeEscalation(), this.fluent.getForbiddenSysctls(), this.fluent.getFsGroup(), this.fluent.isHostIPC(), this.fluent.isHostNetwork(), this.fluent.isHostPID(), this.fluent.getHostPorts(), this.fluent.isPrivileged(), this.fluent.isReadOnlyRootFilesystem(), this.fluent.getRequiredDropCapabilities(), this.fluent.getRunAsGroup(), this.fluent.getRunAsUser(), this.fluent.getSeLinux(), this.fluent.getSupplementalGroups(), this.fluent.getVolumes());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityPolicySpecBuilder that = (PodSecurityPolicySpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

