/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_5.extensions;

import io.fabric8.kubernetes.api.builder.v4_5.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_5.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_5.extensions.HTTPIngressRuleValue;
import io.fabric8.kubernetes.api.model.v4_5.extensions.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.v4_5.extensions.HTTPIngressRuleValueFluentImpl;
import javax.validation.Validator;

public class HTTPIngressRuleValueBuilder
extends HTTPIngressRuleValueFluentImpl<HTTPIngressRuleValueBuilder>
implements VisitableBuilder<HTTPIngressRuleValue, HTTPIngressRuleValueBuilder> {
    HTTPIngressRuleValueFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HTTPIngressRuleValueBuilder() {
        this(true);
    }

    public HTTPIngressRuleValueBuilder(Boolean validationEnabled) {
        this(new HTTPIngressRuleValue(), validationEnabled);
    }

    public HTTPIngressRuleValueBuilder(HTTPIngressRuleValueFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HTTPIngressRuleValueBuilder(HTTPIngressRuleValueFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HTTPIngressRuleValue(), validationEnabled);
    }

    public HTTPIngressRuleValueBuilder(HTTPIngressRuleValueFluent<?> fluent, HTTPIngressRuleValue instance) {
        this(fluent, instance, true);
    }

    public HTTPIngressRuleValueBuilder(HTTPIngressRuleValueFluent<?> fluent, HTTPIngressRuleValue instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPaths(instance.getPaths());
        this.validationEnabled = validationEnabled;
    }

    public HTTPIngressRuleValueBuilder(HTTPIngressRuleValue instance) {
        this(instance, (Boolean)true);
    }

    public HTTPIngressRuleValueBuilder(HTTPIngressRuleValue instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPaths(instance.getPaths());
        this.validationEnabled = validationEnabled;
    }

    public HTTPIngressRuleValueBuilder(Validator validator) {
        this(new HTTPIngressRuleValue(), (Boolean)true);
    }

    public HTTPIngressRuleValueBuilder(HTTPIngressRuleValueFluent<?> fluent, HTTPIngressRuleValue instance, Validator validator) {
        this.fluent = fluent;
        fluent.withPaths(instance.getPaths());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public HTTPIngressRuleValueBuilder(HTTPIngressRuleValue instance, Validator validator) {
        this.fluent = this;
        this.withPaths(instance.getPaths());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public HTTPIngressRuleValue build() {
        HTTPIngressRuleValue buildable = new HTTPIngressRuleValue(this.fluent.getPaths());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPIngressRuleValueBuilder that = (HTTPIngressRuleValueBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

