/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_5.authentication;

import io.fabric8.kubernetes.api.builder.v4_5.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_5.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_5.authentication.UserInfo;
import io.fabric8.kubernetes.api.model.v4_5.authentication.UserInfoFluent;
import io.fabric8.kubernetes.api.model.v4_5.authentication.UserInfoFluentImpl;
import javax.validation.Validator;

public class UserInfoBuilder
extends UserInfoFluentImpl<UserInfoBuilder>
implements VisitableBuilder<UserInfo, UserInfoBuilder> {
    UserInfoFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public UserInfoBuilder() {
        this(true);
    }

    public UserInfoBuilder(Boolean validationEnabled) {
        this(new UserInfo(), validationEnabled);
    }

    public UserInfoBuilder(UserInfoFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public UserInfoBuilder(UserInfoFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new UserInfo(), validationEnabled);
    }

    public UserInfoBuilder(UserInfoFluent<?> fluent, UserInfo instance) {
        this(fluent, instance, true);
    }

    public UserInfoBuilder(UserInfoFluent<?> fluent, UserInfo instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withExtra(instance.getExtra());
        fluent.withGroups(instance.getGroups());
        fluent.withUid(instance.getUid());
        fluent.withUsername(instance.getUsername());
        this.validationEnabled = validationEnabled;
    }

    public UserInfoBuilder(UserInfo instance) {
        this(instance, (Boolean)true);
    }

    public UserInfoBuilder(UserInfo instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withExtra(instance.getExtra());
        this.withGroups(instance.getGroups());
        this.withUid(instance.getUid());
        this.withUsername(instance.getUsername());
        this.validationEnabled = validationEnabled;
    }

    public UserInfoBuilder(Validator validator) {
        this(new UserInfo(), (Boolean)true);
    }

    public UserInfoBuilder(UserInfoFluent<?> fluent, UserInfo instance, Validator validator) {
        this.fluent = fluent;
        fluent.withExtra(instance.getExtra());
        fluent.withGroups(instance.getGroups());
        fluent.withUid(instance.getUid());
        fluent.withUsername(instance.getUsername());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public UserInfoBuilder(UserInfo instance, Validator validator) {
        this.fluent = this;
        this.withExtra(instance.getExtra());
        this.withGroups(instance.getGroups());
        this.withUid(instance.getUid());
        this.withUsername(instance.getUsername());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public UserInfo build() {
        UserInfo buildable = new UserInfo(this.fluent.getExtra(), this.fluent.getGroups(), this.fluent.getUid(), this.fluent.getUsername());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserInfoBuilder that = (UserInfoBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

