/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_5.admission;

import io.fabric8.kubernetes.api.builder.v4_5.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_5.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_5.admission.AdmissionResponse;
import io.fabric8.kubernetes.api.model.v4_5.admission.AdmissionResponseFluent;
import io.fabric8.kubernetes.api.model.v4_5.admission.AdmissionResponseFluentImpl;
import javax.validation.Validator;

public class AdmissionResponseBuilder
extends AdmissionResponseFluentImpl<AdmissionResponseBuilder>
implements VisitableBuilder<AdmissionResponse, AdmissionResponseBuilder> {
    AdmissionResponseFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public AdmissionResponseBuilder() {
        this(true);
    }

    public AdmissionResponseBuilder(Boolean validationEnabled) {
        this(new AdmissionResponse(), validationEnabled);
    }

    public AdmissionResponseBuilder(AdmissionResponseFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AdmissionResponseBuilder(AdmissionResponseFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AdmissionResponse(), validationEnabled);
    }

    public AdmissionResponseBuilder(AdmissionResponseFluent<?> fluent, AdmissionResponse instance) {
        this(fluent, instance, true);
    }

    public AdmissionResponseBuilder(AdmissionResponseFluent<?> fluent, AdmissionResponse instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAllowed(instance.getAllowed());
        fluent.withAuditAnnotations(instance.getAuditAnnotations());
        fluent.withPatch(instance.getPatch());
        fluent.withPatchType(instance.getPatchType());
        fluent.withStatus(instance.getStatus());
        fluent.withUid(instance.getUid());
        this.validationEnabled = validationEnabled;
    }

    public AdmissionResponseBuilder(AdmissionResponse instance) {
        this(instance, (Boolean)true);
    }

    public AdmissionResponseBuilder(AdmissionResponse instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAllowed(instance.getAllowed());
        this.withAuditAnnotations(instance.getAuditAnnotations());
        this.withPatch(instance.getPatch());
        this.withPatchType(instance.getPatchType());
        this.withStatus(instance.getStatus());
        this.withUid(instance.getUid());
        this.validationEnabled = validationEnabled;
    }

    public AdmissionResponseBuilder(Validator validator) {
        this(new AdmissionResponse(), (Boolean)true);
    }

    public AdmissionResponseBuilder(AdmissionResponseFluent<?> fluent, AdmissionResponse instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAllowed(instance.getAllowed());
        fluent.withAuditAnnotations(instance.getAuditAnnotations());
        fluent.withPatch(instance.getPatch());
        fluent.withPatchType(instance.getPatchType());
        fluent.withStatus(instance.getStatus());
        fluent.withUid(instance.getUid());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public AdmissionResponseBuilder(AdmissionResponse instance, Validator validator) {
        this.fluent = this;
        this.withAllowed(instance.getAllowed());
        this.withAuditAnnotations(instance.getAuditAnnotations());
        this.withPatch(instance.getPatch());
        this.withPatchType(instance.getPatchType());
        this.withStatus(instance.getStatus());
        this.withUid(instance.getUid());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public AdmissionResponse build() {
        AdmissionResponse buildable = new AdmissionResponse(this.fluent.isAllowed(), this.fluent.getAuditAnnotations(), this.fluent.getPatch(), this.fluent.getPatchType(), this.fluent.getStatus(), this.fluent.getUid());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdmissionResponseBuilder that = (AdmissionResponseBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

