/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_5;

import io.fabric8.kubernetes.api.builder.v4_5.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_5.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_5.TypeMeta;
import io.fabric8.kubernetes.api.model.v4_5.TypeMetaFluent;
import io.fabric8.kubernetes.api.model.v4_5.TypeMetaFluentImpl;
import javax.validation.Validator;

public class TypeMetaBuilder
extends TypeMetaFluentImpl<TypeMetaBuilder>
implements VisitableBuilder<TypeMeta, TypeMetaBuilder> {
    TypeMetaFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TypeMetaBuilder() {
        this(true);
    }

    public TypeMetaBuilder(Boolean validationEnabled) {
        this(new TypeMeta(), validationEnabled);
    }

    public TypeMetaBuilder(TypeMetaFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TypeMetaBuilder(TypeMetaFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TypeMeta(), validationEnabled);
    }

    public TypeMetaBuilder(TypeMetaFluent<?> fluent, TypeMeta instance) {
        this(fluent, instance, true);
    }

    public TypeMetaBuilder(TypeMetaFluent<?> fluent, TypeMeta instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        this.validationEnabled = validationEnabled;
    }

    public TypeMetaBuilder(TypeMeta instance) {
        this(instance, (Boolean)true);
    }

    public TypeMetaBuilder(TypeMeta instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.validationEnabled = validationEnabled;
    }

    public TypeMetaBuilder(Validator validator) {
        this(new TypeMeta(), (Boolean)true);
    }

    public TypeMetaBuilder(TypeMetaFluent<?> fluent, TypeMeta instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public TypeMetaBuilder(TypeMeta instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public TypeMeta build() {
        TypeMeta buildable = new TypeMeta(this.fluent.getApiVersion(), this.fluent.getKind());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeMetaBuilder that = (TypeMetaBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

