/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_5;

import io.fabric8.kubernetes.api.builder.v4_5.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_5.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_5.HTTPHeader;
import io.fabric8.kubernetes.api.model.v4_5.HTTPHeaderFluent;
import io.fabric8.kubernetes.api.model.v4_5.HTTPHeaderFluentImpl;
import javax.validation.Validator;

public class HTTPHeaderBuilder
extends HTTPHeaderFluentImpl<HTTPHeaderBuilder>
implements VisitableBuilder<HTTPHeader, HTTPHeaderBuilder> {
    HTTPHeaderFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HTTPHeaderBuilder() {
        this(true);
    }

    public HTTPHeaderBuilder(Boolean validationEnabled) {
        this(new HTTPHeader(), validationEnabled);
    }

    public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HTTPHeader(), validationEnabled);
    }

    public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent, HTTPHeader instance) {
        this(fluent, instance, true);
    }

    public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent, HTTPHeader instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public HTTPHeaderBuilder(HTTPHeader instance) {
        this(instance, (Boolean)true);
    }

    public HTTPHeaderBuilder(HTTPHeader instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public HTTPHeaderBuilder(Validator validator) {
        this(new HTTPHeader(), (Boolean)true);
    }

    public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent, HTTPHeader instance, Validator validator) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withValue(instance.getValue());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public HTTPHeaderBuilder(HTTPHeader instance, Validator validator) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withValue(instance.getValue());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public HTTPHeader build() {
        HTTPHeader buildable = new HTTPHeader(this.fluent.getName(), this.fluent.getValue());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPHeaderBuilder that = (HTTPHeaderBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

