/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_5;

import io.fabric8.kubernetes.api.builder.v4_5.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_5.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_5.EndpointPort;
import io.fabric8.kubernetes.api.model.v4_5.EndpointPortFluent;
import io.fabric8.kubernetes.api.model.v4_5.EndpointPortFluentImpl;
import javax.validation.Validator;

public class EndpointPortBuilder
extends EndpointPortFluentImpl<EndpointPortBuilder>
implements VisitableBuilder<EndpointPort, EndpointPortBuilder> {
    EndpointPortFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public EndpointPortBuilder() {
        this(true);
    }

    public EndpointPortBuilder(Boolean validationEnabled) {
        this(new EndpointPort(), validationEnabled);
    }

    public EndpointPortBuilder(EndpointPortFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EndpointPortBuilder(EndpointPortFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EndpointPort(), validationEnabled);
    }

    public EndpointPortBuilder(EndpointPortFluent<?> fluent, EndpointPort instance) {
        this(fluent, instance, true);
    }

    public EndpointPortBuilder(EndpointPortFluent<?> fluent, EndpointPort instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withPort(instance.getPort());
        fluent.withProtocol(instance.getProtocol());
        this.validationEnabled = validationEnabled;
    }

    public EndpointPortBuilder(EndpointPort instance) {
        this(instance, (Boolean)true);
    }

    public EndpointPortBuilder(EndpointPort instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withPort(instance.getPort());
        this.withProtocol(instance.getProtocol());
        this.validationEnabled = validationEnabled;
    }

    public EndpointPortBuilder(Validator validator) {
        this(new EndpointPort(), (Boolean)true);
    }

    public EndpointPortBuilder(EndpointPortFluent<?> fluent, EndpointPort instance, Validator validator) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withPort(instance.getPort());
        fluent.withProtocol(instance.getProtocol());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public EndpointPortBuilder(EndpointPort instance, Validator validator) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withPort(instance.getPort());
        this.withProtocol(instance.getProtocol());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public EndpointPort build() {
        EndpointPort buildable = new EndpointPort(this.fluent.getName(), this.fluent.getPort(), this.fluent.getProtocol());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointPortBuilder that = (EndpointPortBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

