/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_5;

import io.fabric8.kubernetes.api.builder.v4_5.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_5.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_5.Capabilities;
import io.fabric8.kubernetes.api.model.v4_5.CapabilitiesFluent;
import io.fabric8.kubernetes.api.model.v4_5.CapabilitiesFluentImpl;
import javax.validation.Validator;

public class CapabilitiesBuilder
extends CapabilitiesFluentImpl<CapabilitiesBuilder>
implements VisitableBuilder<Capabilities, CapabilitiesBuilder> {
    CapabilitiesFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CapabilitiesBuilder() {
        this(true);
    }

    public CapabilitiesBuilder(Boolean validationEnabled) {
        this(new Capabilities(), validationEnabled);
    }

    public CapabilitiesBuilder(CapabilitiesFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CapabilitiesBuilder(CapabilitiesFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Capabilities(), validationEnabled);
    }

    public CapabilitiesBuilder(CapabilitiesFluent<?> fluent, Capabilities instance) {
        this(fluent, instance, true);
    }

    public CapabilitiesBuilder(CapabilitiesFluent<?> fluent, Capabilities instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAdd(instance.getAdd());
        fluent.withDrop(instance.getDrop());
        this.validationEnabled = validationEnabled;
    }

    public CapabilitiesBuilder(Capabilities instance) {
        this(instance, (Boolean)true);
    }

    public CapabilitiesBuilder(Capabilities instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAdd(instance.getAdd());
        this.withDrop(instance.getDrop());
        this.validationEnabled = validationEnabled;
    }

    public CapabilitiesBuilder(Validator validator) {
        this(new Capabilities(), (Boolean)true);
    }

    public CapabilitiesBuilder(CapabilitiesFluent<?> fluent, Capabilities instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAdd(instance.getAdd());
        fluent.withDrop(instance.getDrop());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public CapabilitiesBuilder(Capabilities instance, Validator validator) {
        this.fluent = this;
        this.withAdd(instance.getAdd());
        this.withDrop(instance.getDrop());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Capabilities build() {
        Capabilities buildable = new Capabilities(this.fluent.getAdd(), this.fluent.getDrop());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CapabilitiesBuilder that = (CapabilitiesBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

