/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_4.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_4.Status;
import io.fabric8.kubernetes.clnt.v4_4.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_4.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_4.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v4_4.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v4_4.utils.Utils;
import io.fabric8.openshift.api.model.v4_4.DoneableProjectRequest;
import io.fabric8.openshift.api.model.v4_4.ProjectRequest;
import io.fabric8.openshift.clnt.v4_4.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_4.dsl.ProjectRequestOperation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class ProjectRequestsOperationImpl
extends OperationSupport
implements ProjectRequestOperation {
    public ProjectRequestsOperationImpl(OkHttpClient client, OpenShiftConfig config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public ProjectRequestsOperationImpl(OperationContext context) {
        super(context.withApiGroupName("project.openshift.io").withPlural("projectrequests"));
    }

    @Override
    public boolean isResourceNamespaced() {
        return false;
    }

    @Override
    public URL getRootUrl() {
        if (Utils.isNullOrEmpty(this.context.getApiGroupName())) {
            try {
                return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
            }
            catch (MalformedURLException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }
        return super.getRootUrl();
    }

    private ProjectRequest updateApiVersion(ProjectRequest p) {
        if (p.getApiVersion() == null) {
            p.setApiVersion(this.apiGroupVersion);
        }
        return p;
    }

    public ProjectRequest create(ProjectRequest ... resources) {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return this.handleCreate(this.updateApiVersion(resources[0]), ProjectRequest.class);
            }
            if (this.getItem() == null) {
                throw new IllegalArgumentException("Nothing to create.");
            }
            return this.handleCreate(this.updateApiVersion(this.getItem()), ProjectRequest.class);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public DoneableProjectRequest createNew() {
        return new DoneableProjectRequest(item -> {
            try {
                return this.create((ProjectRequest)item);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        });
    }

    @Override
    public Status list() {
        try {
            URL requestUrl = this.getNamespacedUrl();
            Request.Builder requestBuilder = new Request.Builder().get().url(requestUrl);
            return this.handleResponse(requestBuilder, Status.class);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public Status list(Integer limitVal, String continueVal) {
        try {
            URL requestUrl = this.getNamespacedUrl();
            if (limitVal != null) {
                requestUrl = new URL(URLUtils.join(requestUrl.toString(), "?limit=" + limitVal.toString()));
            } else if (continueVal != null) {
                requestUrl = new URL(URLUtils.join(requestUrl.toString(), "?limit=" + limitVal.toString() + "&continue=" + continueVal));
            }
            Request.Builder requestBuilder = new Request.Builder().get().url(requestUrl);
            return this.handleResponse(requestBuilder, Status.class);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public ProjectRequest getItem() {
        return (ProjectRequest)this.context.getItem();
    }
}

