/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_4.dsl.internal;

import io.fabric8.kubernetes.api.builder.v4_4.TypedVisitor;
import io.fabric8.kubernetes.api.model.v4_4.ObjectReference;
import io.fabric8.kubernetes.api.model.v4_4.ObjectReferenceBuilder;
import io.fabric8.kubernetes.clnt.v4_4.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_4.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_4.dsl.base.OperationContext;
import io.fabric8.openshift.api.model.v4_4.DoneableOpenshiftRoleBinding;
import io.fabric8.openshift.api.model.v4_4.OpenshiftRoleBinding;
import io.fabric8.openshift.api.model.v4_4.OpenshiftRoleBindingBuilder;
import io.fabric8.openshift.api.model.v4_4.OpenshiftRoleBindingFluent;
import io.fabric8.openshift.api.model.v4_4.OpenshiftRoleBindingList;
import io.fabric8.openshift.clnt.v4_4.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_4.dsl.internal.OpenShiftOperation;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import okhttp3.OkHttpClient;

public class OpenshiftRoleBindingOperationsImpl
extends OpenShiftOperation<OpenshiftRoleBinding, OpenshiftRoleBindingList, DoneableOpenshiftRoleBinding, Resource<OpenshiftRoleBinding, DoneableOpenshiftRoleBinding>> {
    public OpenshiftRoleBindingOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public OpenshiftRoleBindingOperationsImpl(OperationContext context) {
        super(context.withApiGroupName("authorization.openshift.io").withPlural("rolebindings"));
        this.type = OpenshiftRoleBinding.class;
        this.listType = OpenshiftRoleBindingList.class;
        this.doneableType = DoneableOpenshiftRoleBinding.class;
    }

    public OpenshiftRoleBindingOperationsImpl newInstance(OperationContext context) {
        return new OpenshiftRoleBindingOperationsImpl(context);
    }

    @Override
    public OpenshiftRoleBinding replace(OpenshiftRoleBinding item) {
        OpenshiftRoleBinding enriched = this.enrichRoleBinding(item);
        return super.replace(enriched);
    }

    @Override
    public OpenshiftRoleBinding patch(OpenshiftRoleBinding item) {
        OpenshiftRoleBinding enriched = this.enrichRoleBinding(item);
        return super.patch(enriched);
    }

    @Override
    protected OpenshiftRoleBinding handleCreate(OpenshiftRoleBinding resource) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        return super.handleCreate(this.enrichRoleBinding(resource));
    }

    private OpenshiftRoleBinding enrichRoleBinding(OpenshiftRoleBinding binding) {
        OpenshiftRoleBindingBuilder builder = new OpenshiftRoleBindingBuilder(binding);
        if (binding.getUserNames() != null && !binding.getUserNames().isEmpty() || binding.getGroupNames() != null && !binding.getGroupNames().isEmpty()) {
            this.enrichFromUsersAndGroups(builder, binding.getUserNames(), binding.getGroupNames());
        } else {
            this.enrichFromSubjects(builder, binding.getSubjects());
            this.enrichSubjectsNamespace(builder);
        }
        return builder.build();
    }

    private void enrichSubjectsNamespace(OpenshiftRoleBindingBuilder builder) {
        builder.accept(new TypedVisitor<ObjectReferenceBuilder>(){

            @Override
            public void visit(ObjectReferenceBuilder o) {
                if (o.getKind() != null && o.getKind().equals("ServiceAccount") && (o.getNamespace() == null || o.getNamespace().isEmpty())) {
                    o.withNamespace(OpenshiftRoleBindingOperationsImpl.this.getNamespace());
                }
            }
        });
    }

    private void enrichFromUsersAndGroups(OpenshiftRoleBindingBuilder builder, List<String> userNames, List<String> groupNames) {
        builder.withSubjects(new ObjectReference[0]);
        if (userNames != null) {
            for (String userName : userNames) {
                String[] splitUserName;
                if (userName.startsWith("system:serviceaccount:") && (splitUserName = userName.split(":")).length == 4) {
                    ((OpenshiftRoleBindingFluent.SubjectsNested)((OpenshiftRoleBindingFluent.SubjectsNested)((OpenshiftRoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind("ServiceAccount")).withNamespace(splitUserName[2])).withName(splitUserName[3])).endSubject();
                    continue;
                }
                ((OpenshiftRoleBindingFluent.SubjectsNested)((OpenshiftRoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind("User")).withName(userName)).endSubject();
            }
        }
        if (groupNames != null) {
            for (String groupName : groupNames) {
                ((OpenshiftRoleBindingFluent.SubjectsNested)((OpenshiftRoleBindingFluent.SubjectsNested)builder.addNewSubject().withKind("Group")).withName(groupName)).endSubject();
            }
        }
    }

    private void enrichFromSubjects(OpenshiftRoleBindingBuilder builder, List<ObjectReference> subjects) {
        for (ObjectReference ref : subjects) {
            switch (ref.getKind()) {
                case "User": {
                    builder.addToUserNames(ref.getName());
                    break;
                }
                case "ServiceAccount": {
                    String namespace = ref.getNamespace();
                    if (namespace == null || namespace.isEmpty()) {
                        namespace = this.getNamespace();
                    }
                    builder.addToUserNames("system:serviceaccount:" + namespace + ":" + ref.getName());
                    break;
                }
                case "Group": {
                    builder.addToGroupNames(ref.getName());
                }
            }
        }
    }
}

