/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4.extensions;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.extensions.IngressTLS;
import io.fabric8.kubernetes.api.model.v4_4.extensions.IngressTLSFluent;
import io.fabric8.kubernetes.api.model.v4_4.extensions.IngressTLSFluentImpl;
import javax.validation.Validator;

public class IngressTLSBuilder
extends IngressTLSFluentImpl<IngressTLSBuilder>
implements VisitableBuilder<IngressTLS, IngressTLSBuilder> {
    IngressTLSFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public IngressTLSBuilder() {
        this(true);
    }

    public IngressTLSBuilder(Boolean validationEnabled) {
        this(new IngressTLS(), validationEnabled);
    }

    public IngressTLSBuilder(IngressTLSFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IngressTLSBuilder(IngressTLSFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IngressTLS(), validationEnabled);
    }

    public IngressTLSBuilder(IngressTLSFluent<?> fluent, IngressTLS instance) {
        this(fluent, instance, true);
    }

    public IngressTLSBuilder(IngressTLSFluent<?> fluent, IngressTLS instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHosts(instance.getHosts());
        fluent.withSecretName(instance.getSecretName());
        this.validationEnabled = validationEnabled;
    }

    public IngressTLSBuilder(IngressTLS instance) {
        this(instance, (Boolean)true);
    }

    public IngressTLSBuilder(IngressTLS instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHosts(instance.getHosts());
        this.withSecretName(instance.getSecretName());
        this.validationEnabled = validationEnabled;
    }

    public IngressTLSBuilder(Validator validator) {
        this(new IngressTLS(), (Boolean)true);
    }

    public IngressTLSBuilder(IngressTLSFluent<?> fluent, IngressTLS instance, Validator validator) {
        this.fluent = fluent;
        fluent.withHosts(instance.getHosts());
        fluent.withSecretName(instance.getSecretName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public IngressTLSBuilder(IngressTLS instance, Validator validator) {
        this.fluent = this;
        this.withHosts(instance.getHosts());
        this.withSecretName(instance.getSecretName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public IngressTLS build() {
        IngressTLS buildable = new IngressTLS(this.fluent.getHosts(), this.fluent.getSecretName());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressTLSBuilder that = (IngressTLSBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

