/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4.extensions;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.extensions.IngressSpec;
import io.fabric8.kubernetes.api.model.v4_4.extensions.IngressSpecFluent;
import io.fabric8.kubernetes.api.model.v4_4.extensions.IngressSpecFluentImpl;
import javax.validation.Validator;

public class IngressSpecBuilder
extends IngressSpecFluentImpl<IngressSpecBuilder>
implements VisitableBuilder<IngressSpec, IngressSpecBuilder> {
    IngressSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public IngressSpecBuilder() {
        this(true);
    }

    public IngressSpecBuilder(Boolean validationEnabled) {
        this(new IngressSpec(), validationEnabled);
    }

    public IngressSpecBuilder(IngressSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IngressSpecBuilder(IngressSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IngressSpec(), validationEnabled);
    }

    public IngressSpecBuilder(IngressSpecFluent<?> fluent, IngressSpec instance) {
        this(fluent, instance, true);
    }

    public IngressSpecBuilder(IngressSpecFluent<?> fluent, IngressSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBackend(instance.getBackend());
        fluent.withRules(instance.getRules());
        fluent.withTls(instance.getTls());
        this.validationEnabled = validationEnabled;
    }

    public IngressSpecBuilder(IngressSpec instance) {
        this(instance, (Boolean)true);
    }

    public IngressSpecBuilder(IngressSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBackend(instance.getBackend());
        this.withRules(instance.getRules());
        this.withTls(instance.getTls());
        this.validationEnabled = validationEnabled;
    }

    public IngressSpecBuilder(Validator validator) {
        this(new IngressSpec(), (Boolean)true);
    }

    public IngressSpecBuilder(IngressSpecFluent<?> fluent, IngressSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withBackend(instance.getBackend());
        fluent.withRules(instance.getRules());
        fluent.withTls(instance.getTls());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public IngressSpecBuilder(IngressSpec instance, Validator validator) {
        this.fluent = this;
        this.withBackend(instance.getBackend());
        this.withRules(instance.getRules());
        this.withTls(instance.getTls());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public IngressSpec build() {
        IngressSpec buildable = new IngressSpec(this.fluent.getBackend(), this.fluent.getRules(), this.fluent.getTls());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressSpecBuilder that = (IngressSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

