/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4.apps;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.apps.StatefulSetUpdateStrategy;
import io.fabric8.kubernetes.api.model.v4_4.apps.StatefulSetUpdateStrategyFluent;
import io.fabric8.kubernetes.api.model.v4_4.apps.StatefulSetUpdateStrategyFluentImpl;
import javax.validation.Validator;

public class StatefulSetUpdateStrategyBuilder
extends StatefulSetUpdateStrategyFluentImpl<StatefulSetUpdateStrategyBuilder>
implements VisitableBuilder<StatefulSetUpdateStrategy, StatefulSetUpdateStrategyBuilder> {
    StatefulSetUpdateStrategyFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StatefulSetUpdateStrategyBuilder() {
        this(true);
    }

    public StatefulSetUpdateStrategyBuilder(Boolean validationEnabled) {
        this(new StatefulSetUpdateStrategy(), validationEnabled);
    }

    public StatefulSetUpdateStrategyBuilder(StatefulSetUpdateStrategyFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StatefulSetUpdateStrategyBuilder(StatefulSetUpdateStrategyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StatefulSetUpdateStrategy(), validationEnabled);
    }

    public StatefulSetUpdateStrategyBuilder(StatefulSetUpdateStrategyFluent<?> fluent, StatefulSetUpdateStrategy instance) {
        this(fluent, instance, true);
    }

    public StatefulSetUpdateStrategyBuilder(StatefulSetUpdateStrategyFluent<?> fluent, StatefulSetUpdateStrategy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withRollingUpdate(instance.getRollingUpdate());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetUpdateStrategyBuilder(StatefulSetUpdateStrategy instance) {
        this(instance, (Boolean)true);
    }

    public StatefulSetUpdateStrategyBuilder(StatefulSetUpdateStrategy instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withRollingUpdate(instance.getRollingUpdate());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public StatefulSetUpdateStrategyBuilder(Validator validator) {
        this(new StatefulSetUpdateStrategy(), (Boolean)true);
    }

    public StatefulSetUpdateStrategyBuilder(StatefulSetUpdateStrategyFluent<?> fluent, StatefulSetUpdateStrategy instance, Validator validator) {
        this.fluent = fluent;
        fluent.withRollingUpdate(instance.getRollingUpdate());
        fluent.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public StatefulSetUpdateStrategyBuilder(StatefulSetUpdateStrategy instance, Validator validator) {
        this.fluent = this;
        this.withRollingUpdate(instance.getRollingUpdate());
        this.withType(instance.getType());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public StatefulSetUpdateStrategy build() {
        StatefulSetUpdateStrategy buildable = new StatefulSetUpdateStrategy(this.fluent.getRollingUpdate(), this.fluent.getType());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatefulSetUpdateStrategyBuilder that = (StatefulSetUpdateStrategyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

