/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.SessionAffinityConfig;
import io.fabric8.kubernetes.api.model.v4_4.SessionAffinityConfigFluent;
import io.fabric8.kubernetes.api.model.v4_4.SessionAffinityConfigFluentImpl;
import javax.validation.Validator;

public class SessionAffinityConfigBuilder
extends SessionAffinityConfigFluentImpl<SessionAffinityConfigBuilder>
implements VisitableBuilder<SessionAffinityConfig, SessionAffinityConfigBuilder> {
    SessionAffinityConfigFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SessionAffinityConfigBuilder() {
        this(true);
    }

    public SessionAffinityConfigBuilder(Boolean validationEnabled) {
        this(new SessionAffinityConfig(), validationEnabled);
    }

    public SessionAffinityConfigBuilder(SessionAffinityConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SessionAffinityConfigBuilder(SessionAffinityConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SessionAffinityConfig(), validationEnabled);
    }

    public SessionAffinityConfigBuilder(SessionAffinityConfigFluent<?> fluent, SessionAffinityConfig instance) {
        this(fluent, instance, true);
    }

    public SessionAffinityConfigBuilder(SessionAffinityConfigFluent<?> fluent, SessionAffinityConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withClientIP(instance.getClientIP());
        this.validationEnabled = validationEnabled;
    }

    public SessionAffinityConfigBuilder(SessionAffinityConfig instance) {
        this(instance, (Boolean)true);
    }

    public SessionAffinityConfigBuilder(SessionAffinityConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withClientIP(instance.getClientIP());
        this.validationEnabled = validationEnabled;
    }

    public SessionAffinityConfigBuilder(Validator validator) {
        this(new SessionAffinityConfig(), (Boolean)true);
    }

    public SessionAffinityConfigBuilder(SessionAffinityConfigFluent<?> fluent, SessionAffinityConfig instance, Validator validator) {
        this.fluent = fluent;
        fluent.withClientIP(instance.getClientIP());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public SessionAffinityConfigBuilder(SessionAffinityConfig instance, Validator validator) {
        this.fluent = this;
        this.withClientIP(instance.getClientIP());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public SessionAffinityConfig build() {
        SessionAffinityConfig buildable = new SessionAffinityConfig(this.fluent.getClientIP());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SessionAffinityConfigBuilder that = (SessionAffinityConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

