/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.NodeSpec;
import io.fabric8.kubernetes.api.model.v4_4.NodeSpecFluent;
import io.fabric8.kubernetes.api.model.v4_4.NodeSpecFluentImpl;
import javax.validation.Validator;

public class NodeSpecBuilder
extends NodeSpecFluentImpl<NodeSpecBuilder>
implements VisitableBuilder<NodeSpec, NodeSpecBuilder> {
    NodeSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NodeSpecBuilder() {
        this(true);
    }

    public NodeSpecBuilder(Boolean validationEnabled) {
        this(new NodeSpec(), validationEnabled);
    }

    public NodeSpecBuilder(NodeSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NodeSpecBuilder(NodeSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeSpec(), validationEnabled);
    }

    public NodeSpecBuilder(NodeSpecFluent<?> fluent, NodeSpec instance) {
        this(fluent, instance, true);
    }

    public NodeSpecBuilder(NodeSpecFluent<?> fluent, NodeSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConfigSource(instance.getConfigSource());
        fluent.withExternalID(instance.getExternalID());
        fluent.withPodCIDR(instance.getPodCIDR());
        fluent.withProviderID(instance.getProviderID());
        fluent.withTaints(instance.getTaints());
        fluent.withUnschedulable(instance.getUnschedulable());
        this.validationEnabled = validationEnabled;
    }

    public NodeSpecBuilder(NodeSpec instance) {
        this(instance, (Boolean)true);
    }

    public NodeSpecBuilder(NodeSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConfigSource(instance.getConfigSource());
        this.withExternalID(instance.getExternalID());
        this.withPodCIDR(instance.getPodCIDR());
        this.withProviderID(instance.getProviderID());
        this.withTaints(instance.getTaints());
        this.withUnschedulable(instance.getUnschedulable());
        this.validationEnabled = validationEnabled;
    }

    public NodeSpecBuilder(Validator validator) {
        this(new NodeSpec(), (Boolean)true);
    }

    public NodeSpecBuilder(NodeSpecFluent<?> fluent, NodeSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withConfigSource(instance.getConfigSource());
        fluent.withExternalID(instance.getExternalID());
        fluent.withPodCIDR(instance.getPodCIDR());
        fluent.withProviderID(instance.getProviderID());
        fluent.withTaints(instance.getTaints());
        fluent.withUnschedulable(instance.getUnschedulable());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NodeSpecBuilder(NodeSpec instance, Validator validator) {
        this.fluent = this;
        this.withConfigSource(instance.getConfigSource());
        this.withExternalID(instance.getExternalID());
        this.withPodCIDR(instance.getPodCIDR());
        this.withProviderID(instance.getProviderID());
        this.withTaints(instance.getTaints());
        this.withUnschedulable(instance.getUnschedulable());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NodeSpec build() {
        NodeSpec buildable = new NodeSpec(this.fluent.getConfigSource(), this.fluent.getExternalID(), this.fluent.getPodCIDR(), this.fluent.getProviderID(), this.fluent.getTaints(), this.fluent.isUnschedulable());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSpecBuilder that = (NodeSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

