/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.KubeSchema;
import io.fabric8.kubernetes.api.model.v4_4.KubeSchemaFluent;
import io.fabric8.kubernetes.api.model.v4_4.KubeSchemaFluentImpl;
import javax.validation.Validator;

public class KubeSchemaBuilder
extends KubeSchemaFluentImpl<KubeSchemaBuilder>
implements VisitableBuilder<KubeSchema, KubeSchemaBuilder> {
    KubeSchemaFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public KubeSchemaBuilder() {
        this(true);
    }

    public KubeSchemaBuilder(Boolean validationEnabled) {
        this(new KubeSchema(), validationEnabled);
    }

    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KubeSchema(), validationEnabled);
    }

    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent, KubeSchema instance) {
        this(fluent, instance, true);
    }

    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent, KubeSchema instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAPIGroup(instance.getAPIGroup());
        fluent.withAPIGroupList(instance.getAPIGroupList());
        fluent.withAdmissionRequest(instance.getAdmissionRequest());
        fluent.withAdmissionResponse(instance.getAdmissionResponse());
        fluent.withAdmissionReview(instance.getAdmissionReview());
        fluent.withAdmissionWebhook(instance.getAdmissionWebhook());
        fluent.withAggregationRule(instance.getAggregationRule());
        fluent.withBaseKubernetesList(instance.getBaseKubernetesList());
        fluent.withBinding(instance.getBinding());
        fluent.withBuildConfigList(instance.getBuildConfigList());
        fluent.withBuildList(instance.getBuildList());
        fluent.withBuildRequest(instance.getBuildRequest());
        fluent.withCertificateSigningRequest(instance.getCertificateSigningRequest());
        fluent.withCertificateSigningRequestCondition(instance.getCertificateSigningRequestCondition());
        fluent.withCertificateSigningRequestList(instance.getCertificateSigningRequestList());
        fluent.withCertificateSigningRequestSpec(instance.getCertificateSigningRequestSpec());
        fluent.withCertificateSigningRequestStatus(instance.getCertificateSigningRequestStatus());
        fluent.withClusterRole(instance.getClusterRole());
        fluent.withClusterRoleBinding(instance.getClusterRoleBinding());
        fluent.withClusterRoleBindingList(instance.getClusterRoleBindingList());
        fluent.withClusterRoleList(instance.getClusterRoleList());
        fluent.withComponentStatusList(instance.getComponentStatusList());
        fluent.withConfig(instance.getConfig());
        fluent.withConfigMap(instance.getConfigMap());
        fluent.withConfigMapList(instance.getConfigMapList());
        fluent.withContainerStatus(instance.getContainerStatus());
        fluent.withCronJob(instance.getCronJob());
        fluent.withCronJobList(instance.getCronJobList());
        fluent.withCustomResourceDefinition(instance.getCustomResourceDefinition());
        fluent.withCustomResourceDefinitionCondition(instance.getCustomResourceDefinitionCondition());
        fluent.withCustomResourceDefinitionList(instance.getCustomResourceDefinitionList());
        fluent.withCustomResourceDefinitionNames(instance.getCustomResourceDefinitionNames());
        fluent.withCustomResourceDefinitionSpec(instance.getCustomResourceDefinitionSpec());
        fluent.withCustomResourceDefinitionStatus(instance.getCustomResourceDefinitionStatus());
        fluent.withDaemonSet(instance.getDaemonSet());
        fluent.withDaemonSetList(instance.getDaemonSetList());
        fluent.withDeleteOptions(instance.getDeleteOptions());
        fluent.withDeployment(instance.getDeployment());
        fluent.withDeploymentConfig(instance.getDeploymentConfig());
        fluent.withDeploymentConfigList(instance.getDeploymentConfigList());
        fluent.withDeploymentList(instance.getDeploymentList());
        fluent.withDeploymentRollback(instance.getDeploymentRollback());
        fluent.withEndpoints(instance.getEndpoints());
        fluent.withEndpointsList(instance.getEndpointsList());
        fluent.withEnvVar(instance.getEnvVar());
        fluent.withEvent(instance.getEvent());
        fluent.withEventList(instance.getEventList());
        fluent.withEventSeries(instance.getEventSeries());
        fluent.withEventSeriesState(instance.getEventSeriesState());
        fluent.withGroup(instance.getGroup());
        fluent.withGroupList(instance.getGroupList());
        fluent.withHorizontalPodAutoscaler(instance.getHorizontalPodAutoscaler());
        fluent.withHorizontalPodAutoscalerList(instance.getHorizontalPodAutoscalerList());
        fluent.withIdentity(instance.getIdentity());
        fluent.withIdentityList(instance.getIdentityList());
        fluent.withImageList(instance.getImageList());
        fluent.withImageStreamImport(instance.getImageStreamImport());
        fluent.withImageStreamList(instance.getImageStreamList());
        fluent.withImageStreamTagList(instance.getImageStreamTagList());
        fluent.withInfo(instance.getInfo());
        fluent.withIngress(instance.getIngress());
        fluent.withIngressList(instance.getIngressList());
        fluent.withInitializer(instance.getInitializer());
        fluent.withInitializers(instance.getInitializers());
        fluent.withJSONSchemaPropsorStringArray(instance.getJSONSchemaPropsorStringArray());
        fluent.withJob(instance.getJob());
        fluent.withJobList(instance.getJobList());
        fluent.withK8sLocalSubjectAccessReview(instance.getK8sLocalSubjectAccessReview());
        fluent.withK8sSubjectAccessReview(instance.getK8sSubjectAccessReview());
        fluent.withLimitRangeList(instance.getLimitRangeList());
        fluent.withLocalSubjectAccessReview(instance.getLocalSubjectAccessReview());
        fluent.withMutatingWebhookConfiguration(instance.getMutatingWebhookConfiguration());
        fluent.withMutatingWebhookConfigurationList(instance.getMutatingWebhookConfigurationList());
        fluent.withNamespace(instance.getNamespace());
        fluent.withNamespaceList(instance.getNamespaceList());
        fluent.withNetNameSpace(instance.getNetNameSpace());
        fluent.withNetNameSpaceList(instance.getNetNameSpaceList());
        fluent.withNetworkPolicy(instance.getNetworkPolicy());
        fluent.withNetworkPolicyList(instance.getNetworkPolicyList());
        fluent.withNode(instance.getNode());
        fluent.withNodeList(instance.getNodeList());
        fluent.withOAuthAccessToken(instance.getOAuthAccessToken());
        fluent.withOAuthAccessTokenList(instance.getOAuthAccessTokenList());
        fluent.withOAuthAuthorizeToken(instance.getOAuthAuthorizeToken());
        fluent.withOAuthAuthorizeTokenList(instance.getOAuthAuthorizeTokenList());
        fluent.withOAuthClient(instance.getOAuthClient());
        fluent.withOAuthClientAuthorization(instance.getOAuthClientAuthorization());
        fluent.withOAuthClientAuthorizationList(instance.getOAuthClientAuthorizationList());
        fluent.withOAuthClientList(instance.getOAuthClientList());
        fluent.withObjectMeta(instance.getObjectMeta());
        fluent.withOpenshiftClusterRole(instance.getOpenshiftClusterRole());
        fluent.withOpenshiftClusterRoleBinding(instance.getOpenshiftClusterRoleBinding());
        fluent.withOpenshiftClusterRoleBindingList(instance.getOpenshiftClusterRoleBindingList());
        fluent.withOpenshiftRole(instance.getOpenshiftRole());
        fluent.withOpenshiftRoleBinding(instance.getOpenshiftRoleBinding());
        fluent.withOpenshiftRoleBindingList(instance.getOpenshiftRoleBindingList());
        fluent.withOpenshiftRoleBindingRestriction(instance.getOpenshiftRoleBindingRestriction());
        fluent.withOpenshiftRoleList(instance.getOpenshiftRoleList());
        fluent.withOperation(instance.getOperation());
        fluent.withPatch(instance.getPatch());
        fluent.withPatchType(instance.getPatchType());
        fluent.withPersistentVolume(instance.getPersistentVolume());
        fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        fluent.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList());
        fluent.withPersistentVolumeList(instance.getPersistentVolumeList());
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        fluent.withPodDisruptionBudgetList(instance.getPodDisruptionBudgetList());
        fluent.withPodList(instance.getPodList());
        fluent.withPodPreset(instance.getPodPreset());
        fluent.withPodPresetList(instance.getPodPresetList());
        fluent.withPodPresetSpec(instance.getPodPresetSpec());
        fluent.withPodSecurityPolicy(instance.getPodSecurityPolicy());
        fluent.withPodSecurityPolicyList(instance.getPodSecurityPolicyList());
        fluent.withPodTemplateList(instance.getPodTemplateList());
        fluent.withPriorityClass(instance.getPriorityClass());
        fluent.withPriorityClassList(instance.getPriorityClassList());
        fluent.withProject(instance.getProject());
        fluent.withProjectList(instance.getProjectList());
        fluent.withProjectRequest(instance.getProjectRequest());
        fluent.withQuantity(instance.getQuantity());
        fluent.withReplicaSet(instance.getReplicaSet());
        fluent.withReplicaSetList(instance.getReplicaSetList());
        fluent.withReplicationControllerList(instance.getReplicationControllerList());
        fluent.withResourceQuota(instance.getResourceQuota());
        fluent.withResourceQuotaList(instance.getResourceQuotaList());
        fluent.withRole(instance.getRole());
        fluent.withRoleBinding(instance.getRoleBinding());
        fluent.withRoleBindingList(instance.getRoleBindingList());
        fluent.withRoleList(instance.getRoleList());
        fluent.withRootPaths(instance.getRootPaths());
        fluent.withRoute(instance.getRoute());
        fluent.withRouteList(instance.getRouteList());
        fluent.withRule(instance.getRule());
        fluent.withRuleWithOperations(instance.getRuleWithOperations());
        fluent.withScale(instance.getScale());
        fluent.withSecret(instance.getSecret());
        fluent.withSecretList(instance.getSecretList());
        fluent.withSecurityContextConstraints(instance.getSecurityContextConstraints());
        fluent.withSecurityContextConstraintsList(instance.getSecurityContextConstraintsList());
        fluent.withSelfSubjectAccessReview(instance.getSelfSubjectAccessReview());
        fluent.withSelfSubjectRulesReview(instance.getSelfSubjectRulesReview());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withServiceAccountList(instance.getServiceAccountList());
        fluent.withServiceList(instance.getServiceList());
        fluent.withStatefulSet(instance.getStatefulSet());
        fluent.withStatefulSetList(instance.getStatefulSetList());
        fluent.withStatus(instance.getStatus());
        fluent.withStorageClass(instance.getStorageClass());
        fluent.withStorageClassList(instance.getStorageClassList());
        fluent.withSubjectAccessReview(instance.getSubjectAccessReview());
        fluent.withSubjectAccessReviewResponse(instance.getSubjectAccessReviewResponse());
        fluent.withTagEvent(instance.getTagEvent());
        fluent.withTemplate(instance.getTemplate());
        fluent.withTemplateList(instance.getTemplateList());
        fluent.withTokenReview(instance.getTokenReview());
        fluent.withToleration(instance.getToleration());
        fluent.withTypeMeta(instance.getTypeMeta());
        fluent.withUser(instance.getUser());
        fluent.withUserList(instance.getUserList());
        fluent.withValidatingWebhookConfiguration(instance.getValidatingWebhookConfiguration());
        fluent.withValidatingWebhookConfigurationList(instance.getValidatingWebhookConfigurationList());
        fluent.withWatchEvent(instance.getWatchEvent());
        this.validationEnabled = validationEnabled;
    }

    public KubeSchemaBuilder(KubeSchema instance) {
        this(instance, (Boolean)true);
    }

    public KubeSchemaBuilder(KubeSchema instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAPIGroup(instance.getAPIGroup());
        this.withAPIGroupList(instance.getAPIGroupList());
        this.withAdmissionRequest(instance.getAdmissionRequest());
        this.withAdmissionResponse(instance.getAdmissionResponse());
        this.withAdmissionReview(instance.getAdmissionReview());
        this.withAdmissionWebhook(instance.getAdmissionWebhook());
        this.withAggregationRule(instance.getAggregationRule());
        this.withBaseKubernetesList(instance.getBaseKubernetesList());
        this.withBinding(instance.getBinding());
        this.withBuildConfigList(instance.getBuildConfigList());
        this.withBuildList(instance.getBuildList());
        this.withBuildRequest(instance.getBuildRequest());
        this.withCertificateSigningRequest(instance.getCertificateSigningRequest());
        this.withCertificateSigningRequestCondition(instance.getCertificateSigningRequestCondition());
        this.withCertificateSigningRequestList(instance.getCertificateSigningRequestList());
        this.withCertificateSigningRequestSpec(instance.getCertificateSigningRequestSpec());
        this.withCertificateSigningRequestStatus(instance.getCertificateSigningRequestStatus());
        this.withClusterRole(instance.getClusterRole());
        this.withClusterRoleBinding(instance.getClusterRoleBinding());
        this.withClusterRoleBindingList(instance.getClusterRoleBindingList());
        this.withClusterRoleList(instance.getClusterRoleList());
        this.withComponentStatusList(instance.getComponentStatusList());
        this.withConfig(instance.getConfig());
        this.withConfigMap(instance.getConfigMap());
        this.withConfigMapList(instance.getConfigMapList());
        this.withContainerStatus(instance.getContainerStatus());
        this.withCronJob(instance.getCronJob());
        this.withCronJobList(instance.getCronJobList());
        this.withCustomResourceDefinition(instance.getCustomResourceDefinition());
        this.withCustomResourceDefinitionCondition(instance.getCustomResourceDefinitionCondition());
        this.withCustomResourceDefinitionList(instance.getCustomResourceDefinitionList());
        this.withCustomResourceDefinitionNames(instance.getCustomResourceDefinitionNames());
        this.withCustomResourceDefinitionSpec(instance.getCustomResourceDefinitionSpec());
        this.withCustomResourceDefinitionStatus(instance.getCustomResourceDefinitionStatus());
        this.withDaemonSet(instance.getDaemonSet());
        this.withDaemonSetList(instance.getDaemonSetList());
        this.withDeleteOptions(instance.getDeleteOptions());
        this.withDeployment(instance.getDeployment());
        this.withDeploymentConfig(instance.getDeploymentConfig());
        this.withDeploymentConfigList(instance.getDeploymentConfigList());
        this.withDeploymentList(instance.getDeploymentList());
        this.withDeploymentRollback(instance.getDeploymentRollback());
        this.withEndpoints(instance.getEndpoints());
        this.withEndpointsList(instance.getEndpointsList());
        this.withEnvVar(instance.getEnvVar());
        this.withEvent(instance.getEvent());
        this.withEventList(instance.getEventList());
        this.withEventSeries(instance.getEventSeries());
        this.withEventSeriesState(instance.getEventSeriesState());
        this.withGroup(instance.getGroup());
        this.withGroupList(instance.getGroupList());
        this.withHorizontalPodAutoscaler(instance.getHorizontalPodAutoscaler());
        this.withHorizontalPodAutoscalerList(instance.getHorizontalPodAutoscalerList());
        this.withIdentity(instance.getIdentity());
        this.withIdentityList(instance.getIdentityList());
        this.withImageList(instance.getImageList());
        this.withImageStreamImport(instance.getImageStreamImport());
        this.withImageStreamList(instance.getImageStreamList());
        this.withImageStreamTagList(instance.getImageStreamTagList());
        this.withInfo(instance.getInfo());
        this.withIngress(instance.getIngress());
        this.withIngressList(instance.getIngressList());
        this.withInitializer(instance.getInitializer());
        this.withInitializers(instance.getInitializers());
        this.withJSONSchemaPropsorStringArray(instance.getJSONSchemaPropsorStringArray());
        this.withJob(instance.getJob());
        this.withJobList(instance.getJobList());
        this.withK8sLocalSubjectAccessReview(instance.getK8sLocalSubjectAccessReview());
        this.withK8sSubjectAccessReview(instance.getK8sSubjectAccessReview());
        this.withLimitRangeList(instance.getLimitRangeList());
        this.withLocalSubjectAccessReview(instance.getLocalSubjectAccessReview());
        this.withMutatingWebhookConfiguration(instance.getMutatingWebhookConfiguration());
        this.withMutatingWebhookConfigurationList(instance.getMutatingWebhookConfigurationList());
        this.withNamespace(instance.getNamespace());
        this.withNamespaceList(instance.getNamespaceList());
        this.withNetNameSpace(instance.getNetNameSpace());
        this.withNetNameSpaceList(instance.getNetNameSpaceList());
        this.withNetworkPolicy(instance.getNetworkPolicy());
        this.withNetworkPolicyList(instance.getNetworkPolicyList());
        this.withNode(instance.getNode());
        this.withNodeList(instance.getNodeList());
        this.withOAuthAccessToken(instance.getOAuthAccessToken());
        this.withOAuthAccessTokenList(instance.getOAuthAccessTokenList());
        this.withOAuthAuthorizeToken(instance.getOAuthAuthorizeToken());
        this.withOAuthAuthorizeTokenList(instance.getOAuthAuthorizeTokenList());
        this.withOAuthClient(instance.getOAuthClient());
        this.withOAuthClientAuthorization(instance.getOAuthClientAuthorization());
        this.withOAuthClientAuthorizationList(instance.getOAuthClientAuthorizationList());
        this.withOAuthClientList(instance.getOAuthClientList());
        this.withObjectMeta(instance.getObjectMeta());
        this.withOpenshiftClusterRole(instance.getOpenshiftClusterRole());
        this.withOpenshiftClusterRoleBinding(instance.getOpenshiftClusterRoleBinding());
        this.withOpenshiftClusterRoleBindingList(instance.getOpenshiftClusterRoleBindingList());
        this.withOpenshiftRole(instance.getOpenshiftRole());
        this.withOpenshiftRoleBinding(instance.getOpenshiftRoleBinding());
        this.withOpenshiftRoleBindingList(instance.getOpenshiftRoleBindingList());
        this.withOpenshiftRoleBindingRestriction(instance.getOpenshiftRoleBindingRestriction());
        this.withOpenshiftRoleList(instance.getOpenshiftRoleList());
        this.withOperation(instance.getOperation());
        this.withPatch(instance.getPatch());
        this.withPatchType(instance.getPatchType());
        this.withPersistentVolume(instance.getPersistentVolume());
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        this.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList());
        this.withPersistentVolumeList(instance.getPersistentVolumeList());
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        this.withPodDisruptionBudgetList(instance.getPodDisruptionBudgetList());
        this.withPodList(instance.getPodList());
        this.withPodPreset(instance.getPodPreset());
        this.withPodPresetList(instance.getPodPresetList());
        this.withPodPresetSpec(instance.getPodPresetSpec());
        this.withPodSecurityPolicy(instance.getPodSecurityPolicy());
        this.withPodSecurityPolicyList(instance.getPodSecurityPolicyList());
        this.withPodTemplateList(instance.getPodTemplateList());
        this.withPriorityClass(instance.getPriorityClass());
        this.withPriorityClassList(instance.getPriorityClassList());
        this.withProject(instance.getProject());
        this.withProjectList(instance.getProjectList());
        this.withProjectRequest(instance.getProjectRequest());
        this.withQuantity(instance.getQuantity());
        this.withReplicaSet(instance.getReplicaSet());
        this.withReplicaSetList(instance.getReplicaSetList());
        this.withReplicationControllerList(instance.getReplicationControllerList());
        this.withResourceQuota(instance.getResourceQuota());
        this.withResourceQuotaList(instance.getResourceQuotaList());
        this.withRole(instance.getRole());
        this.withRoleBinding(instance.getRoleBinding());
        this.withRoleBindingList(instance.getRoleBindingList());
        this.withRoleList(instance.getRoleList());
        this.withRootPaths(instance.getRootPaths());
        this.withRoute(instance.getRoute());
        this.withRouteList(instance.getRouteList());
        this.withRule(instance.getRule());
        this.withRuleWithOperations(instance.getRuleWithOperations());
        this.withScale(instance.getScale());
        this.withSecret(instance.getSecret());
        this.withSecretList(instance.getSecretList());
        this.withSecurityContextConstraints(instance.getSecurityContextConstraints());
        this.withSecurityContextConstraintsList(instance.getSecurityContextConstraintsList());
        this.withSelfSubjectAccessReview(instance.getSelfSubjectAccessReview());
        this.withSelfSubjectRulesReview(instance.getSelfSubjectRulesReview());
        this.withServiceAccount(instance.getServiceAccount());
        this.withServiceAccountList(instance.getServiceAccountList());
        this.withServiceList(instance.getServiceList());
        this.withStatefulSet(instance.getStatefulSet());
        this.withStatefulSetList(instance.getStatefulSetList());
        this.withStatus(instance.getStatus());
        this.withStorageClass(instance.getStorageClass());
        this.withStorageClassList(instance.getStorageClassList());
        this.withSubjectAccessReview(instance.getSubjectAccessReview());
        this.withSubjectAccessReviewResponse(instance.getSubjectAccessReviewResponse());
        this.withTagEvent(instance.getTagEvent());
        this.withTemplate(instance.getTemplate());
        this.withTemplateList(instance.getTemplateList());
        this.withTokenReview(instance.getTokenReview());
        this.withToleration(instance.getToleration());
        this.withTypeMeta(instance.getTypeMeta());
        this.withUser(instance.getUser());
        this.withUserList(instance.getUserList());
        this.withValidatingWebhookConfiguration(instance.getValidatingWebhookConfiguration());
        this.withValidatingWebhookConfigurationList(instance.getValidatingWebhookConfigurationList());
        this.withWatchEvent(instance.getWatchEvent());
        this.validationEnabled = validationEnabled;
    }

    public KubeSchemaBuilder(Validator validator) {
        this(new KubeSchema(), (Boolean)true);
    }

    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent, KubeSchema instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAPIGroup(instance.getAPIGroup());
        fluent.withAPIGroupList(instance.getAPIGroupList());
        fluent.withAdmissionRequest(instance.getAdmissionRequest());
        fluent.withAdmissionResponse(instance.getAdmissionResponse());
        fluent.withAdmissionReview(instance.getAdmissionReview());
        fluent.withAdmissionWebhook(instance.getAdmissionWebhook());
        fluent.withAggregationRule(instance.getAggregationRule());
        fluent.withBaseKubernetesList(instance.getBaseKubernetesList());
        fluent.withBinding(instance.getBinding());
        fluent.withBuildConfigList(instance.getBuildConfigList());
        fluent.withBuildList(instance.getBuildList());
        fluent.withBuildRequest(instance.getBuildRequest());
        fluent.withCertificateSigningRequest(instance.getCertificateSigningRequest());
        fluent.withCertificateSigningRequestCondition(instance.getCertificateSigningRequestCondition());
        fluent.withCertificateSigningRequestList(instance.getCertificateSigningRequestList());
        fluent.withCertificateSigningRequestSpec(instance.getCertificateSigningRequestSpec());
        fluent.withCertificateSigningRequestStatus(instance.getCertificateSigningRequestStatus());
        fluent.withClusterRole(instance.getClusterRole());
        fluent.withClusterRoleBinding(instance.getClusterRoleBinding());
        fluent.withClusterRoleBindingList(instance.getClusterRoleBindingList());
        fluent.withClusterRoleList(instance.getClusterRoleList());
        fluent.withComponentStatusList(instance.getComponentStatusList());
        fluent.withConfig(instance.getConfig());
        fluent.withConfigMap(instance.getConfigMap());
        fluent.withConfigMapList(instance.getConfigMapList());
        fluent.withContainerStatus(instance.getContainerStatus());
        fluent.withCronJob(instance.getCronJob());
        fluent.withCronJobList(instance.getCronJobList());
        fluent.withCustomResourceDefinition(instance.getCustomResourceDefinition());
        fluent.withCustomResourceDefinitionCondition(instance.getCustomResourceDefinitionCondition());
        fluent.withCustomResourceDefinitionList(instance.getCustomResourceDefinitionList());
        fluent.withCustomResourceDefinitionNames(instance.getCustomResourceDefinitionNames());
        fluent.withCustomResourceDefinitionSpec(instance.getCustomResourceDefinitionSpec());
        fluent.withCustomResourceDefinitionStatus(instance.getCustomResourceDefinitionStatus());
        fluent.withDaemonSet(instance.getDaemonSet());
        fluent.withDaemonSetList(instance.getDaemonSetList());
        fluent.withDeleteOptions(instance.getDeleteOptions());
        fluent.withDeployment(instance.getDeployment());
        fluent.withDeploymentConfig(instance.getDeploymentConfig());
        fluent.withDeploymentConfigList(instance.getDeploymentConfigList());
        fluent.withDeploymentList(instance.getDeploymentList());
        fluent.withDeploymentRollback(instance.getDeploymentRollback());
        fluent.withEndpoints(instance.getEndpoints());
        fluent.withEndpointsList(instance.getEndpointsList());
        fluent.withEnvVar(instance.getEnvVar());
        fluent.withEvent(instance.getEvent());
        fluent.withEventList(instance.getEventList());
        fluent.withEventSeries(instance.getEventSeries());
        fluent.withEventSeriesState(instance.getEventSeriesState());
        fluent.withGroup(instance.getGroup());
        fluent.withGroupList(instance.getGroupList());
        fluent.withHorizontalPodAutoscaler(instance.getHorizontalPodAutoscaler());
        fluent.withHorizontalPodAutoscalerList(instance.getHorizontalPodAutoscalerList());
        fluent.withIdentity(instance.getIdentity());
        fluent.withIdentityList(instance.getIdentityList());
        fluent.withImageList(instance.getImageList());
        fluent.withImageStreamImport(instance.getImageStreamImport());
        fluent.withImageStreamList(instance.getImageStreamList());
        fluent.withImageStreamTagList(instance.getImageStreamTagList());
        fluent.withInfo(instance.getInfo());
        fluent.withIngress(instance.getIngress());
        fluent.withIngressList(instance.getIngressList());
        fluent.withInitializer(instance.getInitializer());
        fluent.withInitializers(instance.getInitializers());
        fluent.withJSONSchemaPropsorStringArray(instance.getJSONSchemaPropsorStringArray());
        fluent.withJob(instance.getJob());
        fluent.withJobList(instance.getJobList());
        fluent.withK8sLocalSubjectAccessReview(instance.getK8sLocalSubjectAccessReview());
        fluent.withK8sSubjectAccessReview(instance.getK8sSubjectAccessReview());
        fluent.withLimitRangeList(instance.getLimitRangeList());
        fluent.withLocalSubjectAccessReview(instance.getLocalSubjectAccessReview());
        fluent.withMutatingWebhookConfiguration(instance.getMutatingWebhookConfiguration());
        fluent.withMutatingWebhookConfigurationList(instance.getMutatingWebhookConfigurationList());
        fluent.withNamespace(instance.getNamespace());
        fluent.withNamespaceList(instance.getNamespaceList());
        fluent.withNetNameSpace(instance.getNetNameSpace());
        fluent.withNetNameSpaceList(instance.getNetNameSpaceList());
        fluent.withNetworkPolicy(instance.getNetworkPolicy());
        fluent.withNetworkPolicyList(instance.getNetworkPolicyList());
        fluent.withNode(instance.getNode());
        fluent.withNodeList(instance.getNodeList());
        fluent.withOAuthAccessToken(instance.getOAuthAccessToken());
        fluent.withOAuthAccessTokenList(instance.getOAuthAccessTokenList());
        fluent.withOAuthAuthorizeToken(instance.getOAuthAuthorizeToken());
        fluent.withOAuthAuthorizeTokenList(instance.getOAuthAuthorizeTokenList());
        fluent.withOAuthClient(instance.getOAuthClient());
        fluent.withOAuthClientAuthorization(instance.getOAuthClientAuthorization());
        fluent.withOAuthClientAuthorizationList(instance.getOAuthClientAuthorizationList());
        fluent.withOAuthClientList(instance.getOAuthClientList());
        fluent.withObjectMeta(instance.getObjectMeta());
        fluent.withOpenshiftClusterRole(instance.getOpenshiftClusterRole());
        fluent.withOpenshiftClusterRoleBinding(instance.getOpenshiftClusterRoleBinding());
        fluent.withOpenshiftClusterRoleBindingList(instance.getOpenshiftClusterRoleBindingList());
        fluent.withOpenshiftRole(instance.getOpenshiftRole());
        fluent.withOpenshiftRoleBinding(instance.getOpenshiftRoleBinding());
        fluent.withOpenshiftRoleBindingList(instance.getOpenshiftRoleBindingList());
        fluent.withOpenshiftRoleBindingRestriction(instance.getOpenshiftRoleBindingRestriction());
        fluent.withOpenshiftRoleList(instance.getOpenshiftRoleList());
        fluent.withOperation(instance.getOperation());
        fluent.withPatch(instance.getPatch());
        fluent.withPatchType(instance.getPatchType());
        fluent.withPersistentVolume(instance.getPersistentVolume());
        fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        fluent.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList());
        fluent.withPersistentVolumeList(instance.getPersistentVolumeList());
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        fluent.withPodDisruptionBudgetList(instance.getPodDisruptionBudgetList());
        fluent.withPodList(instance.getPodList());
        fluent.withPodPreset(instance.getPodPreset());
        fluent.withPodPresetList(instance.getPodPresetList());
        fluent.withPodPresetSpec(instance.getPodPresetSpec());
        fluent.withPodSecurityPolicy(instance.getPodSecurityPolicy());
        fluent.withPodSecurityPolicyList(instance.getPodSecurityPolicyList());
        fluent.withPodTemplateList(instance.getPodTemplateList());
        fluent.withPriorityClass(instance.getPriorityClass());
        fluent.withPriorityClassList(instance.getPriorityClassList());
        fluent.withProject(instance.getProject());
        fluent.withProjectList(instance.getProjectList());
        fluent.withProjectRequest(instance.getProjectRequest());
        fluent.withQuantity(instance.getQuantity());
        fluent.withReplicaSet(instance.getReplicaSet());
        fluent.withReplicaSetList(instance.getReplicaSetList());
        fluent.withReplicationControllerList(instance.getReplicationControllerList());
        fluent.withResourceQuota(instance.getResourceQuota());
        fluent.withResourceQuotaList(instance.getResourceQuotaList());
        fluent.withRole(instance.getRole());
        fluent.withRoleBinding(instance.getRoleBinding());
        fluent.withRoleBindingList(instance.getRoleBindingList());
        fluent.withRoleList(instance.getRoleList());
        fluent.withRootPaths(instance.getRootPaths());
        fluent.withRoute(instance.getRoute());
        fluent.withRouteList(instance.getRouteList());
        fluent.withRule(instance.getRule());
        fluent.withRuleWithOperations(instance.getRuleWithOperations());
        fluent.withScale(instance.getScale());
        fluent.withSecret(instance.getSecret());
        fluent.withSecretList(instance.getSecretList());
        fluent.withSecurityContextConstraints(instance.getSecurityContextConstraints());
        fluent.withSecurityContextConstraintsList(instance.getSecurityContextConstraintsList());
        fluent.withSelfSubjectAccessReview(instance.getSelfSubjectAccessReview());
        fluent.withSelfSubjectRulesReview(instance.getSelfSubjectRulesReview());
        fluent.withServiceAccount(instance.getServiceAccount());
        fluent.withServiceAccountList(instance.getServiceAccountList());
        fluent.withServiceList(instance.getServiceList());
        fluent.withStatefulSet(instance.getStatefulSet());
        fluent.withStatefulSetList(instance.getStatefulSetList());
        fluent.withStatus(instance.getStatus());
        fluent.withStorageClass(instance.getStorageClass());
        fluent.withStorageClassList(instance.getStorageClassList());
        fluent.withSubjectAccessReview(instance.getSubjectAccessReview());
        fluent.withSubjectAccessReviewResponse(instance.getSubjectAccessReviewResponse());
        fluent.withTagEvent(instance.getTagEvent());
        fluent.withTemplate(instance.getTemplate());
        fluent.withTemplateList(instance.getTemplateList());
        fluent.withTokenReview(instance.getTokenReview());
        fluent.withToleration(instance.getToleration());
        fluent.withTypeMeta(instance.getTypeMeta());
        fluent.withUser(instance.getUser());
        fluent.withUserList(instance.getUserList());
        fluent.withValidatingWebhookConfiguration(instance.getValidatingWebhookConfiguration());
        fluent.withValidatingWebhookConfigurationList(instance.getValidatingWebhookConfigurationList());
        fluent.withWatchEvent(instance.getWatchEvent());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public KubeSchemaBuilder(KubeSchema instance, Validator validator) {
        this.fluent = this;
        this.withAPIGroup(instance.getAPIGroup());
        this.withAPIGroupList(instance.getAPIGroupList());
        this.withAdmissionRequest(instance.getAdmissionRequest());
        this.withAdmissionResponse(instance.getAdmissionResponse());
        this.withAdmissionReview(instance.getAdmissionReview());
        this.withAdmissionWebhook(instance.getAdmissionWebhook());
        this.withAggregationRule(instance.getAggregationRule());
        this.withBaseKubernetesList(instance.getBaseKubernetesList());
        this.withBinding(instance.getBinding());
        this.withBuildConfigList(instance.getBuildConfigList());
        this.withBuildList(instance.getBuildList());
        this.withBuildRequest(instance.getBuildRequest());
        this.withCertificateSigningRequest(instance.getCertificateSigningRequest());
        this.withCertificateSigningRequestCondition(instance.getCertificateSigningRequestCondition());
        this.withCertificateSigningRequestList(instance.getCertificateSigningRequestList());
        this.withCertificateSigningRequestSpec(instance.getCertificateSigningRequestSpec());
        this.withCertificateSigningRequestStatus(instance.getCertificateSigningRequestStatus());
        this.withClusterRole(instance.getClusterRole());
        this.withClusterRoleBinding(instance.getClusterRoleBinding());
        this.withClusterRoleBindingList(instance.getClusterRoleBindingList());
        this.withClusterRoleList(instance.getClusterRoleList());
        this.withComponentStatusList(instance.getComponentStatusList());
        this.withConfig(instance.getConfig());
        this.withConfigMap(instance.getConfigMap());
        this.withConfigMapList(instance.getConfigMapList());
        this.withContainerStatus(instance.getContainerStatus());
        this.withCronJob(instance.getCronJob());
        this.withCronJobList(instance.getCronJobList());
        this.withCustomResourceDefinition(instance.getCustomResourceDefinition());
        this.withCustomResourceDefinitionCondition(instance.getCustomResourceDefinitionCondition());
        this.withCustomResourceDefinitionList(instance.getCustomResourceDefinitionList());
        this.withCustomResourceDefinitionNames(instance.getCustomResourceDefinitionNames());
        this.withCustomResourceDefinitionSpec(instance.getCustomResourceDefinitionSpec());
        this.withCustomResourceDefinitionStatus(instance.getCustomResourceDefinitionStatus());
        this.withDaemonSet(instance.getDaemonSet());
        this.withDaemonSetList(instance.getDaemonSetList());
        this.withDeleteOptions(instance.getDeleteOptions());
        this.withDeployment(instance.getDeployment());
        this.withDeploymentConfig(instance.getDeploymentConfig());
        this.withDeploymentConfigList(instance.getDeploymentConfigList());
        this.withDeploymentList(instance.getDeploymentList());
        this.withDeploymentRollback(instance.getDeploymentRollback());
        this.withEndpoints(instance.getEndpoints());
        this.withEndpointsList(instance.getEndpointsList());
        this.withEnvVar(instance.getEnvVar());
        this.withEvent(instance.getEvent());
        this.withEventList(instance.getEventList());
        this.withEventSeries(instance.getEventSeries());
        this.withEventSeriesState(instance.getEventSeriesState());
        this.withGroup(instance.getGroup());
        this.withGroupList(instance.getGroupList());
        this.withHorizontalPodAutoscaler(instance.getHorizontalPodAutoscaler());
        this.withHorizontalPodAutoscalerList(instance.getHorizontalPodAutoscalerList());
        this.withIdentity(instance.getIdentity());
        this.withIdentityList(instance.getIdentityList());
        this.withImageList(instance.getImageList());
        this.withImageStreamImport(instance.getImageStreamImport());
        this.withImageStreamList(instance.getImageStreamList());
        this.withImageStreamTagList(instance.getImageStreamTagList());
        this.withInfo(instance.getInfo());
        this.withIngress(instance.getIngress());
        this.withIngressList(instance.getIngressList());
        this.withInitializer(instance.getInitializer());
        this.withInitializers(instance.getInitializers());
        this.withJSONSchemaPropsorStringArray(instance.getJSONSchemaPropsorStringArray());
        this.withJob(instance.getJob());
        this.withJobList(instance.getJobList());
        this.withK8sLocalSubjectAccessReview(instance.getK8sLocalSubjectAccessReview());
        this.withK8sSubjectAccessReview(instance.getK8sSubjectAccessReview());
        this.withLimitRangeList(instance.getLimitRangeList());
        this.withLocalSubjectAccessReview(instance.getLocalSubjectAccessReview());
        this.withMutatingWebhookConfiguration(instance.getMutatingWebhookConfiguration());
        this.withMutatingWebhookConfigurationList(instance.getMutatingWebhookConfigurationList());
        this.withNamespace(instance.getNamespace());
        this.withNamespaceList(instance.getNamespaceList());
        this.withNetNameSpace(instance.getNetNameSpace());
        this.withNetNameSpaceList(instance.getNetNameSpaceList());
        this.withNetworkPolicy(instance.getNetworkPolicy());
        this.withNetworkPolicyList(instance.getNetworkPolicyList());
        this.withNode(instance.getNode());
        this.withNodeList(instance.getNodeList());
        this.withOAuthAccessToken(instance.getOAuthAccessToken());
        this.withOAuthAccessTokenList(instance.getOAuthAccessTokenList());
        this.withOAuthAuthorizeToken(instance.getOAuthAuthorizeToken());
        this.withOAuthAuthorizeTokenList(instance.getOAuthAuthorizeTokenList());
        this.withOAuthClient(instance.getOAuthClient());
        this.withOAuthClientAuthorization(instance.getOAuthClientAuthorization());
        this.withOAuthClientAuthorizationList(instance.getOAuthClientAuthorizationList());
        this.withOAuthClientList(instance.getOAuthClientList());
        this.withObjectMeta(instance.getObjectMeta());
        this.withOpenshiftClusterRole(instance.getOpenshiftClusterRole());
        this.withOpenshiftClusterRoleBinding(instance.getOpenshiftClusterRoleBinding());
        this.withOpenshiftClusterRoleBindingList(instance.getOpenshiftClusterRoleBindingList());
        this.withOpenshiftRole(instance.getOpenshiftRole());
        this.withOpenshiftRoleBinding(instance.getOpenshiftRoleBinding());
        this.withOpenshiftRoleBindingList(instance.getOpenshiftRoleBindingList());
        this.withOpenshiftRoleBindingRestriction(instance.getOpenshiftRoleBindingRestriction());
        this.withOpenshiftRoleList(instance.getOpenshiftRoleList());
        this.withOperation(instance.getOperation());
        this.withPatch(instance.getPatch());
        this.withPatchType(instance.getPatchType());
        this.withPersistentVolume(instance.getPersistentVolume());
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        this.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList());
        this.withPersistentVolumeList(instance.getPersistentVolumeList());
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        this.withPodDisruptionBudgetList(instance.getPodDisruptionBudgetList());
        this.withPodList(instance.getPodList());
        this.withPodPreset(instance.getPodPreset());
        this.withPodPresetList(instance.getPodPresetList());
        this.withPodPresetSpec(instance.getPodPresetSpec());
        this.withPodSecurityPolicy(instance.getPodSecurityPolicy());
        this.withPodSecurityPolicyList(instance.getPodSecurityPolicyList());
        this.withPodTemplateList(instance.getPodTemplateList());
        this.withPriorityClass(instance.getPriorityClass());
        this.withPriorityClassList(instance.getPriorityClassList());
        this.withProject(instance.getProject());
        this.withProjectList(instance.getProjectList());
        this.withProjectRequest(instance.getProjectRequest());
        this.withQuantity(instance.getQuantity());
        this.withReplicaSet(instance.getReplicaSet());
        this.withReplicaSetList(instance.getReplicaSetList());
        this.withReplicationControllerList(instance.getReplicationControllerList());
        this.withResourceQuota(instance.getResourceQuota());
        this.withResourceQuotaList(instance.getResourceQuotaList());
        this.withRole(instance.getRole());
        this.withRoleBinding(instance.getRoleBinding());
        this.withRoleBindingList(instance.getRoleBindingList());
        this.withRoleList(instance.getRoleList());
        this.withRootPaths(instance.getRootPaths());
        this.withRoute(instance.getRoute());
        this.withRouteList(instance.getRouteList());
        this.withRule(instance.getRule());
        this.withRuleWithOperations(instance.getRuleWithOperations());
        this.withScale(instance.getScale());
        this.withSecret(instance.getSecret());
        this.withSecretList(instance.getSecretList());
        this.withSecurityContextConstraints(instance.getSecurityContextConstraints());
        this.withSecurityContextConstraintsList(instance.getSecurityContextConstraintsList());
        this.withSelfSubjectAccessReview(instance.getSelfSubjectAccessReview());
        this.withSelfSubjectRulesReview(instance.getSelfSubjectRulesReview());
        this.withServiceAccount(instance.getServiceAccount());
        this.withServiceAccountList(instance.getServiceAccountList());
        this.withServiceList(instance.getServiceList());
        this.withStatefulSet(instance.getStatefulSet());
        this.withStatefulSetList(instance.getStatefulSetList());
        this.withStatus(instance.getStatus());
        this.withStorageClass(instance.getStorageClass());
        this.withStorageClassList(instance.getStorageClassList());
        this.withSubjectAccessReview(instance.getSubjectAccessReview());
        this.withSubjectAccessReviewResponse(instance.getSubjectAccessReviewResponse());
        this.withTagEvent(instance.getTagEvent());
        this.withTemplate(instance.getTemplate());
        this.withTemplateList(instance.getTemplateList());
        this.withTokenReview(instance.getTokenReview());
        this.withToleration(instance.getToleration());
        this.withTypeMeta(instance.getTypeMeta());
        this.withUser(instance.getUser());
        this.withUserList(instance.getUserList());
        this.withValidatingWebhookConfiguration(instance.getValidatingWebhookConfiguration());
        this.withValidatingWebhookConfigurationList(instance.getValidatingWebhookConfigurationList());
        this.withWatchEvent(instance.getWatchEvent());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public KubeSchema build() {
        KubeSchema buildable = new KubeSchema(this.fluent.getAPIGroup(), this.fluent.getAPIGroupList(), this.fluent.getAdmissionRequest(), this.fluent.getAdmissionResponse(), this.fluent.getAdmissionReview(), this.fluent.getAdmissionWebhook(), this.fluent.getAggregationRule(), this.fluent.getBaseKubernetesList(), this.fluent.getBinding(), this.fluent.getBuildConfigList(), this.fluent.getBuildList(), this.fluent.getBuildRequest(), this.fluent.getCertificateSigningRequest(), this.fluent.getCertificateSigningRequestCondition(), this.fluent.getCertificateSigningRequestList(), this.fluent.getCertificateSigningRequestSpec(), this.fluent.getCertificateSigningRequestStatus(), this.fluent.getClusterRole(), this.fluent.getClusterRoleBinding(), this.fluent.getClusterRoleBindingList(), this.fluent.getClusterRoleList(), this.fluent.getComponentStatusList(), this.fluent.getConfig(), this.fluent.getConfigMap(), this.fluent.getConfigMapList(), this.fluent.getContainerStatus(), this.fluent.getCronJob(), this.fluent.getCronJobList(), this.fluent.getCustomResourceDefinition(), this.fluent.getCustomResourceDefinitionCondition(), this.fluent.getCustomResourceDefinitionList(), this.fluent.getCustomResourceDefinitionNames(), this.fluent.getCustomResourceDefinitionSpec(), this.fluent.getCustomResourceDefinitionStatus(), this.fluent.getDaemonSet(), this.fluent.getDaemonSetList(), this.fluent.getDeleteOptions(), this.fluent.getDeployment(), this.fluent.getDeploymentConfig(), this.fluent.getDeploymentConfigList(), this.fluent.getDeploymentList(), this.fluent.getDeploymentRollback(), this.fluent.getEndpoints(), this.fluent.getEndpointsList(), this.fluent.getEnvVar(), this.fluent.getEvent(), this.fluent.getEventList(), this.fluent.getEventSeries(), this.fluent.getEventSeriesState(), this.fluent.getGroup(), this.fluent.getGroupList(), this.fluent.getHorizontalPodAutoscaler(), this.fluent.getHorizontalPodAutoscalerList(), this.fluent.getIdentity(), this.fluent.getIdentityList(), this.fluent.getImageList(), this.fluent.getImageStreamImport(), this.fluent.getImageStreamList(), this.fluent.getImageStreamTagList(), this.fluent.getInfo(), this.fluent.getIngress(), this.fluent.getIngressList(), this.fluent.getInitializer(), this.fluent.getInitializers(), this.fluent.getJSONSchemaPropsorStringArray(), this.fluent.getJob(), this.fluent.getJobList(), this.fluent.getK8sLocalSubjectAccessReview(), this.fluent.getK8sSubjectAccessReview(), this.fluent.getLimitRangeList(), this.fluent.getLocalSubjectAccessReview(), this.fluent.getMutatingWebhookConfiguration(), this.fluent.getMutatingWebhookConfigurationList(), this.fluent.getNamespace(), this.fluent.getNamespaceList(), this.fluent.getNetNameSpace(), this.fluent.getNetNameSpaceList(), this.fluent.getNetworkPolicy(), this.fluent.getNetworkPolicyList(), this.fluent.getNode(), this.fluent.getNodeList(), this.fluent.getOAuthAccessToken(), this.fluent.getOAuthAccessTokenList(), this.fluent.getOAuthAuthorizeToken(), this.fluent.getOAuthAuthorizeTokenList(), this.fluent.getOAuthClient(), this.fluent.getOAuthClientAuthorization(), this.fluent.getOAuthClientAuthorizationList(), this.fluent.getOAuthClientList(), this.fluent.getObjectMeta(), this.fluent.getOpenshiftClusterRole(), this.fluent.getOpenshiftClusterRoleBinding(), this.fluent.getOpenshiftClusterRoleBindingList(), this.fluent.getOpenshiftRole(), this.fluent.getOpenshiftRoleBinding(), this.fluent.getOpenshiftRoleBindingList(), this.fluent.getOpenshiftRoleBindingRestriction(), this.fluent.getOpenshiftRoleList(), this.fluent.getOperation(), this.fluent.getPatch(), this.fluent.getPatchType(), this.fluent.getPersistentVolume(), this.fluent.getPersistentVolumeClaim(), this.fluent.getPersistentVolumeClaimList(), this.fluent.getPersistentVolumeList(), this.fluent.getPodDisruptionBudget(), this.fluent.getPodDisruptionBudgetList(), this.fluent.getPodList(), this.fluent.getPodPreset(), this.fluent.getPodPresetList(), this.fluent.getPodPresetSpec(), this.fluent.getPodSecurityPolicy(), this.fluent.getPodSecurityPolicyList(), this.fluent.getPodTemplateList(), this.fluent.getPriorityClass(), this.fluent.getPriorityClassList(), this.fluent.getProject(), this.fluent.getProjectList(), this.fluent.getProjectRequest(), this.fluent.getQuantity(), this.fluent.getReplicaSet(), this.fluent.getReplicaSetList(), this.fluent.getReplicationControllerList(), this.fluent.getResourceQuota(), this.fluent.getResourceQuotaList(), this.fluent.getRole(), this.fluent.getRoleBinding(), this.fluent.getRoleBindingList(), this.fluent.getRoleList(), this.fluent.getRootPaths(), this.fluent.getRoute(), this.fluent.getRouteList(), this.fluent.getRule(), this.fluent.getRuleWithOperations(), this.fluent.getScale(), this.fluent.getSecret(), this.fluent.getSecretList(), this.fluent.getSecurityContextConstraints(), this.fluent.getSecurityContextConstraintsList(), this.fluent.getSelfSubjectAccessReview(), this.fluent.getSelfSubjectRulesReview(), this.fluent.getServiceAccount(), this.fluent.getServiceAccountList(), this.fluent.getServiceList(), this.fluent.getStatefulSet(), this.fluent.getStatefulSetList(), this.fluent.getStatus(), this.fluent.getStorageClass(), this.fluent.getStorageClassList(), this.fluent.getSubjectAccessReview(), this.fluent.getSubjectAccessReviewResponse(), this.fluent.getTagEvent(), this.fluent.getTemplate(), this.fluent.getTemplateList(), this.fluent.getTokenReview(), this.fluent.getToleration(), this.fluent.getTypeMeta(), this.fluent.getUser(), this.fluent.getUserList(), this.fluent.getValidatingWebhookConfiguration(), this.fluent.getValidatingWebhookConfigurationList(), this.fluent.getWatchEvent());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubeSchemaBuilder that = (KubeSchemaBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

