/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.HorizontalPodAutoscalerStatus;
import io.fabric8.kubernetes.api.model.v4_4.HorizontalPodAutoscalerStatusFluent;
import io.fabric8.kubernetes.api.model.v4_4.HorizontalPodAutoscalerStatusFluentImpl;
import javax.validation.Validator;

public class HorizontalPodAutoscalerStatusBuilder
extends HorizontalPodAutoscalerStatusFluentImpl<HorizontalPodAutoscalerStatusBuilder>
implements VisitableBuilder<HorizontalPodAutoscalerStatus, HorizontalPodAutoscalerStatusBuilder> {
    HorizontalPodAutoscalerStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public HorizontalPodAutoscalerStatusBuilder() {
        this(true);
    }

    public HorizontalPodAutoscalerStatusBuilder(Boolean validationEnabled) {
        this(new HorizontalPodAutoscalerStatus(), validationEnabled);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HorizontalPodAutoscalerStatus(), validationEnabled);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent, HorizontalPodAutoscalerStatus instance) {
        this(fluent, instance, true);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent, HorizontalPodAutoscalerStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage());
        fluent.withCurrentReplicas(instance.getCurrentReplicas());
        fluent.withDesiredReplicas(instance.getDesiredReplicas());
        fluent.withLastScaleTime(instance.getLastScaleTime());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        this.validationEnabled = validationEnabled;
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatus instance) {
        this(instance, (Boolean)true);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage());
        this.withCurrentReplicas(instance.getCurrentReplicas());
        this.withDesiredReplicas(instance.getDesiredReplicas());
        this.withLastScaleTime(instance.getLastScaleTime());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.validationEnabled = validationEnabled;
    }

    public HorizontalPodAutoscalerStatusBuilder(Validator validator) {
        this(new HorizontalPodAutoscalerStatus(), (Boolean)true);
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent, HorizontalPodAutoscalerStatus instance, Validator validator) {
        this.fluent = fluent;
        fluent.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage());
        fluent.withCurrentReplicas(instance.getCurrentReplicas());
        fluent.withDesiredReplicas(instance.getDesiredReplicas());
        fluent.withLastScaleTime(instance.getLastScaleTime());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatus instance, Validator validator) {
        this.fluent = this;
        this.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage());
        this.withCurrentReplicas(instance.getCurrentReplicas());
        this.withDesiredReplicas(instance.getDesiredReplicas());
        this.withLastScaleTime(instance.getLastScaleTime());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public HorizontalPodAutoscalerStatus build() {
        HorizontalPodAutoscalerStatus buildable = new HorizontalPodAutoscalerStatus(this.fluent.getCurrentCPUUtilizationPercentage(), this.fluent.getCurrentReplicas(), this.fluent.getDesiredReplicas(), this.fluent.getLastScaleTime(), this.fluent.getObservedGeneration());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerStatusBuilder that = (HorizontalPodAutoscalerStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

