/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_4.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_4.Doneable;
import io.fabric8.kubernetes.api.model.v4_4.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_4.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v4_4.Config;
import io.fabric8.kubernetes.clnt.v4_4.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_4.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_4.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v4_4.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v4_4.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v4_4.utils.Utils;
import io.fabric8.openshift.clnt.v4_4.DefaultOpenShiftClient;
import io.fabric8.openshift.clnt.v4_4.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_4.OpenShiftConfigBuilder;
import java.net.MalformedURLException;
import java.net.URL;

public class OpenShiftOperation<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends Resource<T, D>>
extends HasMetadataOperation<T, L, D, R> {
    public OpenShiftOperation(OperationContext ctx) {
        super(OpenShiftOperation.wrap(ctx));
    }

    private static OperationContext wrap(OperationContext context) {
        OpenShiftConfig config = OpenShiftConfig.wrap(context.getConfig());
        String oapiVersion = config.getOapiVersion();
        if (Utils.isNotNullOrEmpty(context.getApiGroupName())) {
            try (DefaultOpenShiftClient oc = new DefaultOpenShiftClient(context.getClient(), config);){
                if (config.isOpenShiftAPIGroups(oc)) {
                    String apiGroupUrl = URLUtils.join(config.getMasterUrl(), "apis", context.getApiGroupName(), oapiVersion);
                    String apiGroupVersion = URLUtils.join(context.getApiGroupName(), oapiVersion);
                    OperationContext operationContext = context.withConfig(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupName(context.getApiGroupName()).withApiGroupVersion(apiGroupVersion);
                    return operationContext;
                }
                String apiGroupUrl = URLUtils.join(config.getMasterUrl(), "oapi", oapiVersion);
                OperationContext operationContext = context.withConfig(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupName(context.getApiGroupName()).withApiGroupVersion(oapiVersion);
                return operationContext;
            }
        }
        String apiGroupUrl = URLUtils.join(config.getMasterUrl(), "oapi", oapiVersion);
        return context.withConfig(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupVersion(oapiVersion);
    }

    @Override
    public OpenShiftConfig getConfig() {
        return OpenShiftConfig.wrap(super.getConfig());
    }

    @Override
    public URL getRootUrl() {
        if (Utils.isNullOrEmpty(this.context.getApiGroupName())) {
            try {
                return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
            }
            catch (MalformedURLException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }
        return super.getRootUrl();
    }

    @Override
    protected Class<? extends Config> getConfigType() {
        return OpenShiftConfig.class;
    }
}

