/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_4.OAuthClient;
import io.fabric8.openshift.api.model.v4_4.OAuthClientFluent;
import io.fabric8.openshift.api.model.v4_4.OAuthClientFluentImpl;
import javax.validation.Validator;

public class OAuthClientBuilder
extends OAuthClientFluentImpl<OAuthClientBuilder>
implements VisitableBuilder<OAuthClient, OAuthClientBuilder> {
    OAuthClientFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public OAuthClientBuilder() {
        this(true);
    }

    public OAuthClientBuilder(Boolean validationEnabled) {
        this(new OAuthClient(), validationEnabled);
    }

    public OAuthClientBuilder(OAuthClientFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public OAuthClientBuilder(OAuthClientFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new OAuthClient(), validationEnabled);
    }

    public OAuthClientBuilder(OAuthClientFluent<?> fluent, OAuthClient instance) {
        this(fluent, instance, true);
    }

    public OAuthClientBuilder(OAuthClientFluent<?> fluent, OAuthClient instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
        fluent.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
        fluent.withAdditionalSecrets(instance.getAdditionalSecrets());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withGrantMethod(instance.getGrantMethod());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRedirectURIs(instance.getRedirectURIs());
        fluent.withRespondWithChallenges(instance.getRespondWithChallenges());
        fluent.withScopeRestrictions(instance.getScopeRestrictions());
        fluent.withSecret(instance.getSecret());
        this.validationEnabled = validationEnabled;
    }

    public OAuthClientBuilder(OAuthClient instance) {
        this(instance, (Boolean)true);
    }

    public OAuthClientBuilder(OAuthClient instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
        this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
        this.withAdditionalSecrets(instance.getAdditionalSecrets());
        this.withApiVersion(instance.getApiVersion());
        this.withGrantMethod(instance.getGrantMethod());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRedirectURIs(instance.getRedirectURIs());
        this.withRespondWithChallenges(instance.getRespondWithChallenges());
        this.withScopeRestrictions(instance.getScopeRestrictions());
        this.withSecret(instance.getSecret());
        this.validationEnabled = validationEnabled;
    }

    public OAuthClientBuilder(Validator validator) {
        this(new OAuthClient(), (Boolean)true);
    }

    public OAuthClientBuilder(OAuthClientFluent<?> fluent, OAuthClient instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
        fluent.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
        fluent.withAdditionalSecrets(instance.getAdditionalSecrets());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withGrantMethod(instance.getGrantMethod());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRedirectURIs(instance.getRedirectURIs());
        fluent.withRespondWithChallenges(instance.getRespondWithChallenges());
        fluent.withScopeRestrictions(instance.getScopeRestrictions());
        fluent.withSecret(instance.getSecret());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public OAuthClientBuilder(OAuthClient instance, Validator validator) {
        this.fluent = this;
        this.withAccessTokenInactivityTimeoutSeconds(instance.getAccessTokenInactivityTimeoutSeconds());
        this.withAccessTokenMaxAgeSeconds(instance.getAccessTokenMaxAgeSeconds());
        this.withAdditionalSecrets(instance.getAdditionalSecrets());
        this.withApiVersion(instance.getApiVersion());
        this.withGrantMethod(instance.getGrantMethod());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRedirectURIs(instance.getRedirectURIs());
        this.withRespondWithChallenges(instance.getRespondWithChallenges());
        this.withScopeRestrictions(instance.getScopeRestrictions());
        this.withSecret(instance.getSecret());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public OAuthClient build() {
        OAuthClient buildable = new OAuthClient(this.fluent.getAccessTokenInactivityTimeoutSeconds(), this.fluent.getAccessTokenMaxAgeSeconds(), this.fluent.getAdditionalSecrets(), this.fluent.getApiVersion(), this.fluent.getGrantMethod(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRedirectURIs(), this.fluent.isRespondWithChallenges(), this.fluent.getScopeRestrictions(), this.fluent.getSecret());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthClientBuilder that = (OAuthClientBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

