/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v4_4.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.v4_4.ResourceRequirementsFluentImpl;
import javax.validation.Validator;

public class ResourceRequirementsBuilder
extends ResourceRequirementsFluentImpl<ResourceRequirementsBuilder>
implements VisitableBuilder<ResourceRequirements, ResourceRequirementsBuilder> {
    ResourceRequirementsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ResourceRequirementsBuilder() {
        this(true);
    }

    public ResourceRequirementsBuilder(Boolean validationEnabled) {
        this(new ResourceRequirements(), validationEnabled);
    }

    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceRequirements(), validationEnabled);
    }

    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent, ResourceRequirements instance) {
        this(fluent, instance, true);
    }

    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent, ResourceRequirements instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLimits(instance.getLimits());
        fluent.withRequests(instance.getRequests());
        this.validationEnabled = validationEnabled;
    }

    public ResourceRequirementsBuilder(ResourceRequirements instance) {
        this(instance, (Boolean)true);
    }

    public ResourceRequirementsBuilder(ResourceRequirements instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLimits(instance.getLimits());
        this.withRequests(instance.getRequests());
        this.validationEnabled = validationEnabled;
    }

    public ResourceRequirementsBuilder(Validator validator) {
        this(new ResourceRequirements(), (Boolean)true);
    }

    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent, ResourceRequirements instance, Validator validator) {
        this.fluent = fluent;
        fluent.withLimits(instance.getLimits());
        fluent.withRequests(instance.getRequests());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ResourceRequirementsBuilder(ResourceRequirements instance, Validator validator) {
        this.fluent = this;
        this.withLimits(instance.getLimits());
        this.withRequests(instance.getRequests());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public ResourceRequirements build() {
        ResourceRequirements buildable = new ResourceRequirements(this.fluent.getLimits(), this.fluent.getRequests());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceRequirementsBuilder that = (ResourceRequirementsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

