/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_4;

import io.fabric8.kubernetes.api.builder.v4_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_4.PreferredSchedulingTerm;
import io.fabric8.kubernetes.api.model.v4_4.PreferredSchedulingTermFluent;
import io.fabric8.kubernetes.api.model.v4_4.PreferredSchedulingTermFluentImpl;
import javax.validation.Validator;

public class PreferredSchedulingTermBuilder
extends PreferredSchedulingTermFluentImpl<PreferredSchedulingTermBuilder>
implements VisitableBuilder<PreferredSchedulingTerm, PreferredSchedulingTermBuilder> {
    PreferredSchedulingTermFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PreferredSchedulingTermBuilder() {
        this(true);
    }

    public PreferredSchedulingTermBuilder(Boolean validationEnabled) {
        this(new PreferredSchedulingTerm(), validationEnabled);
    }

    public PreferredSchedulingTermBuilder(PreferredSchedulingTermFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PreferredSchedulingTermBuilder(PreferredSchedulingTermFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PreferredSchedulingTerm(), validationEnabled);
    }

    public PreferredSchedulingTermBuilder(PreferredSchedulingTermFluent<?> fluent, PreferredSchedulingTerm instance) {
        this(fluent, instance, true);
    }

    public PreferredSchedulingTermBuilder(PreferredSchedulingTermFluent<?> fluent, PreferredSchedulingTerm instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPreference(instance.getPreference());
        fluent.withWeight(instance.getWeight());
        this.validationEnabled = validationEnabled;
    }

    public PreferredSchedulingTermBuilder(PreferredSchedulingTerm instance) {
        this(instance, (Boolean)true);
    }

    public PreferredSchedulingTermBuilder(PreferredSchedulingTerm instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPreference(instance.getPreference());
        this.withWeight(instance.getWeight());
        this.validationEnabled = validationEnabled;
    }

    public PreferredSchedulingTermBuilder(Validator validator) {
        this(new PreferredSchedulingTerm(), (Boolean)true);
    }

    public PreferredSchedulingTermBuilder(PreferredSchedulingTermFluent<?> fluent, PreferredSchedulingTerm instance, Validator validator) {
        this.fluent = fluent;
        fluent.withPreference(instance.getPreference());
        fluent.withWeight(instance.getWeight());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PreferredSchedulingTermBuilder(PreferredSchedulingTerm instance, Validator validator) {
        this.fluent = this;
        this.withPreference(instance.getPreference());
        this.withWeight(instance.getWeight());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public PreferredSchedulingTerm build() {
        PreferredSchedulingTerm buildable = new PreferredSchedulingTerm(this.fluent.getPreference(), this.fluent.getWeight());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PreferredSchedulingTermBuilder that = (PreferredSchedulingTermBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

